/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.CastTemplate;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.TypeReference;

public class Cast
extends AbstractNode
implements Expression {
    private List<Position> parensPositions = new ArrayList<Position>();
    private AbstractNode typeReference = null;
    private AbstractNode operand = null;

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public TypeReference astTypeReference() {
        if (!(this.typeReference instanceof TypeReference)) {
            return null;
        }
        return (TypeReference)this.typeReference;
    }

    public Cast astTypeReference(TypeReference typeReference) {
        if (typeReference == null) {
            throw new NullPointerException("typeReference is mandatory");
        }
        return this.rawTypeReference(typeReference);
    }

    public Node rawTypeReference() {
        return this.typeReference;
    }

    public Cast rawTypeReference(Node typeReference) {
        if (typeReference == this.typeReference) {
            return this;
        }
        if (typeReference != null) {
            this.adopt((AbstractNode)typeReference);
        }
        if (this.typeReference != null) {
            this.disown(this.typeReference);
        }
        this.typeReference = (AbstractNode)typeReference;
        return this;
    }

    public Expression astOperand() {
        if (!(this.operand instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.operand);
    }

    public Cast astOperand(Expression operand) {
        if (operand == null) {
            throw new NullPointerException("operand is mandatory");
        }
        return this.rawOperand(operand);
    }

    public Node rawOperand() {
        return this.operand;
    }

    public Cast rawOperand(Node operand) {
        if (operand == this.operand) {
            return this;
        }
        if (operand != null) {
            this.adopt((AbstractNode)operand);
        }
        if (this.operand != null) {
            this.disown(this.operand);
        }
        this.operand = (AbstractNode)operand;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.typeReference != null) {
            result.add(this.typeReference);
        }
        if (this.operand != null) {
            result.add(this.operand);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.typeReference == original) {
            this.rawTypeReference(replacement);
            return true;
        }
        if (this.operand == original) {
            this.rawOperand(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.typeReference == child) {
            this.disown((AbstractNode)child);
            this.typeReference = null;
            return true;
        }
        if (this.operand == child) {
            this.disown((AbstractNode)child);
            this.operand = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitCast(this)) {
            return;
        }
        if (this.typeReference != null) {
            this.typeReference.accept(visitor);
        }
        if (this.operand != null) {
            this.operand.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public Cast copy() {
        Cast result = new Cast();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        if (this.typeReference != null) {
            result.rawTypeReference(this.typeReference.copy());
        }
        if (this.operand != null) {
            result.rawOperand(this.operand.copy());
        }
        return result;
    }

    @Override
    public boolean needsParentheses() {
        return CastTemplate.needsParentheses(this);
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

