/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.vmtrace;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VmTraceOptionsDialog
extends Dialog {
    private static final int DEFAULT_SAMPLING_INTERVAL_US = 1000;
    private static boolean sTracingEnabled = true;
    private static int sSamplingIntervalUs = 1000;

    public VmTraceOptionsDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Profiling Options");
    }

    @Override
    protected Control createDialogArea(Composite shell) {
        int horizontalIndent = 30;
        Composite parent = (Composite)super.createDialogArea(shell);
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(1808));
        final Button useTracingButton = new Button(c, 16);
        useTracingButton.setText("Trace based profiling");
        useTracingButton.setSelection(sTracingEnabled);
        GridData gd = new GridData(32, 4, true, true, 2, 1);
        useTracingButton.setLayoutData((Object)gd);
        Label l = new Label(c, 0);
        l.setText("Trace based profiling works by tracing the entry and exit of every method.\nThis gives an accurate view of the execution, but has a high overhead.");
        gd = new GridData(32, 4, true, true, 2, 1);
        gd.horizontalIndent = horizontalIndent;
        l.setLayoutData((Object)gd);
        Button useSamplingButton = new Button(c, 16);
        useSamplingButton.setText("Sample based profiling");
        useSamplingButton.setSelection(!sTracingEnabled);
        gd = new GridData(32, 4, true, true, 2, 1);
        useSamplingButton.setLayoutData((Object)gd);
        l = new Label(c, 0);
        l.setText("Sample based profiling works by interrupting the VM at a given frequency and collecting the call stacks at that time.\nThis has a much lower overhead, but statistical sampling requires longer runs to obtain a representative sample.");
        gd = new GridData(32, 4, true, true, 2, 1);
        gd.horizontalIndent = horizontalIndent;
        l.setLayoutData((Object)gd);
        l = new Label(c, 0);
        l.setText("Sampling frequency (microseconds): ");
        gd = new GridData(32, 8, false, true);
        gd.horizontalIndent = horizontalIndent;
        l.setLayoutData((Object)gd);
        final Text samplingIntervalTextField = new Text(c, 2048);
        gd = new GridData(32, 4, true, true);
        gd.widthHint = 100;
        samplingIntervalTextField.setLayoutData((Object)gd);
        samplingIntervalTextField.setEnabled(!sTracingEnabled);
        samplingIntervalTextField.setText(Integer.toString(sSamplingIntervalUs));
        samplingIntervalTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                int v = this.getIntegerValue(samplingIntervalTextField.getText());
                VmTraceOptionsDialog.this.getButton(0).setEnabled(v > 0);
                sSamplingIntervalUs = v > 0 ? v : 1000;
            }

            private int getIntegerValue(String text) {
                try {
                    return Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
        });
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                sTracingEnabled = useTracingButton.getSelection();
                samplingIntervalTextField.setEnabled(!sTracingEnabled);
            }
        };
        useTracingButton.addSelectionListener((SelectionListener)selectionAdapter);
        useSamplingButton.addSelectionListener((SelectionListener)selectionAdapter);
        return c;
    }

    public boolean shouldUseTracing() {
        return sTracingEnabled;
    }

    public int getSamplingIntervalMicros() {
        return sSamplingIntervalUs;
    }
}

