/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegionQualifier
extends ResourceQualifier {
    private static final Pattern sRegionPattern = Pattern.compile("^r([A-Z]{2})$");
    public static final String FAKE_REGION_VALUE = "__";
    public static final String NAME = "Region";
    private String mValue;

    public static RegionQualifier getQualifier(String segment) {
        Matcher m = sRegionPattern.matcher(segment);
        if (m.matches()) {
            RegionQualifier qualifier = new RegionQualifier();
            qualifier.mValue = m.group(1);
            return qualifier;
        }
        return null;
    }

    public static String getFolderSegment(String value) {
        String segment;
        if (value != null && sRegionPattern.matcher(segment = "r" + value.toUpperCase(Locale.US)).matches()) {
            return segment;
        }
        return "";
    }

    public RegionQualifier() {
    }

    public RegionQualifier(String value) {
        this.mValue = value;
    }

    public String getValue() {
        if (this.mValue != null) {
            return this.mValue;
        }
        return "";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public int since() {
        return 1;
    }

    @Override
    public boolean isValid() {
        return this.mValue != null;
    }

    @Override
    public boolean hasFakeValue() {
        return FAKE_REGION_VALUE.equals(this.mValue);
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        RegionQualifier qualifier = RegionQualifier.getQualifier(value);
        if (qualifier != null) {
            config.setRegionQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object qualifier) {
        if (qualifier instanceof RegionQualifier) {
            if (this.mValue == null) {
                return ((RegionQualifier)qualifier).mValue == null;
            }
            return this.mValue.equals(((RegionQualifier)qualifier).mValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    @Override
    public String getFolderSegment() {
        return RegionQualifier.getFolderSegment(this.mValue);
    }

    @Override
    public String getShortDisplayValue() {
        if (this.mValue != null) {
            return this.mValue;
        }
        return "";
    }

    @Override
    public String getLongDisplayValue() {
        if (this.mValue != null) {
            return String.format("Region %s", this.mValue);
        }
        return "";
    }
}

