/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.FrameworkResourceItem;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.resources.ResourceType;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.kxml2.io.KXmlParser;

public class FrameworkResources
extends ResourceRepository {
    protected final Map<ResourceType, List<ResourceItem>> mPublicResourceMap = new EnumMap<ResourceType, List<ResourceItem>>(ResourceType.class);

    public FrameworkResources(@NonNull IAbstractFolder resFolder) {
        super(resFolder, true);
    }

    @NonNull
    public List<ResourceItem> getResourceItemsOfType(@NonNull ResourceType type) {
        return this.mPublicResourceMap.get((Object)type);
    }

    @Override
    public boolean hasResourcesOfType(@NonNull ResourceType type) {
        return this.mPublicResourceMap.get((Object)type).size() > 0;
    }

    @Override
    @NonNull
    protected ResourceItem createResourceItem(@NonNull String name) {
        return new FrameworkResourceItem(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPublicResources(@Nullable ILogger logger) {
        IAbstractFolder valueFolder = this.getResFolder().getFolder("values");
        if (!valueFolder.exists()) {
            return;
        }
        IAbstractFile publicXmlFile = valueFolder.getFile("public.xml");
        if (publicXmlFile.exists()) {
            Reader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(publicXmlFile.getContents(), Charsets.UTF_8));
                KXmlParser parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                parser.setInput(reader);
                ResourceType lastType = null;
                String lastTypeName = "";
                while (true) {
                    int event;
                    if ((event = parser.next()) == 2) {
                        if (!parser.getName().equals("public")) continue;
                        String name = null;
                        String typeName = null;
                        int n = parser.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            String attribute = parser.getAttributeName(i);
                            if (attribute.equals("name")) {
                                name = parser.getAttributeValue(i);
                                if (typeName == null) continue;
                                break;
                            }
                            if (!attribute.equals("type")) continue;
                            typeName = parser.getAttributeValue(i);
                        }
                        if (name == null || typeName == null) continue;
                        ResourceType type = null;
                        if (typeName.equals(lastTypeName)) {
                            type = lastType;
                        } else {
                            lastType = type = ResourceType.getEnum(typeName);
                            lastTypeName = typeName;
                        }
                        if (type == null) continue;
                        ResourceItem match = null;
                        Map map = (Map)this.mResourceMap.get((Object)type);
                        if (map != null) {
                            match = (ResourceItem)map.get(name);
                        }
                        if (match == null) continue;
                        List<ResourceItem> publicList = this.mPublicResourceMap.get((Object)type);
                        if (publicList == null) {
                            int size;
                            switch (type) {
                                case STYLE: {
                                    size = 500;
                                    break;
                                }
                                case ATTR: {
                                    size = 1000;
                                    break;
                                }
                                case DRAWABLE: {
                                    size = 200;
                                    break;
                                }
                                case ID: {
                                    size = 50;
                                    break;
                                }
                                case LAYOUT: 
                                case COLOR: 
                                case STRING: 
                                case ANIM: 
                                case INTERPOLATOR: {
                                    size = 30;
                                    break;
                                }
                                default: {
                                    size = 10;
                                }
                            }
                            publicList = new ArrayList<ResourceItem>(size);
                            this.mPublicResourceMap.put(type, publicList);
                        }
                        publicList.add(match);
                        continue;
                    }
                    if (event == 1) break;
                }
            }
            catch (Exception e) {
                if (logger != null) {
                    logger.error((Throwable)e, "Can't read and parse public attribute list", new Object[0]);
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        for (ResourceType type : ResourceType.values()) {
            List<ResourceItem> list = this.mPublicResourceMap.get((Object)type);
            list = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
            this.mPublicResourceMap.put(type, list);
        }
    }
}

