/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.annotations.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MavenCoordinate
implements Comparable<MavenCoordinate> {
    public static final int PLUS_REV = Integer.MAX_VALUE;
    private final String myGroupId;
    private final String myArtifactId;
    private final int myMajorRevision;
    private final int myMinorRevision;
    private final int myMicroRevision;
    private static final Pattern MAVEN_PATTERN = Pattern.compile("([\\w\\d\\.-]+):([\\w\\d\\.-]+):(\\d+)\\.(\\d+)\\.(\\d+|\\+)");

    public MavenCoordinate(String groupId, String artifactId, int majorRevision, int minorRevision, int microRevision) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myMajorRevision = majorRevision;
        this.myMinorRevision = minorRevision;
        this.myMicroRevision = microRevision;
    }

    @Nullable
    public static MavenCoordinate parseCoordinateString(String coordinateString) {
        if (coordinateString == null) {
            return null;
        }
        Matcher matcher = MAVEN_PATTERN.matcher(coordinateString);
        if (!matcher.matches()) {
            return null;
        }
        String groupId = matcher.group(1);
        String artifactId = matcher.group(2);
        try {
            int majorRevision = Integer.parseInt(matcher.group(3));
            int minorRevision = Integer.parseInt(matcher.group(4));
            String microRevisionString = matcher.group(5);
            int microRevision = microRevisionString.equals("+") ? Integer.MAX_VALUE : Integer.parseInt(microRevisionString);
            return new MavenCoordinate(groupId, artifactId, majorRevision, minorRevision, microRevision);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        String micro = this.myMicroRevision == Integer.MAX_VALUE ? "+" : Integer.toString(this.myMicroRevision);
        return String.format("%s:%s:%d.%d.%s", this.myGroupId, this.myArtifactId, this.myMajorRevision, this.myMinorRevision, micro);
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public String getId() {
        return String.format("%s:%s", this.myGroupId, this.myArtifactId);
    }

    public int getMajorRevision() {
        return this.myMajorRevision;
    }

    public int getMinorRevision() {
        return this.myMinorRevision;
    }

    public int getMicroRevision() {
        return this.myMicroRevision;
    }

    public boolean isSameArtifact(MavenCoordinate o) {
        return o.myGroupId.equals(this.myGroupId) && o.myArtifactId.equals(this.myArtifactId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenCoordinate that = (MavenCoordinate)o;
        if (this.myMajorRevision != that.myMajorRevision) {
            return false;
        }
        if (this.myMicroRevision != that.myMicroRevision) {
            return false;
        }
        if (this.myMinorRevision != that.myMinorRevision) {
            return false;
        }
        if (!this.myArtifactId.equals(that.myArtifactId)) {
            return false;
        }
        return this.myGroupId.equals(that.myGroupId);
    }

    public int hashCode() {
        int result = this.myGroupId.hashCode();
        result = 31 * result + this.myArtifactId.hashCode();
        result = 31 * result + this.myMajorRevision;
        result = 31 * result + this.myMinorRevision;
        result = 31 * result + this.myMicroRevision;
        return result;
    }

    @Override
    public int compareTo(MavenCoordinate that) {
        assert (this.isSameArtifact(that));
        if (this.myMajorRevision != that.myMajorRevision) {
            return this.myMajorRevision - that.myMajorRevision;
        }
        if (this.myMinorRevision != that.myMinorRevision) {
            return this.myMinorRevision - that.myMinorRevision;
        }
        if (this.myMicroRevision != that.myMicroRevision) {
            return this.myMicroRevision - that.myMicroRevision;
        }
        return 0;
    }
}

