/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.BuildTypedTask;
import com.android.ant.DependencyGraph;
import com.android.ant.InputPath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;

public abstract class SingleDependencyTask
extends BuildTypedTask {
    private DependencyGraph mDependencies;
    private static final InputPathFactory sDefaultFactory = new InputPathFactory(){

        @Override
        public InputPath createPath(File file, Set<String> extensionsToCheck) {
            return new InputPath(file, extensionsToCheck);
        }
    };

    protected abstract String getExecTaskName();

    protected static List<InputPath> getInputPaths(List<File> paths, Set<String> extensionsToCheck, InputPathFactory factory) {
        ArrayList<InputPath> result = new ArrayList<InputPath>(paths.size());
        if (factory == null) {
            factory = sDefaultFactory;
        }
        for (File f : paths) {
            result.add(factory.createPath(f, extensionsToCheck));
        }
        return result;
    }

    protected boolean initDependencies(String dependencyFile, List<InputPath> inputPaths) {
        if (this.hasBuildTypeChanged()) {
            return true;
        }
        File depFile = new File(dependencyFile);
        if (depFile.exists()) {
            this.mDependencies = new DependencyGraph(dependencyFile, inputPaths);
            return true;
        }
        return false;
    }

    protected boolean dependenciesHaveChanged() {
        if (this.hasBuildTypeChanged()) {
            if (!this.isNewBuild()) {
                String execName = this.getExecTaskName();
                if (execName == null) {
                    System.out.println("Current build type is different than previous build: forced task run.");
                } else {
                    System.out.println("Current build type is different than previous build: forced " + execName + " run.");
                }
            }
            return true;
        }
        assert (this.mDependencies != null) : "Dependencies have not been initialized";
        return this.mDependencies.dependenciesHaveChanged(true);
    }

    protected void generateDependencyFile(String depFilePath, List<InputPath> inputs, String outputFile) {
        File depFile = new File(depFilePath);
        try {
            PrintStream ps = new PrintStream(depFile);
            ps.print(outputFile);
            ps.println(" : \\");
            int count = inputs.size();
            for (int i = 0; i < count; ++i) {
                InputPath input = inputs.get(i);
                File file = input.getFile();
                if (file.isDirectory()) {
                    this.writeContent(ps, file, input);
                    continue;
                }
                ps.print(file.getAbsolutePath());
                ps.println(" \\");
            }
            ps.close();
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void writeContent(PrintStream ps, File file, InputPath input) {
        if (input.ignores(file)) {
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.writeContent(ps, f, input);
                    continue;
                }
                if (input.ignores(f)) continue;
                ps.print(f.getAbsolutePath());
                ps.println(" \\");
            }
        }
    }

    protected static interface InputPathFactory {
        public InputPath createPath(File var1, Set<String> var2);
    }
}

