/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ant.TaskHelper;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.utils.ILogger;
import com.android.xml.AndroidXPathFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.xml.sax.InputSource;

public class GetTargetTask
extends Task {
    private String mBootClassPathOut;
    private String mAndroidJarFileOut;
    private String mAndroidAidlFileOut;
    private String mTargetApiOut;
    private String mMinSdkVersionOut;

    public void setBootClassPathOut(String bootClassPathOut) {
        this.mBootClassPathOut = bootClassPathOut;
    }

    public void setAndroidJarFileOut(String androidJarFileOut) {
        this.mAndroidJarFileOut = androidJarFileOut;
    }

    public void setAndroidAidlFileOut(String androidAidlFileOut) {
        this.mAndroidAidlFileOut = androidAidlFileOut;
    }

    public void setTargetApiOut(String targetApiOut) {
        this.mTargetApiOut = targetApiOut;
    }

    public void setMinSdkVersionOut(String minSdkVersionOut) {
        this.mMinSdkVersionOut = minSdkVersionOut;
    }

    public void execute() throws BuildException {
        if (this.mBootClassPathOut == null) {
            throw new BuildException("Missing attribute bootClassPathOut");
        }
        if (this.mAndroidJarFileOut == null) {
            throw new BuildException("Missing attribute androidJarFileOut");
        }
        if (this.mAndroidAidlFileOut == null) {
            throw new BuildException("Missing attribute androidAidlFileOut");
        }
        if (this.mTargetApiOut == null) {
            throw new BuildException("Missing attribute targetApiOut");
        }
        if (this.mMinSdkVersionOut == null) {
            throw new BuildException("Missing attribute mMinSdkVersionOut");
        }
        Project antProject = this.getProject();
        File sdkDir = TaskHelper.getSdkLocation(antProject);
        String targetHashString = antProject.getProperty("target");
        if (targetHashString == null) {
            throw new BuildException("Android Target is not set.");
        }
        final ArrayList messages = new ArrayList();
        SdkManager manager = SdkManager.createManager(sdkDir.getPath(), new ILogger(){

            @Override
            public void error(@Nullable Throwable t, @Nullable String errorFormat, Object ... args) {
                if (errorFormat != null) {
                    messages.add(String.format("Error: " + errorFormat, args));
                }
                if (t != null) {
                    messages.add("Error: " + t.getMessage());
                }
            }

            @Override
            public void info(@NonNull String msgFormat, Object ... args) {
                messages.add(String.format(msgFormat, args));
            }

            @Override
            public void verbose(@NonNull String msgFormat, Object ... args) {
                this.info(msgFormat, args);
            }

            @Override
            public void warning(@NonNull String warningFormat, Object ... args) {
                messages.add(String.format("Warning: " + warningFormat, args));
            }
        });
        if (manager == null) {
            for (String msg : messages) {
                System.out.println(msg);
            }
            throw new BuildException("Failed to parse SDK content.");
        }
        IAndroidTarget androidTarget = manager.getTargetFromHashString(targetHashString);
        if (androidTarget == null) {
            throw new BuildException(String.format("Unable to resolve project target '%s'", targetHashString));
        }
        System.out.println("Project Target:   " + androidTarget.getName());
        if (!androidTarget.isPlatform()) {
            System.out.println("Vendor:           " + androidTarget.getVendor());
            System.out.println("Platform Version: " + androidTarget.getVersionName());
        }
        System.out.println("API level:        " + androidTarget.getVersion().getApiString());
        antProject.setProperty(this.mTargetApiOut, Integer.toString(androidTarget.getVersion().getApiLevel()));
        this.checkManifest(antProject, androidTarget.getVersion());
        String androidJar = androidTarget.getPath(1);
        antProject.setProperty(this.mAndroidJarFileOut, androidJar);
        String androidAidl = androidTarget.getPath(2);
        antProject.setProperty(this.mAndroidAidlFileOut, androidAidl);
        Path bootclasspath = new Path(antProject);
        Path.PathElement element = bootclasspath.createPathElement();
        element.setPath(androidJar);
        IAndroidTarget.IOptionalLibrary[] libraries = androidTarget.getOptionalLibraries();
        if (libraries != null) {
            HashSet<String> visitedJars = new HashSet<String>();
            for (IAndroidTarget.IOptionalLibrary library : libraries) {
                String jarPath = library.getJarPath();
                if (visitedJars.contains(jarPath)) continue;
                visitedJars.add(jarPath);
                element = bootclasspath.createPathElement();
                element.setPath(jarPath);
            }
        }
        antProject.addReference(this.mBootClassPathOut, (Object)bootclasspath);
    }

    private void checkManifest(Project antProject, AndroidVersion androidVersion) {
        block10: {
            try {
                File manifest = new File(antProject.getBaseDir(), "AndroidManifest.xml");
                XPath xPath = AndroidXPathFactory.newXPath();
                String value = xPath.evaluate("/manifest/@package", new InputSource(new FileInputStream(manifest)));
                if (value != null && value.indexOf(46) == -1) {
                    throw new BuildException(String.format("Application package '%1$s' must have a minimum of 2 segments.", value));
                }
                value = xPath.evaluate("/manifest/uses-sdk/@android:minSdkVersion", new InputSource(new FileInputStream(manifest)));
                if (androidVersion.isPreview()) {
                    String codeName = androidVersion.getCodename();
                    if (!codeName.equals(value)) {
                        throw new BuildException(String.format("For '%1$s' SDK Preview, attribute minSdkVersion in AndroidManifest.xml must be '%1$s' (current: %2$s)", codeName, value));
                    }
                    antProject.setProperty(this.mMinSdkVersionOut, Integer.toString(androidVersion.getApiLevel()));
                    break block10;
                }
                if (value.length() > 0) {
                    int minSdkValue = -1;
                    try {
                        minSdkValue = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        throw new BuildException(String.format("Attribute %1$s in AndroidManifest.xml must be an Integer!", "minSdkVersion"));
                    }
                    antProject.setProperty(this.mMinSdkVersionOut, value);
                    int projectApiLevel = androidVersion.getApiLevel();
                    if (minSdkValue > androidVersion.getApiLevel()) {
                        System.out.println(String.format("WARNING: Attribute %1$s in AndroidManifest.xml (%2$d) is higher than the project target API level (%3$d)", "minSdkVersion", minSdkValue, projectApiLevel));
                    }
                    break block10;
                }
                System.out.println("WARNING: No minSdkVersion value set. Application will install on all Android versions.");
                antProject.setProperty(this.mMinSdkVersionOut, "1");
            }
            catch (XPathExpressionException e) {
                throw new BuildException((Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }
}

