/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.state.GLSparseArrayProperty;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IStateTransform;

public class SparseArrayElementAddTransform
implements IStateTransform {
    private IGLPropertyAccessor mAccessor;
    private int mKey;
    private IGLProperty mOldValue;

    public SparseArrayElementAddTransform(IGLPropertyAccessor iGLPropertyAccessor, int n) {
        this.mAccessor = iGLPropertyAccessor;
        this.mKey = n;
    }

    @Override
    public void apply(IGLProperty iGLProperty) {
        GLSparseArrayProperty gLSparseArrayProperty = this.getArray(iGLProperty);
        if (gLSparseArrayProperty != null) {
            this.mOldValue = gLSparseArrayProperty.getProperty(this.mKey);
            if (this.mOldValue == null) {
                gLSparseArrayProperty.add(this.mKey);
            }
        }
    }

    @Override
    public void revert(IGLProperty iGLProperty) {
        GLSparseArrayProperty gLSparseArrayProperty = this.getArray(iGLProperty);
        if (gLSparseArrayProperty != null && this.mOldValue == null) {
            gLSparseArrayProperty.delete(this.mKey);
        }
    }

    @Override
    public IGLProperty getChangedProperty(IGLProperty iGLProperty) {
        return this.getArray(iGLProperty);
    }

    private GLSparseArrayProperty getArray(IGLProperty iGLProperty) {
        IGLProperty iGLProperty2 = iGLProperty;
        if (this.mAccessor != null) {
            iGLProperty2 = this.mAccessor.getProperty(iGLProperty2);
        }
        if (iGLProperty2 instanceof GLSparseArrayProperty) {
            return (GLSparseArrayProperty)iGLProperty2;
        }
        return null;
    }
}

