/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state;

import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.StatePrettyPrinter;
import com.android.utils.SparseArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class GLSparseArrayProperty
implements IGLProperty {
    private final GLStateType mType;
    private final IGLProperty mDefaultValue;
    private final boolean mCreateOnAccess;
    private final SparseArray<IGLProperty> mSparseArray;
    private IGLProperty mParent;

    public GLSparseArrayProperty(GLStateType gLStateType, IGLProperty iGLProperty) {
        this(gLStateType, iGLProperty, false);
    }

    public GLSparseArrayProperty(GLStateType gLStateType, IGLProperty iGLProperty, boolean bl) {
        this.mType = gLStateType;
        this.mDefaultValue = iGLProperty;
        this.mCreateOnAccess = bl;
        this.mSparseArray = new SparseArray(20);
    }

    private GLSparseArrayProperty(GLStateType gLStateType, IGLProperty iGLProperty, boolean bl, SparseArray<IGLProperty> sparseArray) {
        this.mType = gLStateType;
        this.mDefaultValue = iGLProperty;
        this.mCreateOnAccess = bl;
        this.mSparseArray = sparseArray;
    }

    public List<IGLProperty> getValues() {
        ArrayList<IGLProperty> arrayList = new ArrayList<IGLProperty>(this.mSparseArray.size());
        int n = 0;
        while (n < this.mSparseArray.size()) {
            arrayList.add((IGLProperty)this.mSparseArray.valueAt(n));
            ++n;
        }
        return arrayList;
    }

    public IGLProperty getProperty(int n) {
        IGLProperty iGLProperty = (IGLProperty)this.mSparseArray.get(n);
        if (iGLProperty == null && this.mCreateOnAccess) {
            this.add(n);
            iGLProperty = (IGLProperty)this.mSparseArray.get(n);
        }
        return iGLProperty;
    }

    public int keyFor(IGLProperty iGLProperty) {
        int n = this.mSparseArray.indexOfValue((Object)iGLProperty);
        return this.mSparseArray.keyAt(n);
    }

    public void put(int n, IGLProperty iGLProperty) {
        iGLProperty.setParent(this);
        this.mSparseArray.put(n, (Object)iGLProperty);
    }

    public void add(int n) {
        IGLProperty iGLProperty = this.mDefaultValue.clone();
        iGLProperty.setParent(this);
        this.mSparseArray.put(n, (Object)iGLProperty);
    }

    public void delete(int n) {
        this.mSparseArray.delete(n);
    }

    @Override
    public GLStateType getType() {
        return this.mType;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public IGLProperty getParent() {
        return this.mParent;
    }

    @Override
    public void setParent(IGLProperty iGLProperty) {
        this.mParent = iGLProperty;
    }

    @Override
    public GLSparseArrayProperty clone() {
        SparseArray sparseArray = new SparseArray(this.mSparseArray.size());
        int n = 0;
        while (n < this.mSparseArray.size()) {
            int n2 = this.mSparseArray.keyAt(n);
            IGLProperty iGLProperty = (IGLProperty)this.mSparseArray.get(n2);
            sparseArray.put(n2, (Object)iGLProperty);
            ++n;
        }
        return new GLSparseArrayProperty(this.mType, this.mDefaultValue, this.mCreateOnAccess, (SparseArray<IGLProperty>)sparseArray);
    }

    @Override
    public String getStringValue() {
        return "";
    }

    @Override
    public void setValue(Object object) {
        throw new UnsupportedOperationException("Values cannot be set for composite properties.");
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("Values cannot be obtained for composite properties.");
    }

    @Override
    public void prettyPrint(StatePrettyPrinter statePrettyPrinter) {
        statePrettyPrinter.prettyPrint(this.mType, null);
        statePrettyPrinter.incrementIndentLevel();
        int n = 0;
        while (n < this.mSparseArray.size()) {
            int n2 = this.mSparseArray.keyAt(n);
            statePrettyPrinter.prettyPrint(String.format(Locale.US, "Index %d:", n2));
            IGLProperty iGLProperty = (IGLProperty)this.mSparseArray.get(n2);
            assert (iGLProperty != null);
            if (iGLProperty != null) {
                iGLProperty.prettyPrint(statePrettyPrinter);
            }
            ++n;
        }
        statePrettyPrinter.decrementIndentLevel();
    }
}

