/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBox;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSToolbar;
import org.eclipse.swt.internal.cocoa.NSToolbarItem;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTBox;
import org.eclipse.swt.internal.cocoa.SWTButton;
import org.eclipse.swt.internal.cocoa.SWTButtonCell;
import org.eclipse.swt.internal.cocoa.SWTMenuItem;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    NSView view;
    NSButton button;
    NSToolbarItem nsItem;
    NSMenuItem nsMenuRep;
    NSString id;
    int width = 6;
    ToolBar parent;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    Control control;
    boolean selection;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;
    static final int DEFAULT_SEPARATOR_WIDTH = 6;
    static final int INSET = 3;
    static final int ARROW_WIDTH = 5;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    long accessibleHandle() {
        if (this.button != null && this.button.cell() != null) {
            return this.button.cell().id;
        }
        if (this.view != null) {
            return this.view.id;
        }
        return 0L;
    }

    long accessibilityActionNames(long id2, long sel) {
        long returnValue = super.accessibilityActionNames(id2, sel);
        if (id2 == this.accessibleHandle()) {
            if ((this.style & 4) != 0) {
                NSArray baseArray = new NSArray(returnValue);
                NSMutableArray ourNames = NSMutableArray.arrayWithCapacity(baseArray.count() + 1L);
                ourNames.addObjectsFromArray(baseArray);
                ourNames.addObject(OS.NSAccessibilityShowMenuAction);
                returnValue = ourNames.id;
            }
        } else {
            returnValue = super.accessibilityActionNames(id2, sel);
        }
        return returnValue;
    }

    long accessibilityAttributeNames(long id2, long sel) {
        long returnValue = super.accessibilityAttributeNames(id2, sel);
        if (id2 == this.accessibleHandle()) {
            if ((this.style & 0x30) != 0) {
                NSArray baseArray = new NSArray(returnValue);
                NSMutableArray ourNames = NSMutableArray.arrayWithCapacity(baseArray.count() + 1L);
                ourNames.addObjectsFromArray(baseArray);
                ourNames.addObject(OS.NSAccessibilityValueAttribute);
                returnValue = ourNames.id;
            } else if ((this.style & 4) != 0) {
                NSArray baseArray = new NSArray(returnValue);
                NSMutableArray ourNames = NSMutableArray.arrayWithCapacity(baseArray.count() + 1L);
                ourNames.addObjectsFromArray(baseArray);
                ourNames.addObject(OS.NSAccessibilityChildrenAttribute);
                returnValue = ourNames.id;
            }
        } else {
            returnValue = super.accessibilityAttributeNames(id2, sel);
        }
        return returnValue;
    }

    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        NSString nsAttributeName = new NSString(arg0);
        if (nsAttributeName.isEqualToString(OS.NSAccessibilityRoleAttribute) || nsAttributeName.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            NSString roleText;
            NSString nSString = (this.style & 8) != 0 ? OS.NSAccessibilityButtonRole : ((this.style & 0x10) != 0 ? OS.NSAccessibilityRadioButtonRole : ((this.style & 0x20) != 0 ? OS.NSAccessibilityCheckBoxRole : (roleText = (this.style & 4) != 0 ? OS.NSAccessibilityMenuButtonRole : null)));
            if (roleText != null) {
                if (nsAttributeName.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                    return roleText.id;
                }
                long description = OS.NSAccessibilityRoleDescription(roleText.id, 0L);
                return description;
            }
        } else {
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityTitleAttribute)) {
                String accessibleText;
                String string = accessibleText = this.text.length() > 0 ? this.text : this.toolTipText;
                if (accessibleText != null) {
                    return NSString.stringWith((String)accessibleText).id;
                }
                return NSString.string().id;
            }
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityHelpAttribute)) {
                String accessibleText = this.toolTipText;
                if (accessibleText != null) {
                    return NSString.stringWith((String)accessibleText).id;
                }
                return NSString.string().id;
            }
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityValueAttribute) && (this.style & 0x30) != 0) {
                NSNumber value = NSNumber.numberWithInt(this.selection ? 1 : 0);
                return value.id;
            }
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
                NSNumber value = NSNumber.numberWithBool(this.getEnabled());
                return value.id;
            }
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
                NSArray value = NSArray.array();
                return value.id;
            }
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityParentAttribute)) {
                return this.parent.view.id;
            }
        }
        return super.accessibilityAttributeValue(id2, sel, arg0);
    }

    boolean accessibilityIsIgnored(long id2, long sel) {
        if (id2 == this.accessibleHandle()) {
            return false;
        }
        return super.accessibilityIsIgnored(id2, sel);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    boolean handleKeyDown() {
        if ((this.style & 4) != 0) {
            NSRect frame = this.view.frame();
            Event event = new Event();
            event.detail = 4;
            event.x = (int)frame.x;
            event.y = (int)(frame.y + frame.height);
            this.sendSelectionEvent(13, event, false);
            return true;
        }
        return false;
    }

    Point computeSize() {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 2) != 0) {
            if ((this.parent.style & 0x100) != 0) {
                width = this.getWidth();
                if (width <= 0) {
                    width = 6;
                }
                height = 22;
            } else {
                width = 24;
                height = this.getWidth();
                if (height <= 0) {
                    height = 6;
                }
            }
            if (this.control != null) {
                height = Math.max(height, this.control.getMininumHeight());
            }
        } else {
            if (this.text.length() != 0 || this.image != null) {
                NSSize size = this.button.cell().cellSize();
                width = (int)Math.ceil(size.width);
                height = (int)Math.ceil(size.height);
            } else {
                width = 24;
                height = 22;
            }
            if ((this.style & 4) != 0) {
                width += 8;
            }
            if (this.parent.nsToolbar == null || this.image != null) {
                width += 6;
                height += 6;
            } else {
                height -= 2;
            }
        }
        return new Point(width, height);
    }

    void createHandle() {
        if (this.parent.nsToolbar != null) {
            this.id = NSString.stringWith(String.valueOf(ToolBar.NEXT_ID++));
            this.id.retain();
            this.nsItem = ((NSToolbarItem)new NSToolbarItem().alloc()).initWithItemIdentifier(this.id);
            this.nsItem.setAction(OS.sel_sendSelection);
            this.nsMenuRep = ((NSMenuItem)new SWTMenuItem().alloc()).initWithTitle(NSString.string(), OS.sel_sendSelection, NSString.string());
            this.nsItem.setMenuFormRepresentation(this.nsMenuRep);
        }
        if ((this.style & 2) != 0) {
            if (this.parent.nsToolbar != null) {
                this.view = (NSView)new SWTView().alloc();
                this.view.init();
            } else {
                NSBox widget = (NSBox)new SWTBox().alloc();
                widget.init();
                widget.setBoxType(2L);
                widget.setBorderWidth(0.0);
                this.view = widget;
            }
        } else {
            NSView widget = (NSView)new SWTView().alloc();
            widget.init();
            this.button = (NSButton)new SWTButton().alloc();
            this.button.init();
            NSButtonCell cell = (NSButtonCell)new SWTButtonCell().alloc().init();
            this.button.setCell(cell);
            cell.release();
            cell.setHighlightsBy(1L);
            cell.setBackgroundStyle(2L);
            this.button.setBordered(false);
            this.button.setAction(OS.sel_sendSelection);
            this.button.setTarget(this.button);
            if (this.nsMenuRep != null) {
                this.nsMenuRep.setTarget(this.button);
            }
            Font font = this.parent.font != null ? this.parent.font : this.parent.defaultFont();
            this.button.setFont(font.handle);
            this.button.setImagePosition(6L);
            this.button.setTitle(NSString.string());
            this.button.setEnabled(this.parent.getEnabled());
            widget.addSubview(this.button);
            this.view = widget;
        }
    }

    NSAttributedString createString() {
        NSAttributedString attribStr = this.parent.createString(this.text, null, this.parent.foreground, 0x1000000, false, true, true);
        attribStr.autorelease();
        return attribStr;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
        if (this.button != null) {
            this.display.removeWidget(this.button);
            this.display.removeWidget(this.button.cell());
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    void drawImageWithFrameInView(long id2, long sel, long image, NSRect rect, long view) {
        boolean drawSelected;
        if (this.text.length() > 0) {
            if ((this.parent.style & 0x20000) != 0) {
                rect.x += 3.0;
            } else {
                rect.y += 3.0;
            }
        }
        long cgContext = NSGraphicsContext.currentContext().graphicsPort();
        NSCell cell = new NSCell(id2);
        boolean bl = drawSelected = this.parent.nsToolbar != null && this.getSelection() && (this.style & 0x20) != 0 && !cell.isHighlighted();
        if (drawSelected) {
            NSGraphicsContext.currentContext().saveGraphicsState();
            CGRect cgRect = new CGRect();
            cgRect.origin.x = rect.x;
            cgRect.origin.y = rect.y;
            cgRect.size.width = rect.width;
            cgRect.size.height = rect.height;
            OS.CGContextBeginTransparencyLayerWithRect(cgContext, cgRect, 0L);
        }
        super.drawImageWithFrameInView(id2, sel, image, rect, view);
        if (drawSelected) {
            NSColor.colorWithDeviceRed(0.0, 0.0, 0.0, 0.3f).setFill();
            OS.NSRectFillUsingOperation(rect, 5L);
            OS.CGContextEndTransparencyLayer(cgContext);
            NSGraphicsContext.currentContext().restoreGraphicsState();
        }
    }

    NSRect drawTitleWithFrameInView(long id2, long sel, long title, NSRect titleRect, long view) {
        boolean hiliteShadow;
        boolean bl = hiliteShadow = new NSButtonCell(id2).isHighlighted() && this.text.length() > 0 && this.image == null;
        if (hiliteShadow) {
            NSColor transWhiteColor = NSColor.colorWithDeviceRed(1.0, 1.0, 1.0, 0.8f);
            NSAttributedString attribStr = new NSAttributedString(title);
            NSMutableAttributedString tmpString = new NSMutableAttributedString(attribStr.mutableCopy());
            NSRange range = new NSRange();
            range.location = 0L;
            range.length = attribStr.length();
            tmpString.addAttribute(OS.NSForegroundColorAttributeName, transWhiteColor, range);
            tmpString.autorelease();
            title = tmpString.id;
        }
        return super.drawTitleWithFrameInView(id2, sel, title, titleRect, view);
    }

    void drawWidget(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 == this.view.id) {
            NSRect bounds;
            boolean drawSelected;
            boolean bl = drawSelected = this.getSelection() && this.parent.nsToolbar == null;
            if (drawSelected) {
                bounds = this.view.bounds();
                context.saveGraphicsState();
                NSColor.colorWithDeviceRed(0.1f, 0.1f, 0.1f, 0.1f).setFill();
                NSColor.colorWithDeviceRed(0.2f, 0.2f, 0.2f, 0.2f).setStroke();
                NSBezierPath.fillRect(bounds);
                bounds.x += 0.5;
                bounds.y += 0.5;
                bounds.width -= 1.0;
                bounds.height -= 1.0;
                NSBezierPath.strokeRect(bounds);
                context.restoreGraphicsState();
            }
            if ((this.style & 4) != 0) {
                bounds = this.view.bounds();
                context.saveGraphicsState();
                NSBezierPath path = NSBezierPath.bezierPath();
                NSPoint pt = new NSPoint();
                path.moveToPoint(pt);
                pt.x += 5.0;
                path.lineToPoint(pt);
                pt.y += 4.0;
                pt.x -= 2.5;
                path.lineToPoint(pt);
                path.closePath();
                NSAffineTransform transform = NSAffineTransform.transform();
                transform.translateXBy((int)bounds.width - 5 - 3, (int)(bounds.height - 2.0) / 2);
                transform.concat();
                NSColor color = this.isEnabled() ? NSColor.blackColor() : NSColor.disabledControlTextColor();
                color.set();
                path.fill();
                context.restoreGraphicsState();
            }
        }
    }

    void enableWidget(boolean enabled) {
        if (this.parent.nsToolbar != null) {
            this.nsItem.setEnabled(enabled);
        }
        if ((this.style & 2) == 0) {
            this.button.setEnabled(enabled);
            this.updateImage(true);
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.parent.nsToolbar != null) {
            NSRect rect = this.view.frame();
            rect = this.parent.view.convertRect_fromView_(rect, this.view);
            return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
        }
        NSRect rect = this.view.frame();
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    void setClipRegion(NSView view) {
        this.parent.setClipRegion(view);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    boolean getDrawing() {
        return this.parent.getDrawing();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    NSString getItemID() {
        NSString itemID = this.id;
        if ((this.style & 2) != 0 && this.control == null) {
            if (this.width == 6 || this.width == 0) {
                itemID = OS.NSToolbarSeparatorItemIdentifier;
            } else if (this.width == -1) {
                itemID = OS.NSToolbarSpaceItemIdentifier;
            } else if (this.width == -2) {
                itemID = OS.NSToolbarFlexibleSpaceItemIdentifier;
            }
        }
        return itemID;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.selection;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    long menuForEvent(long id2, long sel, long theEvent) {
        return this.parent.menuForEvent(id2, sel, theEvent);
    }

    void mouseDown(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 3)) {
            return;
        }
        Display display = this.display;
        display.trackingControl = this.parent;
        super.mouseDown(id2, sel, theEvent);
        display.trackingControl = null;
        if ((this.style & 4) != 0 && id2 == this.view.id) {
            NSRect frame = this.view.frame();
            Event event = new Event();
            event.detail = 4;
            event.x = (int)frame.x;
            event.y = (int)(frame.y + frame.height);
            this.sendSelectionEvent(13, event, false);
        }
    }

    boolean mouseDownCanMoveWindow(long id2, long sel) {
        if (id2 == this.view.id) {
            return false;
        }
        return super.mouseDownCanMoveWindow(id2, sel);
    }

    void mouseUp(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 4)) {
            return;
        }
        super.mouseUp(id2, sel, theEvent);
    }

    void mouseDragged(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 5)) {
            return;
        }
        super.mouseDragged(id2, sel, theEvent);
    }

    void rightMouseDown(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 3)) {
            return;
        }
        super.rightMouseDown(id2, sel, theEvent);
    }

    void rightMouseUp(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 4)) {
            return;
        }
        super.rightMouseUp(id2, sel, theEvent);
    }

    void rightMouseDragged(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 5)) {
            return;
        }
        super.rightMouseDragged(id2, sel, theEvent);
    }

    void otherMouseDown(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 3)) {
            return;
        }
        super.otherMouseDown(id2, sel, theEvent);
    }

    void otherMouseUp(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 4)) {
            return;
        }
        super.otherMouseUp(id2, sel, theEvent);
    }

    void otherMouseDragged(long id2, long sel, long theEvent) {
        if (!this.parent.mouseEvent(this.parent.view.id, sel, theEvent, 5)) {
            return;
        }
        super.otherMouseDragged(id2, sel, theEvent);
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
        if (this.button != null) {
            this.display.addWidget(this.button, this);
            this.display.addWidget(this.button.cell(), this);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void releaseParent() {
        super.releaseParent();
        this.setVisible(false);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        if (this.button != null) {
            this.button.release();
        }
        this.button = null;
        this.view = null;
        if (this.nsItem != null) {
            this.nsItem.release();
            this.nsItem = null;
        }
        if (this.id != null) {
            this.id.release();
            this.id = null;
        }
        if (this.nsMenuRep != null) {
            this.nsMenuRep.release();
            this.nsMenuRep = null;
        }
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    void sendSelection() {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        }
        this.sendSelectionEvent(13);
    }

    void setBounds(int x, int y, int width, int height) {
        NSRect rect = new NSRect();
        if (this.parent.nsToolbar == null) {
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            this.view.setFrame(rect);
            if (this.button != null) {
                rect.x = 0.0;
                rect.y = 0.0;
                rect.width = width;
                rect.height = height;
                if ((this.style & 4) != 0) {
                    rect.width -= 8.0;
                }
                this.button.setFrame(rect);
            }
        } else {
            NSSize newSize = new NSSize();
            newSize.height = height;
            newSize.width = width;
            this.nsItem.setView(null);
            this.view.setFrameSize(newSize);
            if ((this.style & 4) != 0) {
                newSize.width -= 8.0;
            }
            if (this.button != null) {
                this.button.setFrameSize(newSize);
            }
            if ((this.style & 4) != 0) {
                newSize.width += 8.0;
            }
            this.nsItem.setMinSize(newSize);
            this.nsItem.setMaxSize(newSize);
            this.nsItem.setView(this.view);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        if (this.parent.nsToolbar == null) {
            NSBox widget = (NSBox)this.view;
            if (control == null) {
                widget.setBoxType(2L);
            } else {
                widget.setBoxType(4L);
            }
        } else {
            this.nsItem.setMenuFormRepresentation(control == null ? this.nsMenuRep : NSMenuItem.separatorItem());
        }
        this.control = control;
        this.view.setHidden(control != null);
        if (control != null && !control.isDisposed()) {
            control.moveAbove(null);
        }
        this.parent.relayout();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 && enabled) {
            return;
        }
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(enabled);
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        this.updateImage(true);
    }

    boolean setFocus() {
        if (this.button == null) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        NSWindow window = this.view.window();
        if (window == null) {
            return false;
        }
        return window.makeFirstResponder(this.button);
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        this.updateImage(true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.updateImage(true);
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.selection = selected;
        if (this.parent.nsToolbar != null && (this.style & 0x10) != 0 && this.selection) {
            this.parent.nsToolbar.setSelectedItemIdentifier(this.nsItem.itemIdentifier());
        }
        this.view.setNeedsDisplay(true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        NSButton widget = this.button;
        if (this.parent.nsToolbar != null) {
            char[] chars = new char[this.text.length()];
            this.text.getChars(0, chars.length, chars, 0);
            int length = this.fixMnemonic(chars);
            this.nsMenuRep.setTitle(NSString.stringWithCharacters(chars, length));
        }
        widget.setAttributedTitle(this.createString());
        if (this.text.length() != 0 && this.image != null) {
            if ((this.parent.style & 0x20000) != 0) {
                widget.setImagePosition(2L);
            } else {
                widget.setImagePosition(5L);
            }
        } else {
            widget.setImagePosition(this.text.length() != 0 ? 0 : 1);
        }
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        if (this.parent.nsToolbar != null) {
            char[] chars = new char[this.toolTipText.length()];
            string.getChars(0, chars.length, chars, 0);
            int length = this.fixMnemonic(chars);
            this.nsItem.setToolTip(NSString.stringWithCharacters(chars, length));
        } else {
            this.parent.checkToolTip(this);
        }
    }

    void setVisible(boolean visible) {
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        this.view.setHidden(!visible);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < -2 || this.width == width) {
            return;
        }
        this.width = width;
        if (this.parent.nsToolbar != null) {
            NSToolbar toolbar = this.parent.nsToolbar;
            int index = this.parent.indexOf(this);
            toolbar.removeItemAtIndex(index);
            toolbar.insertItemWithItemIdentifier(this.getItemID(), index);
        }
        this.parent.relayout();
    }

    String tooltipText() {
        return this.toolTipText;
    }

    void updateImage(boolean layout) {
        if ((this.style & 2) != 0) {
            return;
        }
        Image newImage = null;
        newImage = (this.state & 8) == 8 && this.disabledImage != null ? this.disabledImage : ((this.state & 0x20) == 32 && this.hotImage != null ? this.hotImage : this.image);
        NSButton widget = this.button;
        widget.setImage(newImage != null ? newImage.handle : null);
        widget.setNeedsDisplay(true);
        if (this.text.length() != 0 && newImage != null) {
            if ((this.parent.style & 0x20000) != 0) {
                widget.setImagePosition(2L);
            } else {
                widget.setImagePosition(5L);
            }
        } else {
            widget.setImagePosition(this.text.length() != 0 ? 0 : 1);
        }
        this.parent.relayout();
    }

    boolean validateMenuItem(long id2, long sel, long menuItem) {
        return this.isEnabled();
    }
}

