/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

public abstract class WCMatcher {
    private static final WCMatcher ALL_MATCHER = new AllMatcher();
    private static final WCMatcher EMPTY_MATCHER = new EmptyMatcher();

    public static WCMatcher compile(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null input: pattern");
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n == 0) {
            return EMPTY_MATCHER;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == '*') {
                if (bl) continue;
                bl = true;
                ++n3;
                cArray[n2++] = 42;
                continue;
            }
            bl = false;
            if (c == '?') {
                ++n4;
            }
            cArray[n2++] = c;
        }
        if (n3 == 1 && n4 == 0) {
            if (n2 == 1) {
                return ALL_MATCHER;
            }
            if (cArray[0] == '*') {
                return new EndsWithMatcher(cArray, n2);
            }
            if (cArray[n2 - 1] == '*') {
                return new StartsWithMatcher(cArray, n2);
            }
        }
        return new PatternMatcher(cArray, n2);
    }

    public abstract boolean matches(String var1);

    public abstract boolean matches(char[] var1);

    WCMatcher() {
    }

    private static final class PatternMatcher
    extends WCMatcher {
        private final char[] m_pattern;
        private final int m_patternLength;

        public final boolean matches(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: s");
            }
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            char[] cArray2 = this.m_pattern;
            int n2 = this.m_patternLength;
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            block0: while (true) {
                int n5 = 0;
                while (n4 + n5 < n2) {
                    char c = cArray2[n4 + n5];
                    if (c == '*') {
                        n3 += n5;
                        n4 += n5 + 1;
                        bl = true;
                        continue block0;
                    }
                    int n6 = n3 + n5;
                    if (n6 == n) {
                        return false;
                    }
                    if (c != cArray[n6] && c != '?') {
                        if (!bl) {
                            return false;
                        }
                        ++n3;
                        continue block0;
                    }
                    ++n5;
                }
                if (n3 + n5 == n) {
                    return true;
                }
                if (!bl) {
                    return false;
                }
                ++n3;
            }
        }

        public final boolean matches(char[] cArray) {
            if (cArray == null) {
                throw new IllegalArgumentException("null input: string");
            }
            int n = cArray.length;
            char[] cArray2 = this.m_pattern;
            int n2 = this.m_patternLength;
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            block0: while (true) {
                int n5 = 0;
                while (n4 + n5 < n2) {
                    char c = cArray2[n4 + n5];
                    if (c == '*') {
                        n3 += n5;
                        n4 += n5 + 1;
                        bl = true;
                        continue block0;
                    }
                    int n6 = n3 + n5;
                    if (n6 == n) {
                        return false;
                    }
                    if (c != cArray[n6] && c != '?') {
                        if (!bl) {
                            return false;
                        }
                        ++n3;
                        continue block0;
                    }
                    ++n5;
                }
                if (n3 + n5 == n) {
                    return true;
                }
                if (!bl) {
                    return false;
                }
                ++n3;
            }
        }

        PatternMatcher(char[] cArray, int n) {
            this.m_pattern = cArray;
            this.m_patternLength = n;
        }
    }

    private static final class EndsWithMatcher
    extends WCMatcher {
        private final char[] m_suffixChars;
        private final String m_suffix;

        public final boolean matches(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: s");
            }
            return string.endsWith(this.m_suffix);
        }

        public final boolean matches(char[] cArray) {
            if (cArray == null) {
                throw new IllegalArgumentException("null input: chars");
            }
            int n = cArray.length;
            char[] cArray2 = this.m_suffixChars;
            int n2 = cArray2.length - 1;
            if (n < n2) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                if (cArray[n - 1 - i] == cArray2[n2 - i]) continue;
                return false;
            }
            return true;
        }

        EndsWithMatcher(char[] cArray, int n) {
            this.m_suffixChars = cArray;
            this.m_suffix = new String(cArray, 1, n - 1);
        }
    }

    private static final class StartsWithMatcher
    extends WCMatcher {
        private final char[] m_prefixChars;
        private final String m_prefix;

        public final boolean matches(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: s");
            }
            return string.startsWith(this.m_prefix);
        }

        public final boolean matches(char[] cArray) {
            if (cArray == null) {
                throw new IllegalArgumentException("null input: chars");
            }
            char[] cArray2 = this.m_prefixChars;
            int n = cArray2.length - 1;
            if (cArray.length < n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (cArray[i] == cArray2[i]) continue;
                return false;
            }
            return true;
        }

        StartsWithMatcher(char[] cArray, int n) {
            this.m_prefixChars = cArray;
            this.m_prefix = new String(cArray, 0, n - 1);
        }
    }

    private static final class EmptyMatcher
    extends WCMatcher {
        private EmptyMatcher() {
        }

        public final boolean matches(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: s");
            }
            return false;
        }

        public final boolean matches(char[] cArray) {
            if (cArray == null) {
                throw new IllegalArgumentException("null input: chars");
            }
            return cArray.length == 0;
        }
    }

    private static final class AllMatcher
    extends WCMatcher {
        private AllMatcher() {
        }

        public final boolean matches(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null input: s");
            }
            return true;
        }

        public final boolean matches(char[] cArray) {
            if (cArray == null) {
                throw new IllegalArgumentException("null input: chars");
            }
            return true;
        }
    }
}

