/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class SoftValueMap
implements Map {
    private final ReferenceQueue m_valueReferenceQueue;
    private final float m_loadFactor;
    private final int m_readClearCheckFrequency;
    private final int m_writeClearCheckFrequency;
    private SoftEntry[] m_buckets;
    private int m_size;
    private int m_sizeThreshold;
    private int m_readAccessCount;
    private int m_writeAccessCount;
    private static final String EOL = System.getProperty("line.separator", "\n");
    private static final boolean IDENTITY_OPTIMIZATION = true;
    private static final boolean ENQUEUE_FOUND_CLEARED_ENTRIES = true;
    private static final boolean DEBUG = false;

    public SoftValueMap() {
        this(1, 1);
    }

    public SoftValueMap(int n, int n2) {
        this(11, 0.75f, n, n2);
    }

    public SoftValueMap(int n, float f, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("negative input: initialCapacity [" + n + "]");
        }
        if ((double)f <= 0.0 || (double)f >= 1.000001) {
            throw new IllegalArgumentException("loadFactor not in (0.0, 1.0] range: " + f);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("readClearCheckFrequency not in [1, +inf) range: " + n2);
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("writeClearCheckFrequency not in [1, +inf) range: " + n3);
        }
        if (n == 0) {
            n = 1;
        }
        this.m_valueReferenceQueue = new ReferenceQueue();
        this.m_loadFactor = f;
        this.m_sizeThreshold = (int)((float)n * f);
        this.m_readClearCheckFrequency = n2;
        this.m_writeClearCheckFrequency = n3;
        this.m_buckets = new SoftEntry[n];
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException("not implemented: equals");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("not implemented: hashCode");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.debugDump(stringBuffer);
        return stringBuffer.toString();
    }

    public int size() {
        return this.m_size;
    }

    public boolean isEmpty() {
        return this.m_size == 0;
    }

    public Object get(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null input: key");
        }
        if (++this.m_readAccessCount % this.m_readClearCheckFrequency == 0) {
            this.removeClearedValues();
        }
        int n = object.hashCode();
        SoftEntry[] softEntryArray = this.m_buckets;
        int n2 = (n & Integer.MAX_VALUE) % softEntryArray.length;
        Object var5_5 = null;
        SoftEntry softEntry = softEntryArray[n2];
        while (softEntry != null) {
            Object object2 = softEntry.m_key;
            if (object == object2 || n == object2.hashCode() && object.equals(object2)) {
                IndexedSoftReference indexedSoftReference = softEntry.m_softValue;
                var5_5 = ((Reference)indexedSoftReference).get();
                if (var5_5 == null) {
                    indexedSoftReference.enqueue();
                }
                return var5_5;
            }
            softEntry = softEntry.m_next;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        if (object == null) {
            throw new IllegalArgumentException("null input: key");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("null input: value");
        }
        if (++this.m_writeAccessCount % this.m_writeClearCheckFrequency == 0) {
            this.removeClearedValues();
        }
        Object object4 = null;
        int n = object.hashCode();
        SoftEntry[] softEntryArray = this.m_buckets;
        int n2 = (n & Integer.MAX_VALUE) % softEntryArray.length;
        Object object5 = softEntryArray[n2];
        while (object5 != null) {
            object3 = ((SoftEntry)object5).m_key;
            if (object == object3 || n == object3.hashCode() && object.equals(object3)) {
                object4 = object5;
                break;
            }
            object5 = ((SoftEntry)object5).m_next;
        }
        if (object4 != null) {
            object5 = ((SoftEntry)object4).m_softValue;
            object3 = ((SoftReference)object5).get();
            if (object3 == null) {
                ((IndexedSoftReference)object5).m_bucketIndex = -1;
            }
            ((SoftEntry)object4).m_softValue = new IndexedSoftReference(object2, this.m_valueReferenceQueue, n2);
            return object3;
        }
        if (this.m_size >= this.m_sizeThreshold) {
            this.rehash();
        }
        softEntryArray = this.m_buckets;
        n2 = (n & Integer.MAX_VALUE) % softEntryArray.length;
        object5 = softEntryArray[n2];
        softEntryArray[n2] = object3 = new SoftEntry(this.m_valueReferenceQueue, object, object2, (SoftEntry)object5, n2);
        ++this.m_size;
        return null;
    }

    public Object remove(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null input: key");
        }
        if (++this.m_writeAccessCount % this.m_writeClearCheckFrequency == 0) {
            this.removeClearedValues();
        }
        int n = object.hashCode();
        SoftEntry[] softEntryArray = this.m_buckets;
        int n2 = (n & Integer.MAX_VALUE) % softEntryArray.length;
        Object var5_5 = null;
        SoftEntry softEntry = softEntryArray[n2];
        SoftEntry softEntry2 = null;
        while (softEntry != null) {
            Object object2 = softEntry.m_key;
            if (object2 == object || n == object2.hashCode() && object.equals(object2)) {
                if (softEntry2 == null) {
                    softEntryArray[n2] = softEntry.m_next;
                } else {
                    softEntry2.m_next = softEntry.m_next;
                }
                IndexedSoftReference indexedSoftReference = softEntry.m_softValue;
                var5_5 = indexedSoftReference.get();
                indexedSoftReference.m_bucketIndex = -1;
                softEntry.m_softValue = null;
                softEntry.m_key = null;
                softEntry.m_next = null;
                softEntry = null;
                --this.m_size;
                break;
            }
            softEntry2 = softEntry;
            softEntry = softEntry.m_next;
        }
        return var5_5;
    }

    public void clear() {
        for (SoftEntry softEntry : this.m_buckets) {
            while (softEntry != null) {
                SoftEntry softEntry2 = softEntry.m_next;
                softEntry.m_softValue.m_bucketIndex = -1;
                softEntry.m_softValue = null;
                softEntry.m_next = null;
                softEntry.m_key = null;
                softEntry = softEntry2;
            }
            var1_1[var2_2] = null;
        }
        this.m_size = 0;
        this.m_readAccessCount = 0;
        this.m_writeAccessCount = 0;
    }

    public boolean containsKey(Object object) {
        throw new UnsupportedOperationException("not implemented: containsKey");
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException("not implemented: containsValue");
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException("not implemented: putAll");
    }

    public Set keySet() {
        throw new UnsupportedOperationException("not implemented: keySet");
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("not implemented: entrySet");
    }

    public Collection values() {
        throw new UnsupportedOperationException("not implemented: values");
    }

    void debugDump(StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            stringBuffer.append(this.getClass().getName().concat("@").concat(Integer.toHexString(System.identityHashCode(this))));
            stringBuffer.append(EOL);
            stringBuffer.append("size = " + this.m_size + ", bucket table size = " + this.m_buckets.length + ", load factor = " + this.m_loadFactor + EOL);
            stringBuffer.append("size threshold = " + this.m_sizeThreshold + ", get clear frequency = " + this.m_readClearCheckFrequency + ", put clear frequency = " + this.m_writeClearCheckFrequency + EOL);
            stringBuffer.append("get count: " + this.m_readAccessCount + ", put count: " + this.m_writeAccessCount + EOL);
        }
    }

    private void rehash() {
        SoftEntry[] softEntryArray = this.m_buckets;
        int n = (this.m_buckets.length << 1) + 1;
        SoftEntry[] softEntryArray2 = new SoftEntry[n];
        int n2 = 0;
        for (SoftEntry softEntry : softEntryArray) {
            while (softEntry != null) {
                SoftEntry softEntry2 = softEntry.m_next;
                IndexedSoftReference indexedSoftReference = softEntry.m_softValue;
                Object t = indexedSoftReference.get();
                if (t != null) {
                    SoftEntry softEntry3;
                    int n3 = softEntry.m_key.hashCode();
                    int n4 = (n3 & Integer.MAX_VALUE) % n;
                    softEntry.m_next = softEntry3 = softEntryArray2[n4];
                    softEntryArray2[n4] = softEntry;
                    indexedSoftReference.m_bucketIndex = n4;
                    ++n2;
                    t = null;
                } else {
                    indexedSoftReference.m_bucketIndex = -1;
                }
                softEntry = softEntry2;
            }
        }
        this.m_size = n2;
        this.m_sizeThreshold = (int)((float)n * this.m_loadFactor);
        this.m_buckets = softEntryArray2;
    }

    private void removeClearedValues() {
        Reference reference;
        boolean bl = false;
        block0: while ((reference = this.m_valueReferenceQueue.poll()) != null) {
            int n = ((IndexedSoftReference)reference).m_bucketIndex;
            if (n < 0) continue;
            Object object = this.m_buckets[n];
            SoftEntry softEntry = null;
            while (object != null) {
                if (((SoftEntry)object).m_softValue == reference) {
                    if (softEntry == null) {
                        this.m_buckets[n] = ((SoftEntry)object).m_next;
                    } else {
                        softEntry.m_next = ((SoftEntry)object).m_next;
                    }
                    ((SoftEntry)object).m_softValue = null;
                    ((SoftEntry)object).m_key = null;
                    ((SoftEntry)object).m_next = null;
                    object = null;
                    --this.m_size;
                    continue block0;
                }
                softEntry = object;
                object = ((SoftEntry)object).m_next;
            }
            object = new StringBuffer("removeClearedValues(): soft reference [" + reference + "] did not match within bucket #" + n + EOL);
            this.debugDump((StringBuffer)object);
            throw new Error(((StringBuffer)object).toString());
        }
    }

    static class SoftEntry {
        IndexedSoftReference m_softValue;
        Object m_key;
        SoftEntry m_next;

        SoftEntry(ReferenceQueue referenceQueue, Object object, Object object2, SoftEntry softEntry, int n) {
            this.m_key = object;
            this.m_softValue = new IndexedSoftReference(object2, referenceQueue, n);
            object2 = null;
            this.m_next = softEntry;
        }
    }

    static class IndexedSoftReference
    extends SoftReference {
        int m_bucketIndex;

        IndexedSoftReference(Object object, ReferenceQueue referenceQueue, int n) {
            super(object, referenceQueue);
            this.m_bucketIndex = n;
        }
    }
}

