/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

public abstract class Descriptors {
    public static final char JAVA_NAME_SEPARATOR = '.';
    public static final char VM_NAME_SEPARATOR = '/';
    private static final boolean RENAME_INNER_CLASSES = false;

    public static String combine(String string, String string2, char c) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("null or empty input: name");
        }
        if (string == null || string.length() == 0) {
            return string2;
        }
        return new StringBuffer(string).append(c).append(string2).toString();
    }

    public static String combineJavaName(String string, String string2) {
        return Descriptors.combine(string, string2, '.');
    }

    public static String combineVMName(String string, String string2) {
        return Descriptors.combine(string, string2, '/');
    }

    public static String javaNameToVMName(String string) {
        if (string == null) {
            return null;
        }
        return string.replace('.', '/');
    }

    public static String vmNameToJavaName(String string) {
        if (string == null) {
            return null;
        }
        return string.replace('/', '.');
    }

    public static String methodVMNameToJavaName(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            if ("<clinit>".equals(string2)) {
                return "<static initializer>";
            }
            if ("<init>".equals(string2)) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string2);
            }
        } else {
            if ("<clinit>".equals(string2)) {
                return "<clinit>";
            }
            stringBuffer.append(string2);
        }
        char[] cArray = string3.toCharArray();
        stringBuffer.append(" (");
        int n = cArray.length;
        while (cArray[--n] != ')') {
        }
        int n2 = 1;
        while (n2 < n) {
            if (n2 > 1) {
                stringBuffer.append(", ");
            }
            n2 = Descriptors.typeDescriptorToJavaName(cArray, n2, bl2, stringBuffer);
        }
        if (bl3) {
            stringBuffer.append("): ");
            Descriptors.typeDescriptorToJavaName(cArray, n + 1, bl2, stringBuffer);
        } else {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private static int typeDescriptorToJavaName(char[] cArray, int n, boolean bl, StringBuffer stringBuffer) {
        int n2;
        int n3 = 0;
        while (cArray[n] == '[') {
            ++n3;
            ++n;
        }
        char c = cArray[n++];
        switch (c) {
            case 'L': {
                if (bl) {
                    n2 = -1;
                    int n4 = n;
                    while (cArray[n4] != ';') {
                        if (cArray[n4] == '/') {
                            n2 = n4;
                        }
                        ++n4;
                    }
                    int n5 = n = n2 > 0 ? n2 + 1 : n;
                    while (cArray[n] != ';') {
                        c = cArray[n];
                        stringBuffer.append(c);
                        ++n;
                    }
                } else {
                    while (cArray[n] != ';') {
                        c = cArray[n];
                        stringBuffer.append(c != '/' ? c : (char)'.');
                        ++n;
                    }
                }
                ++n;
                break;
            }
            case 'B': {
                stringBuffer.append("byte");
                break;
            }
            case 'C': {
                stringBuffer.append("char");
                break;
            }
            case 'D': {
                stringBuffer.append("double");
                break;
            }
            case 'F': {
                stringBuffer.append("float");
                break;
            }
            case 'I': {
                stringBuffer.append("int");
                break;
            }
            case 'J': {
                stringBuffer.append("long");
                break;
            }
            case 'S': {
                stringBuffer.append("short");
                break;
            }
            case 'Z': {
                stringBuffer.append("boolean");
                break;
            }
            case 'V': {
                stringBuffer.append("void");
                break;
            }
            default: {
                throw new IllegalStateException("unknown type descriptor element: " + c);
            }
        }
        if (n3 > 0) {
            stringBuffer.append(' ');
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append("[]");
            }
        }
        return n;
    }

    private Descriptors() {
    }
}

