/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.constant.CONSTANT_Utf8_info;
import com.vladium.jcd.cls.constant.CONSTANT_info;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.ObjectIntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class ConstantCollection
implements IConstantCollection {
    private List m_constants;
    private int m_size;
    private transient ObjectIntMap m_CONSTANT_Utf8_index;

    public CONSTANT_info get(int n) {
        Object e = this.m_constants.get(n - 1);
        if (e == null) {
            throw new IllegalStateException("assertion failure: dereferencing an invalid constant pool slot " + n);
        }
        return (CONSTANT_info)e;
    }

    public IConstantCollection.IConstantIterator iterator() {
        return new ConstantIterator(this.m_constants);
    }

    public int find(int n, IConstantCollection.IConstantComparator iConstantComparator) {
        if (iConstantComparator == null) {
            throw new IllegalArgumentException("null input: comparator");
        }
        for (int i = 0; i < this.m_constants.size(); ++i) {
            CONSTANT_info cONSTANT_info = (CONSTANT_info)this.m_constants.get(i);
            if (cONSTANT_info == null || cONSTANT_info.tag() != n || !iConstantComparator.equals(cONSTANT_info)) continue;
            return i + 1;
        }
        return -1;
    }

    public int findCONSTANT_Utf8(String string) {
        int[] nArray;
        if (string == null) {
            throw new IllegalArgumentException("null input: value");
        }
        ObjectIntMap objectIntMap = this.getCONSTANT_Utf8_index();
        if (objectIntMap.get(string, nArray = new int[1])) {
            return nArray[0] + 1;
        }
        return -1;
    }

    public int size() {
        return this.m_size;
    }

    public Object clone() {
        try {
            ConstantCollection constantCollection = (ConstantCollection)super.clone();
            int n = this.m_constants.size();
            constantCollection.m_constants = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                CONSTANT_info cONSTANT_info = (CONSTANT_info)this.m_constants.get(i);
                constantCollection.m_constants.add(cONSTANT_info == null ? null : cONSTANT_info.clone());
            }
            return constantCollection;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        CONSTANT_info cONSTANT_info;
        int n = this.m_constants.size();
        uDataOutputStream.writeU2(n + 1);
        ConstantIterator constantIterator = new ConstantIterator(this.m_constants);
        while ((cONSTANT_info = constantIterator.nextConstant()) != null) {
            cONSTANT_info.writeInClassFormat(uDataOutputStream);
        }
    }

    public void accept(IClassDefVisitor iClassDefVisitor, Object object) {
        iClassDefVisitor.visit(this, object);
    }

    public CONSTANT_info set(int n, CONSTANT_info cONSTANT_info) {
        int n2 = n - 1;
        CONSTANT_info cONSTANT_info2 = (CONSTANT_info)this.m_constants.get(n2);
        if (cONSTANT_info2 == null) {
            throw new IllegalStateException("assertion failure: dereferencing an invalid constant pool slot " + n);
        }
        if (cONSTANT_info2.width() != cONSTANT_info.width()) {
            throw new IllegalArgumentException("assertion failure: can't set entry of type [" + cONSTANT_info2.getClass().getName() + "] to an entry of type [" + cONSTANT_info2.getClass().getName() + "] at pool slot " + n);
        }
        this.m_constants.set(n2, cONSTANT_info);
        if (this.m_CONSTANT_Utf8_index != null) {
            int[] nArray;
            String string;
            if (cONSTANT_info2 instanceof CONSTANT_Utf8_info && this.m_CONSTANT_Utf8_index.get(string = ((CONSTANT_Utf8_info)cONSTANT_info2).m_value, nArray = new int[1]) && nArray[0] == n2) {
                this.m_CONSTANT_Utf8_index.remove(string);
            }
            if (cONSTANT_info instanceof CONSTANT_Utf8_info) {
                this.m_CONSTANT_Utf8_index.put(((CONSTANT_Utf8_info)cONSTANT_info).m_value, n2);
            }
        }
        return cONSTANT_info2;
    }

    public int add(CONSTANT_info cONSTANT_info) {
        this.m_constants.add(cONSTANT_info);
        ++this.m_size;
        int n = this.m_constants.size();
        for (int i = 1; i < cONSTANT_info.width(); ++i) {
            ++this.m_size;
            this.m_constants.add(null);
        }
        if (this.m_CONSTANT_Utf8_index != null && cONSTANT_info instanceof CONSTANT_Utf8_info) {
            this.m_CONSTANT_Utf8_index.put(((CONSTANT_Utf8_info)cONSTANT_info).m_value, n - 1);
        }
        return n;
    }

    ConstantCollection(int n) {
        this.m_constants = n < 0 ? new ArrayList() : new ArrayList(n);
    }

    private ObjectIntMap getCONSTANT_Utf8_index() {
        if (this.m_CONSTANT_Utf8_index == null) {
            ObjectIntMap objectIntMap = new ObjectIntMap(this.m_size);
            for (int i = 0; i < this.m_constants.size(); ++i) {
                CONSTANT_info cONSTANT_info = (CONSTANT_info)this.m_constants.get(i);
                if (cONSTANT_info == null || cONSTANT_info.tag() != 1) continue;
                objectIntMap.put(((CONSTANT_Utf8_info)cONSTANT_info).m_value, i);
            }
            this.m_CONSTANT_Utf8_index = objectIntMap;
        }
        return this.m_CONSTANT_Utf8_index;
    }

    private static final class ConstantIterator
    implements IConstantCollection.IConstantIterator {
        private int m_index;
        private int m_prev_index;
        private int m_next_index;
        private List m_constants;

        ConstantIterator(List list) {
            this.m_constants = list;
            this.m_next_index = 1;
            this.shift();
        }

        public int nextIndex() {
            int n = this.m_index;
            this.shift();
            return n;
        }

        public CONSTANT_info nextConstant() {
            int n = this.nextIndex();
            if (n < 0) {
                return null;
            }
            return (CONSTANT_info)this.m_constants.get(n - 1);
        }

        public CONSTANT_info set(CONSTANT_info cONSTANT_info) {
            int n = this.m_prev_index - 1;
            CONSTANT_info cONSTANT_info2 = (CONSTANT_info)this.m_constants.get(n);
            if (cONSTANT_info2 == null) {
                throw new IllegalStateException("assertion failure: dereferencing an invalid constant pool slot " + this.m_prev_index);
            }
            if (cONSTANT_info2.width() != cONSTANT_info.width()) {
                throw new IllegalArgumentException("assertion failure: can't set entry of type [" + cONSTANT_info2.getClass().getName() + "] to an entry of type [" + cONSTANT_info2.getClass().getName() + "] at pool slot " + this.m_prev_index);
            }
            this.m_constants.set(n, cONSTANT_info);
            return cONSTANT_info2;
        }

        private void shift() {
            this.m_prev_index = this.m_index;
            this.m_index = this.m_next_index;
            if (this.m_index > 0) {
                try {
                    CONSTANT_info cONSTANT_info = (CONSTANT_info)this.m_constants.get(this.m_index - 1);
                    this.m_next_index += cONSTANT_info.width();
                    if (this.m_next_index > this.m_constants.size()) {
                        this.m_next_index = -1;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.m_next_index = -1;
                    this.m_index = -1;
                }
            }
        }
    }
}

