/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.BridgeAttribute_info;
import com.vladium.jcd.cls.attribute.InnerClassesAttribute_info;
import com.vladium.jcd.cls.attribute.SyntheticAttribute_info;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class AttributeCollection
implements IAttributeCollection {
    private List m_attributes;
    private transient int m_syntheticRefCount;
    private transient int m_bridgeRefCount;
    private transient int m_innerClassesAttributeOffset;
    private static final boolean DISALLOW_MULTIPLE_SYNTHETIC_ATTRIBUTES = false;

    public final Attribute_info get(int n) {
        return (Attribute_info)this.m_attributes.get(n);
    }

    public final boolean hasSynthetic() {
        return this.m_syntheticRefCount > 0;
    }

    public final boolean hasBridge() {
        return this.m_bridgeRefCount > 0;
    }

    public final InnerClassesAttribute_info getInnerClassesAttribute() {
        int n = this.m_innerClassesAttributeOffset;
        if (n < 0) {
            return null;
        }
        return (InnerClassesAttribute_info)this.get(n);
    }

    public final int size() {
        return this.m_attributes.size();
    }

    public final long length() {
        long l = 2L;
        int n = this.m_attributes.size();
        for (int i = 0; i < n; ++i) {
            l += this.get(i).length();
        }
        return l;
    }

    public Object clone() {
        try {
            AttributeCollection attributeCollection = (AttributeCollection)super.clone();
            int n = this.m_attributes.size();
            attributeCollection.m_attributes = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                attributeCollection.m_attributes.add(((Attribute_info)this.m_attributes.get(i)).clone());
            }
            return attributeCollection;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        int n = this.size();
        uDataOutputStream.writeU2(n);
        for (int i = 0; i < n; ++i) {
            this.get(i).writeInClassFormat(uDataOutputStream);
        }
    }

    public void accept(IClassDefVisitor iClassDefVisitor, Object object) {
        iClassDefVisitor.visit(this, object);
    }

    public int add(Attribute_info attribute_info) {
        List list = this.m_attributes;
        int n = list.size();
        list.add(attribute_info);
        if (attribute_info instanceof SyntheticAttribute_info) {
            ++this.m_syntheticRefCount;
        } else if (attribute_info instanceof InnerClassesAttribute_info) {
            if (this.m_innerClassesAttributeOffset >= 0) {
                throw new IllegalArgumentException("this attribute collection already has an InnerClasses attribute");
            }
            this.m_innerClassesAttributeOffset = n;
        } else if (attribute_info instanceof BridgeAttribute_info) {
            ++this.m_bridgeRefCount;
        }
        return n;
    }

    public Attribute_info set(int n, Attribute_info attribute_info) {
        Attribute_info attribute_info2 = this.m_attributes.set(n, attribute_info);
        if (attribute_info2 instanceof SyntheticAttribute_info) {
            --this.m_syntheticRefCount;
        } else if (attribute_info2 instanceof InnerClassesAttribute_info) {
            this.m_innerClassesAttributeOffset = -1;
        } else if (attribute_info2 instanceof BridgeAttribute_info) {
            --this.m_bridgeRefCount;
        }
        if (attribute_info instanceof SyntheticAttribute_info) {
            ++this.m_syntheticRefCount;
        } else if (attribute_info instanceof InnerClassesAttribute_info) {
            this.m_innerClassesAttributeOffset = n;
        } else if (attribute_info instanceof BridgeAttribute_info) {
            ++this.m_bridgeRefCount;
        }
        return attribute_info2;
    }

    public Attribute_info remove(int n) {
        Attribute_info attribute_info = (Attribute_info)this.m_attributes.remove(n);
        if (attribute_info instanceof SyntheticAttribute_info) {
            --this.m_syntheticRefCount;
        } else if (attribute_info instanceof InnerClassesAttribute_info) {
            this.m_innerClassesAttributeOffset = -1;
        } else if (attribute_info instanceof BridgeAttribute_info) {
            --this.m_bridgeRefCount;
        }
        return attribute_info;
    }

    AttributeCollection(int n) {
        this.m_attributes = n < 0 ? new ArrayList() : new ArrayList(n);
        this.m_innerClassesAttributeOffset = -1;
    }
}

