/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.logging.Logger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

final class MetaData
implements IMetaData,
Cloneable {
    private final CoverageOptions m_options;
    private boolean m_hasSrcFileInfo;
    private boolean m_hasLineNumberInfo;
    private HashMap m_classMap;
    private transient HashSet m_packagesWarned;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetaData shallowCopy() {
        HashMap hashMap;
        MetaData metaData;
        try {
            metaData = (MetaData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.toString());
        }
        Object object = this.lock();
        synchronized (object) {
            hashMap = (HashMap)this.m_classMap.clone();
        }
        metaData.m_classMap = hashMap;
        return metaData;
    }

    public CoverageOptions getOptions() {
        return this.m_options;
    }

    public int size() {
        return this.m_classMap.size();
    }

    public boolean hasSrcFileData() {
        return this.m_hasSrcFileInfo;
    }

    public boolean hasLineNumberData() {
        return this.m_hasLineNumberInfo;
    }

    public Iterator iterator() {
        return this.m_classMap.values().iterator();
    }

    public boolean hasDescriptor(String string) {
        return this.m_classMap.containsKey(string);
    }

    public Object lock() {
        return this.m_classMap;
    }

    public boolean add(ClassDescriptor classDescriptor, boolean bl) {
        String string = classDescriptor.getClassVMName();
        if (bl || !this.m_classMap.containsKey(string)) {
            String string2;
            Logger logger;
            this.m_classMap.put(string, classDescriptor);
            boolean bl2 = false;
            if (!classDescriptor.hasSrcFileInfo()) {
                this.m_hasSrcFileInfo = false;
                bl2 = true;
            }
            if (!classDescriptor.hasCompleteLineNumberInfo()) {
                this.m_hasLineNumberInfo = false;
                bl2 = true;
            }
            if (bl2 && (logger = Logger.getLogger()).atINFO() && this.m_packagesWarned.add(string2 = classDescriptor.getPackageVMName())) {
                logger.info("package [" + string2 + "] contains classes [" + classDescriptor.getName() + "] without full debug info");
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.m_classMap.isEmpty();
    }

    public IMergeable merge(IMergeable iMergeable) {
        if (iMergeable == null || iMergeable.isEmpty() || iMergeable == this) {
            return this;
        }
        MetaData metaData = (MetaData)iMergeable;
        HashMap hashMap = metaData.m_classMap;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            this.m_classMap.put(string, v);
        }
        if (!metaData.hasSrcFileData()) {
            this.m_hasSrcFileInfo = false;
        }
        if (!metaData.hasLineNumberData()) {
            this.m_hasLineNumberInfo = false;
        }
        return this;
    }

    MetaData(CoverageOptions coverageOptions) {
        this.m_options = coverageOptions;
        this.m_hasSrcFileInfo = true;
        this.m_hasLineNumberInfo = true;
        this.m_classMap = new HashMap();
        this.m_packagesWarned = new HashSet();
    }

    static MetaData readExternal(DataInput dataInput) throws IOException {
        CoverageOptions coverageOptions = CoverageOptions.readExternal(dataInput);
        boolean bl = dataInput.readBoolean();
        boolean bl2 = dataInput.readBoolean();
        int n = dataInput.readInt();
        HashMap<String, ClassDescriptor> hashMap = new HashMap<String, ClassDescriptor>(n);
        for (int i = 0; i < n; ++i) {
            String string = dataInput.readUTF();
            ClassDescriptor classDescriptor = ClassDescriptor.readExternal(dataInput);
            hashMap.put(string, classDescriptor);
        }
        return new MetaData(coverageOptions, hashMap, bl, bl2);
    }

    static void writeExternal(MetaData metaData, DataOutput dataOutput) throws IOException {
        CoverageOptions.writeExternal(metaData.m_options, dataOutput);
        dataOutput.writeBoolean(metaData.m_hasSrcFileInfo);
        dataOutput.writeBoolean(metaData.m_hasLineNumberInfo);
        HashMap hashMap = metaData.m_classMap;
        int n = hashMap.size();
        dataOutput.writeInt(n);
        Iterator iterator = hashMap.entrySet().iterator();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            ClassDescriptor classDescriptor = (ClassDescriptor)entry.getValue();
            dataOutput.writeUTF(string);
            ClassDescriptor.writeExternal(classDescriptor, dataOutput);
        }
    }

    private MetaData(CoverageOptions coverageOptions, HashMap hashMap, boolean bl, boolean bl2) {
        this.m_options = coverageOptions;
        this.m_hasSrcFileInfo = bl;
        this.m_hasLineNumberInfo = bl2;
        this.m_classMap = hashMap;
    }
}

