/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FolderTypeRelationship {
    private static final Map<ResourceType, List<ResourceFolderType>> mTypeToFolderMap = new HashMap<ResourceType, List<ResourceFolderType>>();
    private static final Map<ResourceFolderType, List<ResourceType>> mFolderToTypeMap = new HashMap<ResourceFolderType, List<ResourceType>>();

    public static List<ResourceType> getRelatedResourceTypes(ResourceFolderType folderType) {
        List<ResourceType> list = mFolderToTypeMap.get((Object)folderType);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static List<ResourceFolderType> getRelatedFolders(ResourceType resType) {
        List<ResourceFolderType> list = mTypeToFolderMap.get((Object)resType);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean match(ResourceType resType, ResourceFolderType folderType) {
        List<ResourceFolderType> list = mTypeToFolderMap.get((Object)resType);
        if (list != null) {
            return list.contains((Object)folderType);
        }
        return false;
    }

    private static void add(ResourceType type, ResourceFolderType folder) {
        List<ResourceType> typeList;
        List<ResourceFolderType> folderList = mTypeToFolderMap.get((Object)type);
        if (folderList == null) {
            folderList = new ArrayList<ResourceFolderType>();
            mTypeToFolderMap.put(type, folderList);
        }
        if (folderList.indexOf((Object)folder) == -1) {
            folderList.add(folder);
        }
        if ((typeList = mFolderToTypeMap.get((Object)folder)) == null) {
            typeList = new ArrayList<ResourceType>();
            mFolderToTypeMap.put(folder, typeList);
        }
        if (typeList.indexOf((Object)type) == -1) {
            typeList.add(type);
        }
    }

    private static void makeSafe() {
        List<Enum> list;
        for (ResourceType resourceType : ResourceType.values()) {
            list = mTypeToFolderMap.get((Object)resourceType);
            if (list == null) continue;
            mTypeToFolderMap.put(resourceType, Collections.unmodifiableList(list));
        }
        for (Enum enum_ : ResourceFolderType.values()) {
            list = mFolderToTypeMap.get(enum_);
            if (list == null) continue;
            mFolderToTypeMap.put((ResourceFolderType)enum_, Collections.unmodifiableList(list));
        }
    }

    static {
        FolderTypeRelationship.add(ResourceType.ANIM, ResourceFolderType.ANIM);
        FolderTypeRelationship.add(ResourceType.ANIMATOR, ResourceFolderType.ANIMATOR);
        FolderTypeRelationship.add(ResourceType.ARRAY, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.ATTR, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.BOOL, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.COLOR, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.COLOR, ResourceFolderType.COLOR);
        FolderTypeRelationship.add(ResourceType.DECLARE_STYLEABLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.DIMEN, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.DRAWABLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.DRAWABLE, ResourceFolderType.DRAWABLE);
        FolderTypeRelationship.add(ResourceType.FRACTION, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.INTEGER, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.INTERPOLATOR, ResourceFolderType.INTERPOLATOR);
        FolderTypeRelationship.add(ResourceType.LAYOUT, ResourceFolderType.LAYOUT);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.LAYOUT);
        FolderTypeRelationship.add(ResourceType.MENU, ResourceFolderType.MENU);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.MENU);
        FolderTypeRelationship.add(ResourceType.MIPMAP, ResourceFolderType.MIPMAP);
        FolderTypeRelationship.add(ResourceType.PLURALS, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.PUBLIC, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.RAW, ResourceFolderType.RAW);
        FolderTypeRelationship.add(ResourceType.STRING, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.STYLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.STYLEABLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.XML, ResourceFolderType.XML);
        FolderTypeRelationship.makeSafe();
    }
}

