/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.client.api.IDomParser;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObsoleteLayoutParamsDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("ObsoleteLayoutParam", "Obsolete layout params", "Looks for layout params that are not valid for the given parent layout", "The given layout_param is not defined for the given layout, meaning it has no effect. This usually happens when you change the parent layout or move view code around without updating the layout params. This will cause useless attribute processing at runtime, and is misleading for others reading the layout so the parameter should be removed.", Category.PERFORMANCE, 6, Severity.WARNING, new Implementation(ObsoleteLayoutParamsDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final Set<String> VALID = new HashSet<String>(10);
    private static final Map<String, String> PARAM_TO_VIEW = new HashMap<String, String>(28);
    private Map<String, List<Pair<File, String>>> mIncludes;
    private final List<Pair<String, Location.Handle>> mPending = new ArrayList<Pair<String, Location.Handle>>();

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("include");
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String name = attribute.getLocalName();
        if (name != null && name.startsWith("layout_") && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            if (VALID.contains(name)) {
                return;
            }
            String parent = PARAM_TO_VIEW.get(name);
            if (parent != null) {
                Element viewElement = attribute.getOwnerElement();
                Node layoutNode = viewElement.getParentNode();
                if (layoutNode == null || layoutNode.getNodeType() != 1) {
                    if (context.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
                        IDomParser parser = context.parser;
                        Location.Handle handle = parser.createLocationHandle(context, attribute);
                        handle.setClientData(attribute);
                        this.mPending.add((Pair<String, Location.Handle>)Pair.of((Object)name, (Object)handle));
                    }
                    return;
                }
                String parentTag = ((Element)layoutNode).getTagName();
                if (parentTag.equals("merge")) {
                    if (context.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
                        IDomParser parser = context.parser;
                        Location.Handle handle = parser.createLocationHandle(context, attribute);
                        handle.setClientData(attribute);
                        this.mPending.add((Pair<String, Location.Handle>)Pair.of((Object)name, (Object)handle));
                    }
                    return;
                }
                if (!ObsoleteLayoutParamsDetector.isValidParamForParent(context, name, parent, parentTag)) {
                    if (name.equals("layout_column") && ObsoleteLayoutParamsDetector.isValidParamForParent(context, name, "TableRow", parentTag)) {
                        return;
                    }
                    context.report(ISSUE, attribute, context.getLocation(attribute), String.format("Invalid layout param in a %1$s: %2$s", parentTag, name), null);
                }
            }
        }
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String layout = element.getAttribute("layout");
        if (layout.startsWith("@layout/")) {
            String tag;
            layout = layout.substring("@layout/".length());
            Node parent = element.getParentNode();
            if (parent.getNodeType() == 1 && (tag = parent.getNodeName()).indexOf(46) == -1 && !tag.equals("merge")) {
                List<Pair<File, String>> includes;
                if (!context.getProject().getReportIssues()) {
                    return;
                }
                if (this.mIncludes == null) {
                    this.mIncludes = new HashMap<String, List<Pair<File, String>>>();
                }
                if ((includes = this.mIncludes.get(layout)) == null) {
                    includes = new ArrayList<Pair<File, String>>();
                    this.mIncludes.put(layout, includes);
                }
                includes.add((Pair<File, String>)Pair.of((Object)context.file, (Object)tag));
            }
        }
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (this.mIncludes == null) {
            return;
        }
        for (Pair<String, Location.Handle> pending : this.mPending) {
            String name;
            String parent;
            List<Pair<File, String>> includes;
            Location.Handle handle = (Location.Handle)pending.getSecond();
            Location location = handle.resolve();
            File file = location.getFile();
            String layout = file.getName();
            if (layout.endsWith(".xml")) {
                layout = layout.substring(0, layout.length() - ".xml".length());
            }
            if ((includes = this.mIncludes.get(layout)) == null || (parent = PARAM_TO_VIEW.get(name = (String)pending.getFirst())) == null) continue;
            boolean isValid = false;
            for (Pair<File, String> include : includes) {
                String parentTag = (String)include.getSecond();
                if (ObsoleteLayoutParamsDetector.isValidParamForParent(context, name, parent, parentTag)) {
                    isValid = true;
                    break;
                }
                if (isValid || !name.equals("layout_column") || !ObsoleteLayoutParamsDetector.isValidParamForParent(context, name, "TableRow", parentTag)) continue;
                isValid = true;
                break;
            }
            if (isValid) continue;
            Object clientData = handle.getClientData();
            if (clientData instanceof Node && context.getDriver().isSuppressed(ISSUE, (Node)clientData)) {
                return;
            }
            StringBuilder sb = new StringBuilder(40);
            for (Pair<File, String> include : includes) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                File from = (File)include.getFirst();
                String parentTag = (String)include.getSecond();
                sb.append(String.format("included from within a %1$s in %2$s", parentTag, from.getParentFile().getName() + File.separator + from.getName()));
            }
            String message = String.format("Invalid layout param '%1$s' (%2$s)", name, sb.toString());
            context.report(ISSUE, location, message, null);
        }
    }

    private static boolean isValidParamForParent(Context context, String name, String parent, String parentTag) {
        if (parentTag.indexOf(46) != -1 || parentTag.equals("view")) {
            return true;
        }
        SdkInfo sdk = context.getSdkInfo();
        if (!parentTag.equals(parent)) {
            String tag = sdk.getParentViewName(parentTag);
            while (tag != null) {
                if (tag.equals(parent)) {
                    return true;
                }
                tag = sdk.getParentViewName(tag);
            }
            return false;
        }
        return true;
    }

    static {
        VALID.add("layout_width");
        VALID.add("layout_height");
        VALID.add("layout_gravity");
        VALID.add("layout_marginLeft");
        VALID.add("layout_marginRight");
        VALID.add("layout_marginTop");
        VALID.add("layout_marginBottom");
        VALID.add("layout_margin");
        PARAM_TO_VIEW.put("layout_x", "AbsoluteLayout");
        PARAM_TO_VIEW.put("layout_y", "AbsoluteLayout");
        PARAM_TO_VIEW.put("layout_weight", "LinearLayout");
        PARAM_TO_VIEW.put("layout_column", "GridLayout");
        PARAM_TO_VIEW.put("layout_columnSpan", "GridLayout");
        PARAM_TO_VIEW.put("layout_row", "GridLayout");
        PARAM_TO_VIEW.put("layout_rowSpan", "GridLayout");
        PARAM_TO_VIEW.put("layout_rowSpan", "GridLayout");
        PARAM_TO_VIEW.put("layout_span", "TableRow");
        PARAM_TO_VIEW.put("layout_alignLeft", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_alignRight", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_alignTop", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_alignBottom", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_alignParentTop", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_alignParentBottom", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_alignParentLeft", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_alignParentRight", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_alignWithParentIfMissing", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_alignBaseline", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_centerInParent", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_centerVertical", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_centerHorizontal", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_toRightOf", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_toLeftOf", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_below", "RelativeLayout");
        PARAM_TO_VIEW.put("layout_above", "RelativeLayout");
    }
}

