# Parameters      {#parameters}

In Table \ref common-params, Table \ref optim-params and Table \ref evolve-params we list all parameters and the default values used by the applications. They are split between common %MPS parameters (valid in all codes), optimization parameters (available only in `mps_optim`) and time evolution specific parameters (for `mps_evolve`). Models, lattice and measurements are parameters of the ALPS model and lattice libraries, we point the reader to the ALPS paper \cite alps-paper and [ALPS website][alps-web] for further details.


## Initial states ##
The %MPS applications can be initialized with four different types of initial states.

**default**
The default initial state constructs an %MPS which contains all allowed quantum number sectors that fulfill the total quantum numbers chosen by the user. In each %MPS tensor all sectors will have a maximum size of 5x5 and they will be filled with random numbers.

**thin**
The thin initial state is an extension of the default option. After constructing the default %MPS the routine performs a compression retaining only a total 20 truncated states per site. This initial state reduces considerably the number of sectors that the code has to tackle in the warm up sweeps. Sometimes it leads to faster convergence.

**basis state**
A many body basis state is easily encoded in a product state as an %MPS with bond dimension M=1. With this option the user can design its own initial state listing the desired local quantum numbers in the input file as illustrated in Table \ref common-params.

**input file**
The checkpoint file generated by a simulation can easily be reused in a new simulation by specifying it in the `initfile` parameter. This option is often used to start a time evolution from the ground state of an other model.


## Temporary memory ##
An %MPS simulation easily requires more than 100 GB of memory for the storage of boundary objects, i.e. partial contractions of the %MPS network needed to reduce the complexity of the variational optimization to only \f$\mathcal{O}(M^3)\f$.

Our codes are capable of efficiently move this temporary memory to disk. This option is enabled by giving a non-empty value to the parameter `storagedir`. Since the application will often write >100 GB of temporary data it is advised to use fast filesystems, e.g. running on a local hard disk instead of a network mount. Once a simulation finishes the user can safely erase all temporary data.


## Common parameters  ##

| Parameter                         | Default  | Description |
| ---------                         |:-------: | ----------- |
| `MAXSTATES`                       |          | Maximum size of the matrices \f$M_{\sigma_i}\f$ |
| `TRUNCATION`                      | 1e-8     | Smallest singular value to be kept |
| `seed`                            | 42       | Seed of the internal random number generator |
| `CONSERVED_QUANTUMNUMBERS`        |          | Comma-separated list of the quantum numbers to be conserved |
| `QN_total`                        |          | Total value of the quantum number `QN`. `QN` is one of the quantum numbers defined in the parameter `CONSERVED_QUANTUMNUMBERS`. Example: `N_total = 8` fixes the total number of particles to 8.  |
| `initfile`                        |          | Path to an existing checkpoint MPS to use it as initial MPS |
| `init_state`                      | default  | Initial state of the simulation (in case `initfile` is not set). Possible values: `default', `thin', `local_quantumnumbers'. |
| `initial_local_QN`                |          | Comma-separated list with the value of the local quantum number `QN` at every site |
| `MEASURE_LOCAL[NAME]`             |          | Defines a new local measurement called `NAME`. Its value specifies the operator to be measured.  Example: `MEASURE_LOCAL[Local density] = "n"` |
| `MEASURE_AVERAGE[NAME]`           |          | Defines a new average measurement called `NAME`. Its value specifies the operator to be measured.  Example: `MEASURE_AVERAGE[Density] = "n"` |
| `MEASURE_CORRELATIONS[NAME]`      |          | Defines a new correlation measurement called `NAME`. Its value specifies the operators to be correlated separated by ":" (colon) If the operators define two or more *BONDOPERATORS*, e.g., *Op_A* and *Op_B* the correlation measurement compute all observables \f$\left \langle {\psi} | {\mathtt{Op_A}(i, i+1)\, \mathtt{Op_B}(j, j+1)} | {\psi} \right \rangle\f$. Example: `MEASURE_CORRELATIONS[Onebody Density Matrix] = "bdag:b"` |
| `MEASURE_HALF_CORRELATIONS[NAME]` |          | Same as `MEASURE_CORRELATIONS` but it does not exchange the order of operators. If the input is, e.g., `bdag:b`, the first operator will be evaluated at all locatios \f$i\in[0,L-2]\f$ but the second operator only at locations \f$j\in[i,L-1]\f$. |
| `MEASURE_LOCAL_AT[NAME]`          |          | Syntax for the value: ![ ](local_at_value.svg) Defines a new measurement called `NAME` where the sequence of operators `op_1:...:op_n` is applied to all tuples of indices (of length *n* like the number of operators) listed after the vertical bar symbol.  |
| `MEASURE[EnergyVariance]`         | False    | Measure the energy variance |
| `MEASURE[Entropy]`                | False    | Measure the von Neumann entropy |
| `MEASURE[Renyi2]`                 | False    | Measure *n=2* Renyi entropy |
| `ALWAYS_MEASURE`                  |          | Comma-separated list of measurements to evaluate at the end of every sweep |
| `COMPLEX`                         | False    | Use complex numbers. For time evolution simulations the default value is changed to True. |
| `storagedir`                      |          | Path to the directory to be used for temporary storage. If empty, temporary storage is disabled. |

## Optimization parameters ##

| Parameter           | Default  | Description                                                                                                    |
| ---------           |:-------: | -----------                                                                                                    |
|`SWEEPS`             |          | Number of sweeps                                                                                               |
|`NUMBER_EIGENVALUES` | 1        | Number of eigenstate to target                                                                                 |
|`optimization`       | twosite  | Optimisation algorithm. Possible values are `singlesite', `twosite'.                                           |
|`ngrowsweeps`        |          |  Single site only. Number of initial sweeps where the correction factor has the value `alpha_initial`.         |
|`nmainsweeps`        |          |  Single site only. Number of sweeps after `ngrowsweeps`where the correction factor has the value `alpha_main`. |
|`alpha_initial`      | 1e-2     | Correction factor for single site optimization in the initial part                                             |
|`alpha_main`         | 1e-4     | Correction factor for single site optimization in the main part                                                |
|`alpha_final`        | 1e-8     | Correction factor for single site optimization in the final part                                               |
|`ietl_jcd_toll`      | 1e-8     | Convergence tolerance of the Jacobi-Davidson solver                                                            |
|`ietl_jcd_gmres`     | 0        | Convergence tolerance of the Jacobi-Davidson solver                                                            |
|`ietl_jcd_maxiter`   | 8        | Maximum number of iterations in the Jacobi-Davidson solver                                                     |
|`rel_en_thresh`      | 1e-8     | Relative energy threshold to stop simulation                                                                   |
|`rel_en_thresh_at`   | none     | Position where to measure the relative energy threshold (none, half, end)                                      |

## Time evolution parameters ##

| Parameter         | Default           | Description |
| ---------         | :-------:         | ----------- |
| `DT`              |                   | Time step |
| `IMG_TIMESTEPS`   | 0                 | Number of imaginary time sweeps to perform before the proceeding with the real time evolution |
| `TIMESTEPS`       |                   | Total number of sweeps |
| `te_order`        | fourth            | Order of the trotter decomposition. Possible values: `second', `fourth'. |
| `te_type`         | nn                | Type of time evolution algorithm. Possible values: `nn' (for nearest neighbors), `mpo'. |
| `mpo_compression` | twosite           | MPO compression used by mpo time evolution: singlesite or twosite |
| `chkp_each`       | 1                 | A checkpoint is created every `chkp_each` time steps. |
| `measure_each`    | 1                 | Measurements are performed every `measure_each` time steps. |
| `update_each`     | -1                | Update the Hamiltonian parameters every `update_each` time steps. Used while quenching Hamiltonian parameters. A negative value will never change the Hamiltonian. |
| `P[Time]`         |                   | Values assigned to the parameter `P` at each time step |


[alps-web]: http://alps.comp-phys.org
