/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Libraries
*
* Copyright (C) 1994-2005 by Matthias Troyer <troyer@itp.phys.ethz.ch>
*
* This software is part of the ALPS libraries, published under the ALPS
* Library License; you can use, redistribute it and/or modify it under
* the terms of the license, either version 1 or (at your option) any later
* version.
* 
* You should have received a copy of the ALPS Library License along with
* the ALPS Libraries; see the file LICENSE.txt. If not, the license is also
* available from http://alps.comp-phys.org/.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: archivedump.h 5976 2012-01-28 00:59:57Z wistaria $ */

#ifndef ALPS_OSIRIS_ARCHIVEDUMP_H
#define ALPS_OSIRIS_ARCHIVEDUMP_H

#include <alps/osiris/dump.h>
#include <iostream>

namespace alps {

/** A class to use a Boost output archive as an Osiris dump  */

template <class ARCHIVE> 
class archive_odump : public ODump
{
public:
  archive_odump (ARCHIVE& a) : archive_(a) {}    
  ~archive_odump() {}

/// INTERNAL ONLY
# define ALPS_DUMP_DO_TYPE(T) void write_simple(T x) { archive_ << x;}
  ALPS_DUMP_DO_TYPE(bool)
  ALPS_DUMP_DO_TYPE(char)
  ALPS_DUMP_DO_TYPE(signed char)
  ALPS_DUMP_DO_TYPE(unsigned char)
  ALPS_DUMP_DO_TYPE(short)
  ALPS_DUMP_DO_TYPE(unsigned short)
  ALPS_DUMP_DO_TYPE(int)
  ALPS_DUMP_DO_TYPE(unsigned int)
  ALPS_DUMP_DO_TYPE(long)
  ALPS_DUMP_DO_TYPE(unsigned long)
# ifdef BOOST_HAS_LONG_LONG
  ALPS_DUMP_DO_TYPE(long long)
  ALPS_DUMP_DO_TYPE(unsigned long long)
# endif
  ALPS_DUMP_DO_TYPE(float)
  ALPS_DUMP_DO_TYPE(double)
  ALPS_DUMP_DO_TYPE(long double)
# undef ALPS_DUMP_DO_TYPE
    
  // write a C-style string
  void write_string(std::size_t, const char * x) { write_string(std::string(x));}
  void write_string(const std::string& s) { archive_.operator<<(s);}

private:
  ARCHIVE& archive_; // the Boost archive
};


/** A class to use a Boost input archive as an Osiris dump  */

template <class ARCHIVE> 
class archive_idump : public IDump
{
public:
  archive_idump (ARCHIVE& a) : archive_(a) {}    
  ~archive_idump() {}

/// INTERNAL ONLY
# define ALPS_DUMP_DO_TYPE(T) void read_simple(T& x) { archive_ >> x;}
  ALPS_DUMP_DO_TYPE(bool)
  ALPS_DUMP_DO_TYPE(char)
  ALPS_DUMP_DO_TYPE(signed char)
  ALPS_DUMP_DO_TYPE(unsigned char)
  ALPS_DUMP_DO_TYPE(short)
  ALPS_DUMP_DO_TYPE(unsigned short)
  ALPS_DUMP_DO_TYPE(int)
  ALPS_DUMP_DO_TYPE(unsigned int)
  ALPS_DUMP_DO_TYPE(long)
  ALPS_DUMP_DO_TYPE(unsigned long)
# ifdef BOOST_HAS_LONG_LONG
  ALPS_DUMP_DO_TYPE(long long)
  ALPS_DUMP_DO_TYPE(unsigned long long)
# endif
  ALPS_DUMP_DO_TYPE(float)
  ALPS_DUMP_DO_TYPE(double)
  ALPS_DUMP_DO_TYPE(long double)
# undef ALPS_DUMP_DO_TYPE
      
  void read_string(std::size_t, char* s) {std::string y; archive_ >> y; std::strcpy(s,y.c_str());}
  void read_string(std::string& s) { archive_ >> s;}
  
private:
  ARCHIVE& archive_; // the Boost archive
};

} // end namespace alps

#endif // ALPS_OSIRIS_ARCHIVEDUMP_H
