# - FindLapack.cmake
# Find LAPACK/BLAS (and compatible) numerical libraries
#
# This module will define the following values:
# LAPACK_LIBRARY
# BLAS_LIBRARY
#
# 0) check if BLAS_LIBRARY and LAPACK_LIBRARY have already been set on command line, if so: take these values.
# 1) search ENV MKL 
# 2) search MKL in usual paths
# 3) search ENV ATLAS
# 4) search generic lapack/blas using CMake-provided FindLAPACK.cmake
#     if BLA_VENDOR is set, try to use that vendor's LAPACK implementation
# 5) if build is on cray use hardcoded path
# 6) give up

#  Copyright (C)  2009-2010 Matthias Troyer <troyer@comp-phys.org>
#  Copyright (C)  2009-2010 Synge Todo <wistaria@comp-phys.org>
#  Copyright (C)  2009-2010 Bela Bauer
#  Copyright (C)  2009-2010 Brigitte Surer
#  Copyright (C)  2009-2010 Lukas Gamper
#  Copyright (C)  2009-2010 Ryo IGARASHI <rigarash@hosi.phys.s.u-tokyo.ac.jp>
#  Copyright (C)       2010 Emanuel Gull <gull@phys.columbia.edu>
#
#  Distributed under the Boost Software License, Version 1.0.
#      (See accompanying file LICENSE_1_0.txt or copy at
#          http://www.boost.org/LICENSE_1_0.txt)

SET(MKL_PATHS "/usr/local/lib /usr/lib")

#IF(NOT QMC_BUILD_STATIC)

IF(BLAS_LIBRARY AND LAPACK_LIBRARY)
 SET(LAPACK_LIBRARY_INIT 1)
 SET(BLAS_LIBRARY_INIT 1)
ENDIF(BLAS_LIBRARY AND LAPACK_LIBRARY)

 
IF($ENV{MKL} MATCHES "mkl")
  MESSAGE(STATUS "Using intel/mkl library: $ENV{MKL}")
  #look for the path where the mkl is installed
  STRING(REGEX MATCHALL "[-][L]([^ ;])+" MKL_PATH_WITH_PREFIX  "$ENV{MKL}")
  STRING(REGEX REPLACE "[-][L]" "" MKL_PATHS ${MKL_PATH_WITH_PREFIX})
ENDIF($ENV{MKL} MATCHES "mkl")

SET(MKL_PATHS 
  $ENV{MKL_HOME}/lib/intel64${QMC_BITS}
  $ENV{MKL_HOME}/lib/em${QMC_BITS}t
  $ENV{MKL_HOME}/lib/${QMC_BITS}
  $ENV{MKL_HOME}/lib
  ${MKL_PATHS} 
  ) 
# MESSAGE(STATUS "Looking for intel/mkl library in ${MKL_PATHS}")

STRING(REGEX MATCH "[0-9]+\\.[0-9]+\\.[0-9]+" MKL_VERSION "$ENV{MKL_HOME}")
SET(LINK_LAPACK_DEFAULT 1)
IF(${MKL_VERSION} MATCHES "10\\.0\\.[0-2]")
  SET(LINK_LAPACK_DEFAULT 0)
ENDIF(${MKL_VERSION} MATCHES "10\\.0\\.[0-2]")

IF(NOT LAPACK_LIBRARY_INIT)
  IF(${CMAKE_SYSTEM_PROCESSOR} MATCHES "x86_64")
    IF(LINK_LAPACK_DEFAULT)
      FIND_LIBRARY(LAPACK_LIBRARY NAMES mkl_lapack PATHS ${MKL_PATHS})
      FIND_LIBRARY(BLAS_LIBRARY NAMES mkl PATHS ${MKL_PATHS})
    ELSE(LINK_LAPACK_DEFAULT)
      FIND_LIBRARY(LAPACK_LIBRARY STATIC NAMES mkl_lapack PATHS ${MKL_PATHS})
      FIND_LIBRARY(BLAS_LIBRARY  NAMES mkl_em64t PATHS ${MKL_PATHS})
      MESSAGE("-- mkl 10.0.[0-2] warning for EM64T")
      MESSAGE("-- Replace libmkl_lapack.so in CMakeCache.txt by libmkl_lapack.a")
    ENDIF(LINK_LAPACK_DEFAULT)
  ELSE(${CMAKE_SYSTEM_PROCESSOR} MATCHES "x86_64")
    FIND_LIBRARY(LAPACK_LIBRARY 
      NAMES mkl_lapack 
      PATHS ${MKL_PATHS}
      )
    FIND_LIBRARY(BLAS_LIBRARY
      NAMES mkl
      PATHS ${MKL_PATHS}
    )
  ENDIF(${CMAKE_SYSTEM_PROCESSOR} MATCHES "x86_64")

  FIND_LIBRARY(INTEL_GUIDE_LIBRARY
    NAMES guide
    PATHS ${MKL_PATHS}
  )
  MARK_AS_ADVANCED(INTEL_GUIDE_LIBRARY)
  IF(NOT INTEL_GUIDE_LIBRARY MATCHES "NOTFOUND")
    SET(REQUIRE_PTHREAD TRUE)
    FIND_LIBRARY(PTHREAD_LIBRARY NAMES pthread)
  ENDIF(NOT INTEL_GUIDE_LIBRARY MATCHES "NOTFOUND")
  IF(NOT BLAS_guide_LIBRARY MATCHES "NOTFOUND")
    SET(REQUIRE_PTHREAD TRUE)
    FIND_LIBRARY(PTHREAD_LIBRARY NAMES pthread)
  ENDIF(NOT BLAS_guide_LIBRARY MATCHES "NOTFOUND")

  IF(LAPACK_LIBRARY MATCHES "mkl")
    MESSAGE(STATUS "Found intel/mkl library")
    SET(LAPACK_LIBRARY_INIT 1)
    SET(BLAS_LIBRARY_INIT 1)
    SET(HAVE_MKL 1) # CACHE BOOL "HAVE_MKL is set to 1")
    SET(MKL_INC_PATHS $ENV{MKL_HOME}/include ${MKL_PATHS}) 
    FIND_PATH(MKL_INCLUDE_DIR mkl.h ${MKL_INC_PATHS})
    INCLUDE_DIRECTORIES(${MKL_INCLUDE_DIR})
  ENDIF(LAPACK_LIBRARY MATCHES "mkl")

ENDIF(NOT LAPACK_LIBRARY_INIT)

IF(NOT HAVE_MKL)
  IF(${CMAKE_SYSTEM_NAME} MATCHES "Darwin")
    SET(CMAKE_CXX_LINK_FLAGS "${CMAKE_CXX_LINK_FLAGS} -framework vecLib")
    SET(LAPACK_LIBRARY_INIT 1)
    SET(MAC_VECLIB 1 CACHE BOOL "use Mac Framework")
    SET(LAPACK_LIBRARY "")
    MESSAGE(STATUS "Using Framework on Darwin.")

    ## check goto library: does not work so well
    #FIND_LIBRARY(BLAS_LIBRARY NAMES goto
    #    PATHS 
    #    $ENV{GOTOBLAS_HOME}
    #    /usr/lib
    #    /usr/local/lib
    #    /sw/lib
    #    )
    SET(BLAS_LIBRARY "")
    SET(BLAS_LIBRARY_INIT 1)
  ENDIF(${CMAKE_SYSTEM_NAME} MATCHES "Darwin")
ENDIF(NOT HAVE_MKL)

IF($ENV{ATLAS} MATCHES "atlas")
  IF($ENV{ATLAS} MATCHES "lapack") 
    SET(LAPACK_LIBRARY_INIT 1)
  ENDIF($ENV{ATLAS} MATCHES "lapack") 
  SET(BLAS_LIBRARY $ENV{ATLAS})
  SET(BLAS_LIBRARY_INIT 1)
ENDIF($ENV{ATLAS} MATCHES "atlas")

IF($ENV{LAPACK} MATCHES "lapack")
  SET(LAPACK_LIBRARY $ENV{LAPACK})
  SET(LAPACK_LIBRARY_INIT 1)
ENDIF($ENV{LAPACK} MATCHES "lapack")

#IF(${CMAKE_SYSTEM_NAME} MATCHES "Darwin")
#  SET(LAPACK_LIBRARY $ENV{LAPACK})
#  SET(LAPACK_LIBRARY_INIT 1)
#ENDIF(${CMAKE_SYSTEM_NAME} MATCHES "Darwin")

IF(${CMAKE_SYSTEM_NAME} MATCHES "AIX")
  SET(ELIB essl)
  IF(ENABLE_OMP)
    SET(ELIB esslsmp)
  ENDIF(ENABLE_OMP)
   
  IF(NOT LAPACK_LIBRARY_INIT)
    SET(LLIB lapack-SP4_${QMC_BITS} lapack)
    FIND_LIBRARY(LAPACK_LIBRARY  
      NAMES ${LLIB}
      PATHS /usr/apps/math/lapack/LAPACK
      lib
      )
    FIND_LIBRARY(BLAS_LIBRARY ${ELIB}
                 /usr/lib
                )
  ENDIF(NOT LAPACK_LIBRARY_INIT)

  SET(LAPACK_LIBRARY_INIT 1)
  SET(BLAS_LIBRARY_INIT 1)
  MESSAGE(STATUS "Found lapack/blas on AIX system")
ENDIF(${CMAKE_SYSTEM_NAME} MATCHES "AIX")

# for clapack on Windows
IF(NOT LAPACK_LIBRARY_INIT)
  if(WIN32 AND NOT UNIX)
    set(TRIAL_PATHS "$ENV{HOMEDRIVE}$ENV{HOMEPATH}/opt/lib")
    find_library(LAPACK_LIBRARY lapack ${TRIAL_PATHS})
    find_library(BLAS_LIBRARY blas ${TRIAL_PATHS})
    if(LAPACK_LIBRARY AND BLAS_LIBRARY)
      SET(LAPACK_LIBRARY_INIT 1)
      SET(BLAS_LIBRARY_INIT 1)
      set(LAPACK_DEFINITIONS "-DBOOST_NUMERIC_BINDINGS_USE_CLAPACK=1" CACHE STRING "Lapack definitions")
      MARK_AS_ADVANCED(LAPACK_DEFINITIONS)
      MESSAGE(STATUS "Found Lapack: ${LAPACK_LIBRARY} ${BLAS_LIBRARY}")
    endif(LAPACK_LIBRARY AND BLAS_LIBRARY)
  endif(WIN32 AND NOT UNIX)
ENDIF(NOT LAPACK_LIBRARY_INIT)

#IF(NOT LAPACK_LIBRARY_INIT)
#  FIND_LIBRARY(LAPACK_LIBRARY NAMES lapack lapack_gnu
#    PATHS /usr/apps/math/lapack
#    /usr/lib
#    /opt/lib
#    /usr/local/lib
#    /sw/lib
#    )
#  IF(LAPACK_LIBRARY)
#    MESSAGE(STATUS "Found netlib lapack library")
#    SET(LAPACK_LIBRARY_INIT 1)
#  ENDIF(LAPACK_LIBRARY)
#ENDIF(NOT LAPACK_LIBRARY_INIT)

#IF(NOT BLAS_LIBRARY_INIT)
#  FIND_LIBRARY(BLAS_LIBRARY NAMES goto blas blas_gnu
#    PATHS 
#    $ENV{GOTOBLAS_HOME}
#    /usr/apps/math/lapack
#    /usr/lib
#    /opt/lib
#    /usr/local/lib
#    /sw/lib
#    )
#  IF(BLAS_LIBRARY)
#    MESSAGE(STATUS "Found netlib blas")
#    SET(BLAS_LIBRARY_INIT 1)
#  ENDIF(BLAS_LIBRARY)
#ENDIF(NOT BLAS_LIBRARY_INIT)

# Use CMake provided LAPACK/BLAS detection code
# Fortran compiler is needed
IF(NOT BLAS_LIBRARY_INIT AND NOT LAPACK_LIBRARY_INIT)
  enable_language(Fortran)
  message("Falling back to CMake provied LAPACK/BLAS detection.")
  find_package(BLAS)
  if(BLAS_FOUND)
    SET(BLAS_LIBRARY_INIT 1)
    SET(BLAS_LIBRARY ${BLAS_LIBRARIES})
    find_package(LAPACK)
    if(LAPACK_FOUND)
      SET(LAPACK_LIBRARY_INIT 1)
      SET(LAPACK_LIBRARY ${LAPACK_LIBRARIES})
    endif(LAPACK_FOUND)
  endif(BLAS_FOUND)
ENDIF(NOT BLAS_LIBRARY_INIT AND NOT LAPACK_LIBRARY_INIT)

### BRANDT
### MOVED BECAUSE OF SCOPE PROBLEM
### PROBABLY SHOULD BE FIXED
MARK_AS_ADVANCED(
  LAPACK_LIBRARY 
  BLAS_LIBRARY 
)

IF(USE_SCALAPACK)
  SET(PNPATHS 
    ${MKL_PATHS}
    ${BLACS_HOME}/lib
    ${SCALAPACK_HOME}/lib
    /usr/lib
    /opt/lib
    /usr/local/lib
    /sw/lib
    )

  IF(INTEL_MKL)
    FIND_LIBRARY(BLACSLIB mkl_blacs_${PLAT}_lp${QMC_BITS} PATHS  ${PNPATHS})
    FIND_LIBRARY(SCALAPACKLIB mkl_scalapack PATHS  ${PNPATHS})
  ENDIF(INTEL_MKL)

  IF(NOT SCALAPACKLIB)
    FIND_LIBRARY(BLACSLIB blacs_MPI-${PLAT}-{BLACSDBGLVL} PATHS  ${PNPATHS})
    FIND_LIBRARY(BLACSCINIT blacsCinit_MPI-${PLAT}-{BLACSDBGLVL} PATHS  ${PNPATHS})
    FIND_LIBRARY(SCALAPACKLIB scalapack PATHS  ${PNPATHS})
  ENDIF(NOT SCALAPACKLIB)

  IF(BLACSLIB AND SCALAPACKLIB)
    SET(FOUND_SCALAPACK 1 CACHE BOOL "Found scalapack library")
  ELSE(BLACSLIB AND SCALAPACKLIB)
    SET(FOUND_SCALAPACK 0 CACHE BOOL "Mising scalapack library")
  ENDIF(BLACSLIB AND SCALAPACKLIB)

  MARK_AS_ADVANCED(
    BLACSCINIT
    BLACSLIB
    SCALAPACKLIB
    FOUND_SCALAPACK
    )
ENDIF(USE_SCALAPACK)

IF(LAPACK_LIBRARY_INIT)
  SET(LAPACK_FOUND TRUE)
ENDIF(LAPACK_LIBRARY_INIT)

IF(ALPS_BUILD_ON_CRAY)
  MARK_AS_ADVANCED(
    BLAS_FOUND
    LAPACK_FOUND
  )
  SET(BLAS_FOUND TRUE)
  SET(LAPACK_FOUND TRUE)
ENDIF(ALPS_BUILD_ON_CRAY)
