// ===========================================================================
// File: "aidaUsage.c"
//                        Created: 2010-08-13 09:41:15
//              Last modification: 2014-06-24 15:50:40
// Author: Bernard Desgraupes
// e-mail: <bdesgraupes@users.sourceforge.net>
// Copyright (c) 2010-2014 Bernard Desgraupes
// All rights reserved.
// ===========================================================================

#include "aidaMain.h"


// ------------------------------------------------------------------------
// 
// "aida_usage" --
// 
// Print the basic usage string.
// 
// ------------------------------------------------------------------------
void
aida_usage(const char * fname)
{	
    aida_print_out("Usage:\n");
    aida_print_out("\t%s <subcommand> [options]\n", fname);
    aida_print_out("\t%s (-h|-v)\n", fname);
	aida_print_out("Available subcommands: ");
	aida_print_array(stdout, gAidaSubcommands, true);
    aida_print_out("Subcommands can be abbreviated.\n");
	aida_print_out("Type '%s help <subcommand>' to get info about a particular subcommand.\n", fname);
    aida_print_out("\t-h, --help       print help\n");
    aida_print_out("\t-v, --version    print version\n");
	aida_global_options_usage();
}


// ------------------------------------------------------------------------
// 
// "aida_print_help" --
// 
// Implement 'aida --help'.
// 
// ------------------------------------------------------------------------
void
aida_print_help()
{
	time_t		date;
	struct tm *	tm;
	char 		year[5];		
	
	time(&date);
	tm = localtime(&date);
	strftime(year, 5, "%Y", tm);
	aida_print_out("%s, version %s (%s)\n", gPrgName, gVersionStr, gDateStr);
	aida_print_out("Copyright (c) 2009-%s, Bernard Desgraupes <bdesgraupes@users.sourceforge.net>\n", (char*)year);
	aida_usage(gPrgName);
}


// ------------------------------------------------------------------------
// 
// "aida_convert_usage" --
// 
// Implement 'aida help convert'.
// 
// ------------------------------------------------------------------------
int aida_convert_usage() {
    aida_print_out("Syntax:\n");
	aida_print_out("\t%s convert [options] <file>\n", gPrgName);
    aida_print_out("Options:\n");
	aida_print_out("\t-collapse max number of eols (default 2)\n");
	aida_print_out("\t-eval     evaluate a Tcl command\n");
	aida_print_out("\t-from     input encoding\n");
	aida_print_out("\t-output   output file\n");
	aida_print_out("\t-prefix   prefix file\n");
	aida_print_out("\t-target   target format\n");
	aida_print_out("\t-to       output encoding\n");
	aida_global_options_usage();

	return TCL_OK;	
}


// ------------------------------------------------------------------------
// 
// "aida_help_usage" --
// 
// Implement 'aida help help'.
// 
// ------------------------------------------------------------------------
int aida_help_usage() {
    aida_print_out("Syntax:\n");
	aida_print_out("\t%s help [subcommand]\n", gPrgName);
	aida_print_out("\t%s help [keyword]\n", gPrgName);
	aida_print_out("Available subcommands: ");
	aida_print_array(stdout, gAidaSubcommands, true);	
	aida_print_out("Available keywords: ");
	aida_print_array(stdout, gAidaHelpKeywords, true);
    aida_print_out("Subcommands and keywords can be abbreviated.\n");
	
	return TCL_OK;	
}


// ------------------------------------------------------------------------
// 
// "aida_help_header" --
// 
// Implement 'aida help header'.
// 
// ------------------------------------------------------------------------
int aida_help_header() {
	int			result = TCL_OK;
	Tcl_Obj *	objv;

	objv = Tcl_NewStringObj("aida::getHeaderKeys", -1);
	
	result = Tcl_EvalObjv(gInterp, 1, &objv, TCL_EVAL_GLOBAL);
	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_usage" --
// 
// Implement 'aida help info'.
// 
// ------------------------------------------------------------------------
int aida_info_usage() {
    aida_print_out("Syntax:\n");
	aida_print_out("\t%s info <arg> ?target?\n", gPrgName);
	aida_print_out("<arg> can be: ");
	aida_print_array(stdout, gAidaInfos, true);
	aida_print_out("For attributes, extensions, mapping and parameters, one can specify a target.\n");
	
	return TCL_OK;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_attributes" --
// 
// Implement 'aida info attributes ?target?'.
// 
// ------------------------------------------------------------------------
int aida_info_attributes(char * inTarget) {
	int			i, objc = 1, result = TCL_OK;
	Tcl_Obj *	objv[2];

	objv[0] = Tcl_NewStringObj("aida::listAttributes", -1);
	if (inTarget != NULL) {
		objv[1] = Tcl_NewStringObj(inTarget, -1);
		objc++;
	} 
	for (i = 0; i < objc; i++) Tcl_IncrRefCount(objv[i]);
	result = Tcl_EvalObjv(gInterp, objc, objv, TCL_EVAL_GLOBAL);
	for (i = 0; i < objc; i++) Tcl_DecrRefCount(objv[i]);	

	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_configuration" --
// 
// Implement 'aida info attributes'.
// 
// ------------------------------------------------------------------------
int aida_info_configuration() {
	int			result = TCL_OK;
	Tcl_Obj *	objv;

	objv = Tcl_NewStringObj("aida::configFiles", -1);
	result = Tcl_EvalObjv(gInterp, 1, &objv, TCL_EVAL_GLOBAL);
	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_encodings" --
// 
// Implement 'aida info encodings'.
// 
// ------------------------------------------------------------------------
int aida_info_encodings() {
	int			result = TCL_OK;
	Tcl_Obj *	objv;

	objv = Tcl_NewStringObj("aida::getEncodings", -1);
	result = Tcl_EvalObjv(gInterp, 1, &objv, TCL_EVAL_GLOBAL);
	
	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_extensions" --
// 
// Implement 'aida info extensions ?target?'.
// 
// ------------------------------------------------------------------------
int aida_info_extensions(char * inTarget) {
	int			i, objc = 1, result = TCL_OK;
	Tcl_Obj *	objv[2];

	objv[0] = Tcl_NewStringObj("aida::getExtensions", -1);
	if (inTarget != NULL) {
		objv[1] = Tcl_NewStringObj(inTarget, -1);
		objc++;
	} 
	for (i = 0; i < objc; i++) Tcl_IncrRefCount(objv[i]);
	result = Tcl_EvalObjv(gInterp, objc, objv, TCL_EVAL_GLOBAL);
	for (i = 0; i < objc; i++) Tcl_DecrRefCount(objv[i]);	

	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_license" --
// 
// Implement 'aida info license'.
// 
// ------------------------------------------------------------------------
int aida_info_license() {
	int			result = TCL_OK;
	Tcl_Obj *	objv;

	objv = Tcl_NewStringObj("aida::printLicenseInfo", -1);
	
	result = Tcl_EvalObjv(gInterp, 1, &objv, TCL_EVAL_GLOBAL);
	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_mapping" --
// 
// Implement 'aida info mapping ?target?'.
// 
// ------------------------------------------------------------------------
int aida_info_mapping(char * inTarget) {
	int			i, objc = 1, result = TCL_OK;
	Tcl_Obj *	objv[2];

	objv[0] = Tcl_NewStringObj("aida::getMappingValues", -1);
	if (inTarget != NULL) {
		objv[1] = Tcl_NewStringObj(inTarget, -1);
		objc++;
	} 
	for (i = 0; i < objc; i++) Tcl_IncrRefCount(objv[i]);
	result = Tcl_EvalObjv(gInterp, objc, objv, TCL_EVAL_GLOBAL);
	for (i = 0; i < objc; i++) Tcl_DecrRefCount(objv[i]);	

	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_parameters" --
// 
// Implement 'aida info parameters ?target?'.
// 
// ------------------------------------------------------------------------
int aida_info_parameters(char * inTarget) {
	int			i, objc = 1, result = TCL_OK;
	Tcl_Obj *	objv[2];

	objv[0] = Tcl_NewStringObj("aida::getHeaderValues", -1);
	if (inTarget != NULL) {
		objv[1] = Tcl_NewStringObj(inTarget, -1);
		objc++;
	} 
	for (i = 0; i < objc; i++) Tcl_IncrRefCount(objv[i]);
	result = Tcl_EvalObjv(gInterp, objc, objv, TCL_EVAL_GLOBAL);
	for (i = 0; i < objc; i++) Tcl_DecrRefCount(objv[i]);	

	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_path" --
// 
// Implement 'aida info path'.
// 
// ------------------------------------------------------------------------
int aida_info_path() {
	int			result;
	
	result = Tcl_EvalEx(gInterp, "set aida_path", -1, TCL_EVAL_GLOBAL);
	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_sysenc" --
// 
// Implement 'aida info sysenc'.
// 
// ------------------------------------------------------------------------
int aida_info_sysenc() {
	int			result;
	
	result = Tcl_EvalEx(gInterp, "encoding system", -1, TCL_EVAL_GLOBAL);
	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_info_targets" --
// 
// Implement 'aida info targets'.
// 
// ------------------------------------------------------------------------
int aida_info_targets() {
	int			result = TCL_OK;
	Tcl_Obj *	objv;

	objv = Tcl_NewStringObj("aida::getTargets", -1);
	result = Tcl_EvalObjv(gInterp, 1, &objv, TCL_EVAL_GLOBAL);
	aida_result_to_console(result);
	
	return result;	
}


// ------------------------------------------------------------------------
// 
// "aida_split_usage" --
// 
// Implement 'aida help split'.
// 
// ------------------------------------------------------------------------
int aida_split_usage() {
    aida_print_out("Syntax:\n");
	aida_print_out("\t%s split [options] <file>\n", gPrgName);
    aida_print_out("Options:\n");
	aida_print_out("\t-collapse max number of eols (default 2)\n");
	aida_print_out("\t-eval     evaluate a Tcl command\n");
	aida_print_out("\t-from     input encoding\n");
	aida_print_out("\t-level    sections level for splitting (0 for input tags)\n");
	aida_print_out("\t-output   output format string\n");
	aida_print_out("\t-prefix   prefix file\n");
	aida_print_out("\t-target   target format\n");
	aida_print_out("\t-to       output encoding\n");
	aida_global_options_usage();
	
	return TCL_OK;	
}


// ------------------------------------------------------------------------
// 
// "aida_global_options_usage" --
// 
// Print info about global options.
// 
// ------------------------------------------------------------------------
void aida_global_options_usage() {
    aida_print_out("Global options:\n");
    aida_print_out("\t-L dir    set library directory\n");
    aida_print_out("\t-d num    set verbosity to num (default 1)\n");
    aida_print_out("\t-q        set verbosity to 0\n");
#ifdef AIDA_TRACING_OPTIONS				
    aida_print_out("\t-tl       trace the lexer\n");
    aida_print_out("\t-tp       trace the parser\n");
#endif				
    aida_print_out("\t-x        don't unlink temp files\n");
	aida_print_out("\t--        end of options\n");
}

