// ===========================================================================
// File: "aidaTclCommands.c"
//                        Created: 2010-08-09 21:56:18
//              Last modification: 2010-09-23 13:23:01
// Author: Bernard Desgraupes
// e-mail: <bdesgraupes@users.sourceforge.net>
// (c) Copyright: Bernard Desgraupes 2010
// All rights reserved.
// ===========================================================================

#include "aidaMain.h"
#include "aidaConstants.h"



// ------------------------------------------------------------------------
// 
// "aidaTcl_getDepth" --
// 
// Implement the [aida::getDepth] Tcl command.
// 
// ------------------------------------------------------------------------
int aidaTcl_getDepth(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const*objv)
{
	int			result = TCL_OK;
	char *		listType;
	
	if (objc != 1 && objc != 2) {
		Tcl_WrongNumArgs(interp, 1, objv, "?type?");
		return TCL_ERROR;
	}
	
	if (objc == 1) {
		Tcl_SetObjResult(gInterp, Tcl_NewIntObj(gListDepth));
	} else {
		listType = Tcl_GetString(objv[1]);
		if (!strcmp(listType,"dl")) {
			Tcl_SetObjResult(gInterp, Tcl_NewIntObj(gDLDepth));
		} else if (!strcmp(listType,"ol")) {
			Tcl_SetObjResult(gInterp, Tcl_NewIntObj(gOLDepth));
		} else if (!strcmp(listType,"ul")) {
			Tcl_SetObjResult(gInterp, Tcl_NewIntObj(gULDepth));
		} else {
			aida_print_err("unknown list type '%s'\n", listType);
			result = TCL_ERROR;
		} 
	} 
	
	return result;
}


// ------------------------------------------------------------------------
// 
// "aidaTcl_getDirname" --
// 
// Implement the [aida::getDirname] Tcl command.
// 
// ------------------------------------------------------------------------
int aidaTcl_getDirname(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const*objv)
{
	int			result = TCL_OK;
	Tcl_Obj 	*baseObj = NULL;
	
	if (objc != 1) {
		Tcl_WrongNumArgs(interp, 1, objv, "");
		return TCL_ERROR;
	}
	
	if (gCurrInclude != NULL) {
		baseObj = gCurrInclude->base;
	} else {
		baseObj = Tcl_FSGetCwd(gInterp);
	} 
	Tcl_SetObjResult(gInterp, baseObj);
	
	return result;
}


// ------------------------------------------------------------------------
// 
// "aidaTcl_splitting" --
// 
// Implement the [aida::splitting] Tcl command.
// 
// ------------------------------------------------------------------------
int aidaTcl_splitting(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const*objv)
{
	Tcl_SetObjResult(gInterp, Tcl_NewBooleanObj(gSplitting));
	return TCL_OK;
}


// ------------------------------------------------------------------------
// 
// "aidaTcl_encoding" --
// 
// Implement the [aida::inputEncoding] and [aida::outputEncoding] Tcl
// commands.
// 
// ------------------------------------------------------------------------
int aidaTcl_encoding(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const*objv)
{
	int		result = TCL_OK;
	bool	isInput = (bool)clientData;
					   
	if (objc != 1 && objc != 2) {
		Tcl_WrongNumArgs(interp, 1, objv, "?enc?");
		return TCL_ERROR;
	}
	
	if (objc == 1) {
		if (isInput) {
			if (gEncodings->tenc != NULL) {
				Tcl_SetObjResult(gInterp, Tcl_NewStringObj(Tcl_GetEncodingName(gEncodings->tenc),-1));
			} else {
				Tcl_SetObjResult(gInterp, Tcl_NewStringObj(Tcl_GetEncodingName(gEncodings->ienc),-1));
			} 
		} else {
			Tcl_SetObjResult(gInterp, Tcl_NewStringObj(Tcl_GetEncodingName(gEncodings->oenc),-1));
		} 
	} else {
		if (gParsing) {
			aida_print_err("can't change encodings during parsing\n");
			result = TCL_ERROR;
		} else {
			result = aida_encoding_name(Tcl_GetString(objv[1]), isInput);
			if (result == TCL_OK) {
				result = aida_set_encoding(Tcl_GetString(objv[1]), isInput);
			} 
		} 
	} 
	
	return result;
}


