// ===========================================================================
// File: "aidaConstants.h"
//                        Created: 2010-08-13 10:08:02
//              Last modification: 2013-06-21 10:57:04
// Author: Bernard Desgraupes
// e-mail: <bdesgraupes@users.sourceforge.net>
// (c) Copyright: Bernard Desgraupes 2010-2013
// All rights reserved.
// ===========================================================================

#ifndef AIDA_CONSTANTS_H
#define AIDA_CONSTANTS_H


// Extern variables
// ----------------
extern struct Tcl_Interp *	gInterp;
extern char					gInChars[32];
extern int					gInLen;

extern char *				gPrgName;
extern char *				gInName;
extern char *				gOutName;
extern char *				gPrefixFile;
extern char *				gSplitFrmt;
extern char *				gTarget;

extern FILE *				gInputFile;
extern FILE *				gCurrOutput;

extern bool					gDontUnlink;
extern bool					gSplitting;
extern bool					gParsing;
extern bool					gPrescan;
extern bool					gTraceLexer;
extern int					gUnwrapText;
extern int					gMapChars;
extern int					gVerbosity;
extern int					gListDepth;
extern int					gOLDepth;
extern int					gULDepth;
extern int					gDLDepth;
extern int					gSplitLevel;
extern int					gSplitNum;
extern int					gFragmentNum;
extern int					gScanNum;
extern int					gCollapse;

extern bool					gIfConds[AIDA_IFCONDS_MAX];
extern int					gIfDepth;
extern int					gIfLevel;

extern aida_enc_t *			gEncodings;
extern aida_frag_t *		gFragmentHead;
extern aida_frag_t *		gFragmentCurr;
extern aida_incl_t *		gCurrInclude;

extern Tcl_Obj *			gMap[256];


// Command and option arrays
extern const char * 		gAidaSubcommands[];
extern const char * 		gAidaInfos[];
extern const char * 		gAidaGlobalOptions[];
extern const char * 		gAidaConvertOptions[];
extern const char * 		gAidaSplitOptions[];
extern const char * 		gAidaHelpKeywords[];


// The following are defined in aidaLib.c
extern char *				gLibDir;
extern const char *			gVersionStr;
extern const char *			gYearStr;
extern const char *			gDateStr;


#endif  // AIDA_CONSTANTS_H
