// ===========================================================================
// File: "aidaConstants.c"
//                        Created: 2010-08-13 10:07:54
//              Last modification: 2014-06-24 15:50:44
// Author: Bernard Desgraupes
// e-mail: <bdesgraupes@users.sourceforge.net>
// Copyright (c) 2010-2014 Bernard Desgraupes
// All rights reserved.
// ===========================================================================

#include "aidaMain.h"

struct Tcl_Interp * 	gInterp			= NULL;
char					gInChars[32];
int						gInLen = 0;


char *					gPrgName		= NULL;
char *					gInName			= NULL;
char *					gOutName		= NULL;
char *					gPrefixFile		= NULL;
char *					gSplitFrmt		= NULL;
char *					gTarget			= NULL;

FILE *					gInputFile		= NULL;
FILE *					gCurrOutput		= NULL;

bool					gDontUnlink		= false;
bool					gSplitting		= false;
bool					gParsing		= false;
bool					gPrescan		= false;
bool					gTraceLexer		= false;
int						gUnwrapText		= 0;
int						gMapChars		= 1;
int						gVerbosity		= 1;
int						gListDepth		= 0;
int						gOLDepth		= 0;
int						gULDepth		= 0;
int						gDLDepth		= 0;
int						gSplitLevel		= 1;
int						gSplitNum		= 0;
int						gFragmentNum	= 0;
int						gScanNum		= 0;
int						gCollapse		= 2;

bool					gIfConds[AIDA_IFCONDS_MAX];
int						gIfDepth		= 0;
int						gIfLevel		= 0;

aida_enc_t *			gEncodings		= NULL;
aida_frag_t *			gFragmentHead	= NULL;
aida_frag_t *			gFragmentCurr	= NULL;
aida_incl_t *			gCurrInclude	= NULL;

Tcl_Obj *				gMap[256];


// Command and option arrays
const char * gAidaSubcommands[] = {
	"convert",	"help",	"info",	"split",
	(char *) NULL
};

const char * gAidaInfos[] = {
	"attributes",	"configuration",	"encodings",	"extensions",
	"from",      	"library",      	"license",  	"mapping",   	
	"parameters",	"path",         	"sysenc",   	"targets",   	
	"temp",      	"to",           	"version",  	(char *) NULL
};

const char * gAidaGlobalOptions[] = {
	"-d",	"-L",	"-q",	"-tl",	"-tp",	"-x",
	(char *) NULL
};

const char * gAidaConvertOptions[] = {
	"-collapse",	"-eval",  	"-from",	"-output",
	"-prefix",  	"-target",	"-to",  	"--",     
	(char *) NULL
};

const char * gAidaSplitOptions[] = {
	"-collapse",	"-eval",     	"-from",  	"-level",
	"-output",  	"-prefix",   	"-target",	"-to",   
	"--",       	(char *) NULL
};

const char * gAidaHelpKeywords[] = {
		"header",	"syntax", (char *) NULL 
};


// The following are defined in aidaLib.c
char *					gLibDir	= NULL;

