#
# spec file for package aida
# 
# Last modification: 2013-12-10 12:38:58
# 
# (c) Copyright: Bernard Desgraupes 2010-2013
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Aida Project Home Page: http://sourceforge.net/projects/aidadoc
# Please send bug reports to http://sourceforge.net/p/aidadoc/tickets/


Name:      aida
Summary:   Aida Markup Language and Compiler
Version:   1.3
Release:   1
Source:    %{name}-%{version}-src.tar.bz2
License:   BSD
Packager:  <bdesgraupes@users.sourceforge.net>
Group:     Development/Tools/Doc Generators
BuildRoot: %{_tmppath}/%{name}-%{version}-build
URL:		http://aidadoc.sourceforge.net/
BuildRequires: bison flex tcl-devel
# tcl >= 8.5
%if 0%{?mandriva_version} || 0%{?mdkversion}
%define man_ext lzma
%else
%define man_ext gz
%endif

%description
The AidaDoc project defines a simple common markup language designed to
write structured text, and provides a compiler which translates the Aida
syntax into various target formats (Html, Latex, Trac, Mediawiki, Text,
Markdown,...).

The system is fast, flexible and extensible. The core command %{name} is a
strict parser (written using Bison and Flex) which analyses files written
in the Aida markup language and invokes callbacks in order to convert them
to the target format. It embeds a Tcl language interpreter and the
callbacks are written in Tcl. This makes it very easy to extend the library
and to define new target formats.

For the most up-to-date information and sources please
visit the Aida project's web-site at http://%{name}doc.sourceforge.net/.

 
%prep
# ---
%setup -q -n %{name}-%{version}


%build
# ----
autoheader --force
autoconf --force

CFLAGS="%optflags" CXXFLAGS="%{optflags}" ./configure --prefix=%{_prefix} --mandir=%{_mandir} --bindir=%{_bindir}
make


%install
# ------
make DESTDIR=${RPM_BUILD_ROOT} install

# %if 0%{?mandriva_version}
# gzip $RPM_BUILD_ROOT%{_mandir}/man1/aida.1 
# gzip $RPM_BUILD_ROOT%{_mandir}/man1/aidamarkup.1 
# %endif


%clean
# ----
[ ${RPM_BUILD_ROOT} != "/" ] && rm -rf ${RPM_BUILD_ROOT}


%files
# ----
%defattr(-,root,root)

%docdir %{_mandir}/man1

%doc %{_mandir}/man1/aida.1.%{man_ext}
%doc %{_mandir}/man1/aidamarkup.1.%{man_ext}

%{_bindir}/aida%{version}
%{_bindir}/aida
%{_datadir}/aida/%{version}/*

%changelog
# --------
* Tue Jun 13 2011 - bdesgraupes (at) users.sourceforge.net
- Initial implementation

