# ===========================================================================
# File: "aidaMenu.tcl"
#                        Created: 2010-09-25 12:05:28
#              Last modification: 2010-12-08 16:09:39
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# www: <http://www.purl.org/net/alpha>
# Description: this file is part of the Aida Mode package for Alpha.
# 
# (c) Copyright: Bernard Desgraupes, 2010
#         All rights reserved.
# This software is free software. 
# See licensing terms in the Aida Help file.
# ===========================================================================


namespace eval Aida {}

# This is to load aidaMode.tcl first
aidaMode.tcl

proc aidaMenus.tcl {} {}


# Aida Menu declaration
# =====================


proc Aida::buildMenu {} {
	global aidaMenu
	variable menuToken
	
	# Build the main menu
	if {![info exists menuToken(main)]} {
		set main [menuRef create -title $aidaMenu -name $aidaMenu -command Aida::menuProc]
		set menuToken(main) $main
	} else {
		menuRef clear $menuToken(main)
		set main $menuToken(main)
	}
	
	# Populate the main menu
	menu::addItemWithBinding $main "Convert" Aida {z 'a' "" 'c'} {Aida::buildConvertDialog}
	
	# Build the Flags menu
	if {![info exists menuToken(Flags)]} {
		set menuToken(Flags) [menuRef create -title Flags -command Aida::FlagsMenuProc \
		  -updateProc Aida::updateFlagsMenu]
	} else {
		menuRef clear $menuToken(Flags)
	}
	menuItem append $main Flags -submenu $menuToken(Flags)	
	menuItem append $main "-"
	
	# Build the editing menus
	Aida::buildSubMenus
	
	menuItem append $main "-"
	menuItem append $main "New Template"
	menuItem append $main "Insert Header"
	menu::addItemWithBinding $main "Display Palettes" Aida {z 'a' "" 'p'} {Aida::displayPalettes}
	menuItem append $main "-"
	menuItem append $main "Quick Reference" -command Aida::quickReference
	set menuList [list  "Aida Help" "Display Bindings" "Menu Shortcuts" ]
	foreach item $menuList {
		menuItem append $main $item
	} 
}


proc Aida::buildSubMenus {} {
	global aidaMenu aida_params
	variable menuToken
	
	set token $menuToken(main)
	set subMenus [list "aidaSections" "aidaStructures" "aidaStyles" "aidaLinks"]
	
	foreach sub $subMenus {
		set name [quote::Menuify $sub]
		if {![info exists menuToken($sub)]} {
			set menuToken($sub) [menuRef create -title $name -command Aida::EditingMenuProc]
		} else {
			menuRef clear $menuToken($sub)
		} 
		menuItem append $token $name -submenu $menuToken($sub)
	} 
	
	# Aida Sections
	set subtoken $menuToken(aidaSections)
	for {set i 1} {$i <= 6} {incr i} {
		menu::addItemWithBinding $subtoken "Section $i" Aida [list z 'a' "" '$i'] [list Aida::tagSection $i]
	}
	menuItem append $subtoken "-"
	menu::addItemWithBinding $subtoken "New Line" Aida {z 'a' "" 'n'} {Aida::tagStartOfLine newLine}
	menu::addItemWithBinding $subtoken "Horizontal Rule" Aida {z 'a' "" 'h'} {Aida::tagStartOfLine horizontalRule}
	
	# Aida Structures
	set subtoken $menuToken(aidaStructures)
	menu::addItemWithBinding $subtoken "Ordered List" Aida {z 'a' "" 'o'} {Aida::buildList ol "((li " " li))"}
	menu::addItemWithBinding $subtoken "Unordered List" Aida {z 'a' "" 'l'} {Aida::buildList ul "((li " " li))"}
	menu::addItemWithBinding $subtoken "Description List" Aida {z 'a' "" 'd'} {Aida::buildList dl "((lt " "\nlt))"}
	menuItem append $subtoken "-"
	menu::addItemWithBinding $subtoken "Make Table" Aida {z 'a' "" 't'} {Aida::makeTable}
	menu::addItemWithBinding $subtoken "Make Framed Table" Aida {z 'a' "" 'f'} {Aida::makeTable 1}
	menuItem append $subtoken "-"
	menu::addItemWithBinding $subtoken "Eval Block" Aida {z 'a' "" 'e'} {Aida::tagEnclosing e}
	menuItem append $subtoken "If Block"
	menuItem append $subtoken "If Else Block"
	
	# Aida Styles
	set subtoken $menuToken(aidaStyles)	
	set idx [menu::addItemWithBinding $subtoken "Bold" Aida {z 'a' "" 'b'} {Aida::tagEnclosing b}]
	menuItem set $subtoken $idx -style 1
	set idx [menu::addItemWithBinding $subtoken "Italic" Aida {z 'a' "" 'i'} {Aida::tagEnclosing i}]
	menuItem set $subtoken $idx -style 2
	set idx [menu::addItemWithBinding $subtoken "Underline" Aida {z 'a' "" 'u'} {Aida::tagEnclosing u}]
	menuItem set $subtoken $idx -style 4
	menu::addItemWithBinding $subtoken "Typewriter" Aida {z 'a' "" 'y'} {Aida::tagEnclosing y}
	menuItem append $subtoken "-"
	menu::addItemWithBinding $subtoken "Quote" Aida {z 'a' "" 'q'} {Aida::tagEnclosing q}
	menu::addItemWithBinding $subtoken "Verb" Aida {z 'a' "" 'v'} {Aida::tagEnclosing v}
	menu::addItemWithBinding $subtoken "Verbatimize" Aida {z 'a' "" 'w'} {Aida::verbatimize}
	menu::addItemWithBinding $subtoken "Unverbatimize" Aida {z 'a' "" 'z'} {Aida::unverbatimize}
	menuItem append $subtoken "-"
	menu::addItemWithBinding $subtoken "Strong Comment" Aida {z 'a' "" 's'} {Aida::strongComment "insert"}
	menu::addItemWithBinding $subtoken "Strong Uncomment" Aida {z 'a' "" 'm'} {Aida::strongComment "remove"}
	
	# Aida Links
	set subtoken $menuToken(aidaLinks)	
	menu::addItemWithBinding $subtoken "Anchor" Aida {z 'a' "" 'a'} {Aida::tagEnclosing a}
	menu::addItemWithBinding $subtoken "Reference" Aida {z 'a' "" 'r'} {Aida::makeLink rf}
	menu::addItemWithBinding $subtoken "HyperLink" Aida {z 'a' "" 'k'} {Aida::makeLink lk}
	menuItem append $subtoken "-"
	menu::addItemWithBinding $subtoken "Index Entry" Aida {z 'a' "" 'x'} {Aida::tagEnclosing x}
}


proc Aida::updateFlagsMenu {token} {
	global AidamodeVars 
	
	menuRef clear $token
	
	set flags [list "autoMark" "preserveInputStruct" \
	  "reopenSourceAfterConversion" "revertOriginalOnError" \
	  "saveInSameFolder" "wordWrap" ]
	
	foreach f $flags {
		if {[info exists AidamodeVars($f)] && $AidamodeVars($f) } {
			menuItem append $token [quote::Menuify $f] -mark "" -style 2
		} else {
			menuItem append $token [quote::Menuify $f] 
		}
	} 
}


proc Aida::menuProc {token itemName} {
	set itemName [menu::canonifyItem $itemName]
	
	switch -glob -- $itemName {
		"menuShortcuts" {Aida::doMenuShortcuts set}
		default {eval Aida::${itemName}}
	}
}


proc Aida::FlagsMenuProc {token itemName} {
	global AidamodeVars 
	set itemName [menu::canonifyItem $itemName]
	if {[info exists AidamodeVars($itemName)]} {
		set AidamodeVars($itemName) [expr {1 - $AidamodeVars($itemName)}]
	}
}


proc Aida::EditingMenuProc {token itemName} {
	
	set itemName [menu::canonifyItem $itemName]
	switch -glob -- $itemName {
		"Section *" {
			if {[regexp {Section (\d)} $itemName -> num]} {
				Aida::tagSection $num
			} 
		}
		"ifBlock" - "ifElseBlock" {
			Aida::environment $itemName
		}
		default {
			eval Aida::$itemName
		}
	}
}


proc Aida::registerOWH {{which "register"}} {
	# Only register these if we've actually loaded the mode and menu at least
	# once. The menuToken variable must be defined.
	variable menuToken
	set dimmitemslist [list "Flags" "Convert" "New Template" ]
	foreach item $dimmitemslist {
		hook::$which dimThreshold [list $menuToken(main) $item] 1 
	}
}


# Menu Shortcuts
# ==============

## 
 # --------------------------------------------------------------------------
 # 
 # "Aida::doMenuShortcuts" --
 # 
 # This proc provides the menu shortcuts support.
 # 
 # --------------------------------------------------------------------------
 ##

proc Aida::doMenuShortcuts {action} {
	variable menuToken
	
	foreach m [array names menuToken] {
		set "tmpArray([quote::Menuify $m] Menu)" $menuToken($m)
	} 
	menu::handleUserShortcuts $action "aidaMenu" tmpArray Aida
}




# Building Aida menu now
# ----------------------
Aida::buildMenu

Aida::registerOWH

# Install user defined shortcuts
Aida::doMenuShortcuts install

