// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt
package hep.aida;


/**
 * A factory for creating ITuples.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 */
 
public interface ITupleFactory {

    /**
     * Creates an NTuple
     * @param path        The path of the created ITuple. The path can either be a relative or full path.
     *                    ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                    All the directories in the path must exist. The characther `/` cannot be used
     *                    in names; it is only used to delimit directories within paths.
     * @param title       The title of the n-tuple
     * @param columnNames The names of the columns
     * @param columnType  The types of  the columns
     * @throws            IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ITuple create(String path, String title, String[] columnNames, Class[] columnType) throws IllegalArgumentException;
    /**
     * Creates an NTuple
     * @param path        The path of the created ITuple. The path can either be a relative or full path.
     *                    ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                    All the directories in the path must exist. The characther `/` cannot be used
     *                    in names; it is only used to delimit directories within paths.
     * @param title       The title of the n-tuple
     * @param columnNames The names of the columns
     * @param columnType  The types of  the columns
     * @param options     NTuple options (currently undefined)
     * @throws            IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ITuple create(String path, String title, String[] columnNames, Class[] columnType, String options) throws IllegalArgumentException;

    /**
     * Creates an NTuple
     * @param path    The path of the created ITuple. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the n-tuple
     * @param columns The names and types of the columns e.g. "float px, py, pz, float energy, int charge"
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ITuple create(String path, String title, String columns) throws IllegalArgumentException;
    /**
     * Creates an NTuple
     * @param path    The path of the created ITuple. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the n-tuple
     * @param columns The names and types of the columns e.g. "float px, py, pz, float energy, int charge"
     * @param options NTuple options (currently undefined)
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ITuple create(String path, String title, String columns, String options) throws IllegalArgumentException;

    /**
     * Creates a logical chain of ITuples. All ITuples in the set must
     * have the same structure. Chained ITuple can not be filled.
     * Original n-tuple data is not copied.
     * @param path  The path of the chained ITuple. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param title The title of the new n-tuple
     * @param set   The array of ITuples to chain
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ITuple createChained(String path, String title, ITuple[] set) throws IllegalArgumentException;

    /**
     * Creates a logical chain of ITuples. All ITuples in the set must
     * have the same structure. Chained ITuple can not be filled.
     * Original n-tuple data is not copied.
     * @param path  The path of the chained ITuple. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param title The title of the new n-tuple
     * @param set   The array of the names of the ITuples to chain
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ITuple createChained(String path, String title, String[] set) throws IllegalArgumentException;

    /**
     * Creates a new reduced tuple (less rows) from an existing one
     * by applying a filter. Data is explicitly copied to a new n-tuple.
     * @param path   The path of the filtered ITuple. The path can either be a relative or full path.
     *               ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *               All the directories in the path must exist. The characther `/` cannot be used
     *               in names; it is only used to delimit directories within paths.
     * @param tuple  Original n-tuple
     * @param filter IFilter to be used
     * @throws       IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ITuple createFiltered(String path, ITuple tuple, IFilter filter) throws IllegalArgumentException;

    /**
     * Creates a new reduced tuple (less rows) from an existing one
     * by applying a filter. Only subset of the variables (columns) is copied.
     * Data is explicitly copied to a new n-tuple.
     * @param path    The path of the filtered ITuple. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param tuple   Original n-tuple
     * @param filter  IFilter to be used
     * @param columns Names of columns to for a new n-tuple
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ITuple createFiltered(String path, ITuple tuple, IFilter filter, String[] columns) throws IllegalArgumentException;

    /**
     * Creates IFilter object given a string defining of the "cut" expression.
     * @param expression String defining of the "cut" expression.
     *
     */
    public IFilter createFilter(String expression);

    /**
     * Creates a filter object given a string defining the "cut" expression.
     * Filter processes only subset of data.
     * @param expression String defining of the "cut" expression.
     * @param rowsToProcess How many rows to process
     *
     */
    public IFilter createFilter(String expression, int rowsToProcess);
    /**
     * Creates a filter object given a string defining the "cut" expression.
     * Filter processes only subset of data.
     * @param expression String defining of the "cut" expression.
     * @param rowsToProcess How many rows to process
     * @param startingRow Row number where to start
     *
     */
    public IFilter createFilter(String expression, int rowsToProcess, int startingRow);

    /**
     * Create IEvaluator object given its expression.
     * @param expression String defining of the evaluator expression.
     *
     */
    public IEvaluator createEvaluator(String expression);
} // class or interface

