// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface to a plotter region.
 * A region is managed by a plotter.
 * A region must be seen as a scene manager handling
 * a custome "plotting" scene. In general this kind of scene
 * may be in 2D or 3D. In 2D, the scene have "coarse graining parts" 
 * like two axis, data representations within the axis. It may have 
 * various other parts like a grid, a title, an info area. In 3D, 
 * the scene have in general three axis,
 * a different global layout, some data representations within the
 * axis area and also scene parts like title, grid, etc...
 * 
 *  To customize all these, some "style" interfaces had been introduced.
 * In general there is one style interface per "scene part" ; then
 * IAxisStyle, IDataStyle, ITitleStyle, IInfoStyle. Oftenly
 * a "scene part" contains text, line, fill area, etc.... For example
 * an "axis" have a line, ticks, text for tick labels, text for 
 * the label of the axis, the magnitude, etc... A "coarse graining scene part"
 * style contains various accessor to "atomic" styles like IMarkerStyle, 
 * ILineStyle, IFillStyle that permits to build a "customization block"
 * to modify a scene part.
 * 
 *  A global style "block", the IPlotterStyle, could be retreived
 * from a plotting region. This global style block have accessors
 * to the various "coarse graining scene parts" of the plotting scene.
 * Through it, we hope to offer a lot of customization in a convenient 
 * way...
 *
 *  The keywords "scene" and "part" had been borrowed from the
 * OpenInventor terminology.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

public interface IPlotterRegion {

  /**
   * Add a data analysis object (histogram, function, cloud,...)
   * in the list of things to plot in the region.
   * Activate the underlying graphic toolkit in order to bring
   * something in the screen window(s) attached to the plotter.
   * It assumes that the plotter had been mapped on the
   * screen with its show method.
   */
    public void plot(IBaseHistogram histogram) throws IllegalArgumentException;
  /**
   * Add a data analysis object (histogram, function, cloud,...)
   * in the list of things to plot in the region.
   * Activate the underlying graphic toolkit in order to bring
   * something in the screen window(s) attached to the plotter.
   * It assumes that the plotter had been mapped on the
   * screen with its show method.
   */
    public void plot(IBaseHistogram histogram, String options) throws IllegalArgumentException;

    public void plot(IBaseHistogram histogram, IPlotterStyle style) throws IllegalArgumentException;
    public void plot(IBaseHistogram histogram, IPlotterStyle style, String options) throws IllegalArgumentException;

    public void plot(IFunction function) throws IllegalArgumentException;
    public void plot(IFunction function, String options) throws IllegalArgumentException;

    public void plot(IFunction function, IPlotterStyle style) throws IllegalArgumentException;
    public void plot(IFunction function, IPlotterStyle style, String options) throws IllegalArgumentException;

    public void plot(IDataPointSet dataPointSet) throws IllegalArgumentException;
    public void plot(IDataPointSet dataPointSet, String options) throws IllegalArgumentException;

    public void plot(IDataPointSet dataPointSet, IPlotterStyle style) throws IllegalArgumentException;
    public void plot(IDataPointSet dataPointSet, IPlotterStyle style, String options) throws IllegalArgumentException;

  /**
   *  Remove a data analysis object in the list of things to plot in the region.
   *  Activate the graphic layer to update the screen window.
   */
    public void remove(IBaseHistogram histogram) throws IllegalArgumentException;

    public void remove(IFunction function) throws IllegalArgumentException;

    public void remove(IDataPointSet dataPointSet) throws IllegalArgumentException;

  /**
   * Clear the list of things to plot in the region.
   * Clear the corresponding area on screen window(s).
   */
    public void clear();

  /**
   * Set various plotting paramters for the region.
   * Activate the graphic layer and update the screen window(s)
   * if needed.
   */
    public void setParameter(String parameter) throws IllegalArgumentException;
  /**
   * Set various plotting paramters for the region.
   * Activate the graphic layer and update the screen window(s)
   * if needed.
   */
    public void setParameter(String parameter, String options) throws IllegalArgumentException;

  /**
   * Get value of a parameter. 
   * @param paramName Name of the parameter.
   * @return the value.
   */
    public String parameterValue(String parameter);

    public String[] availableParameterOptions(String parameter);

    public String[] availableParameters();

  /**
   * Get the style of the region.
   */
    public IPlotterStyle style();

  /**
   * Set the style of a region.
   */
    public void setStyle(IPlotterStyle style) throws IllegalArgumentException;

  /**
   * Set the style of a region and apply it to scene objects.
   */
    public void applyStyle(IPlotterStyle style) throws IllegalArgumentException;

  /**
   * Set the title of a region.
   */
    public void setTitle(String title);

  /**
   * Set limit of an axis representation the region area.
   */
    public void setXLimits() throws IllegalArgumentException;
  /**
   * Set limit of an axis representation the region area.
   */
    public void setXLimits(double min) throws IllegalArgumentException;
  /**
   * Set limit of an axis representation the region area.
   */
    public void setXLimits(double min, double max) throws IllegalArgumentException;

    public void setYLimits() throws IllegalArgumentException;
    public void setYLimits(double min) throws IllegalArgumentException;
    public void setYLimits(double min, double max) throws IllegalArgumentException;

    public void setZLimits() throws IllegalArgumentException;
    public void setZLimits(double min) throws IllegalArgumentException;
    public void setZLimits(double min, double max) throws IllegalArgumentException;

  /**
   * To customize axis position,etc...
   * Change object position in the scence.
   */
    public IPlotterLayout layout();

    public void setLayout(IPlotterLayout layout) throws IllegalArgumentException;

  /**
   * Return an IInfo object describing the info area.
   */
    public IInfo info();
} // class or interface

