// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;

import java.io.IOException;

/**
 *  User level interface to plotter.
 *
 * This IPlotter interface assumes the handling of
 * multiple plotting regions. Then the IPlotter should
 * be seen as a "page" managing multiple drawing region.
 * It assumes that a "current" region mechanism is used.
 * 
 *  The keyword "region" is borrowed from the OpenInventor
 * terminology (viewing region).
 *
 *  See also the IPlotterRegion for more comments.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface IPlotter {

  /**
   * Region management methods.
   */

  /**
   * Create a new region.
   *                   that is to say between 0 and 1.
   *                   Then a region with (x=0,y=0,w=1,h=1) maps
   *                   the full page. "x" goes left to right. "y" bottom
   *                   to top.
   * @return The newly created region. Return null in case not failure.
   *         Note that the plotter manages the regions ; user does not
   *         have to delete a region object directly.
   */
    public IPlotterRegion createRegion();
  /**
   * Region management methods.
   */

  /**
   * Create a new region.
   * @param x, y, w, h Position and size in normal coordinates
   *                   that is to say between 0 and 1.
   *                   Then a region with (x=0,y=0,w=1,h=1) maps
   *                   the full page. "x" goes left to right. "y" bottom
   *                   to top.
   * @return The newly created region. Return null in case not failure.
   *         Note that the plotter manages the regions ; user does not
   *         have to delete a region object directly.
   */
    public IPlotterRegion createRegion(double x);
  /**
   * Region management methods.
   */

  /**
   * Create a new region.
   * @param x, y, w, h Position and size in normal coordinates
   *                   that is to say between 0 and 1.
   *                   Then a region with (x=0,y=0,w=1,h=1) maps
   *                   the full page. "x" goes left to right. "y" bottom
   *                   to top.
   * @return The newly created region. Return null in case not failure.
   *         Note that the plotter manages the regions ; user does not
   *         have to delete a region object directly.
   */
    public IPlotterRegion createRegion(double x, double y);
  /**
   * Region management methods.
   */

  /**
   * Create a new region.
   * @param x, y, w, h Position and size in normal coordinates
   *                   that is to say between 0 and 1.
   *                   Then a region with (x=0,y=0,w=1,h=1) maps
   *                   the full page. "x" goes left to right. "y" bottom
   *                   to top.
   * @return The newly created region. Return null in case not failure.
   *         Note that the plotter manages the regions ; user does not
   *         have to delete a region object directly.
   */
    public IPlotterRegion createRegion(double x, double y, double w);
  /**
   * Region management methods.
   */

  /**
   * Create a new region.
   * @param x, y, w, h Position and size in normal coordinates
   *                   that is to say between 0 and 1.
   *                   Then a region with (x=0,y=0,w=1,h=1) maps
   *                   the full page. "x" goes left to right. "y" bottom
   *                   to top.
   * @return The newly created region. Return null in case not failure.
   *         Note that the plotter manages the regions ; user does not
   *         have to delete a region object directly.
   */
    public IPlotterRegion createRegion(double x, double y, double w, double h);

  /**
   * Create a grid of regions.
   * By default the current region is the top left one (with index 0).
   * Region are indexed from zero, with increasing order
   * left to right, top to bottom.
   */
    public void createRegions() throws IllegalArgumentException;
  /**
   * Create a grid of regions.
   * By default the current region is the top left one (with index 0).
   * Region are indexed from zero, with increasing order
   * left to right, top to bottom.
   * @param index Set the current region.
   */
    public void createRegions(int columns) throws IllegalArgumentException;
  /**
   * Create a grid of regions.
   * By default the current region is the top left one (with index 0).
   * Region are indexed from zero, with increasing order
   * left to right, top to bottom.
   * @param index Set the current region.
   */
    public void createRegions(int columns, int rows) throws IllegalArgumentException;
  /**
   * Create a grid of regions.
   * By default the current region is the top left one (with index 0).
   * Region are indexed from zero, with increasing order
   * left to right, top to bottom.
   * @param index Set the current region.
   */
    public void createRegions(int columns, int rows, int index) throws IllegalArgumentException;

  /**
   * @return The current region.
   */
    public IPlotterRegion currentRegion();

  /**
   * @return The current region index.
   */
    public int currentRegionNumber();

  /**
   * @return The number of regions.
   */
    public int numberOfRegions();

  /**
   * Set current region by giving its index [0,n-1]
   */
    public void setCurrentRegionNumber(int index) throws IllegalArgumentException;

  /**
   * Set current region to be the "next" one.
   * If exceeding the number of regions,
   * the current region index return to 0.
   * @return The new current region.
   */
    public IPlotterRegion next();

  /**
   * @return A region, knowing its index.
   */
    public IPlotterRegion region(int index);

  /**
   *  Destroy regions.
   */
    public void destroyRegions();

  /**
   * Clear all regions. It does not reset the number
   * and position of regions. This can be done through
   * a destroyRegions.
   */
    public void clearRegions();

  /*
   * Set various plotting paramters for the whole page.
   * Activate the graphic layer and update the screen window(s)
   * if needed.
   */
    public void setParameter(String parameter) throws IllegalArgumentException;
  /*
   * Set various plotting paramters for the whole page.
   * Activate the graphic layer and update the screen window(s)
   * if needed.
   */
    public void setParameter(String parameter, String options) throws IllegalArgumentException;

  /**
   * Get value of a parameter. 
   * @param paramName Name of the parameter.
   * @return the value.
   */
    public String parameterValue(String parameter);

    public String[] availableParameterOptions(String parameter);

    public String[] availableParameters();

  /*
   * GUI related methods :
   */

  /**
   * Map the plotter on the screen.
   */
    public void show() throws RuntimeException;

  /**
   * Refresh the screen window(s).
   * Used when a plotted data analysis object
   * received new data.
   */
    public void refresh() throws RuntimeException;

  /**
   * Unmap the plotter on the screen.
   */
    public void hide() throws RuntimeException;

  /**
   * Give control to the plotter GUI. The plotter must be able
   * to return from this function from a user action in its GUI.
   */
    public void interact() throws RuntimeException;

  /*
   * Other methods.
   */

  /**
   * Produce an output file.
   * @param type  A string to describe the type of the output :
   *  "PS"  or "PostScript" for PostScript, "JPEG" for JPEG.
   *  If nothing is given, the type is guessed
   *  from the given file name suffix (.ps for PostScript,
   *  .jpg for JPEG, etc...).
   */
    public void writeToFile(String filename) throws IOException;
  /*
   * Other methods.
   */

  /**
   * Produce an output file.
   * @param type  A string to describe the type of the output :
   *  "PS"  or "PostScript" for PostScript, "JPEG" for JPEG.
   *  If nothing is given, the type is guessed
   *  from the given file name suffix (.ps for PostScript,
   *  .jpg for JPEG, etc...).
   */
    public void writeToFile(String filename, String type) throws IOException;

  /**
   * Set the global title of the plotter (page).
   */
    public void setTitle(String title);

  /**
   * Get/set title style.
   */
    public ITitleStyle titleStyle();

    public void setTitleStyle(ITitleStyle style);
} // class or interface

