// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 *
 * Function factory.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 * @stereotype abstractfactory
 */
 
public interface IFunctionFactory {

    /**
     * Create function from a model registered in the catalog.
     * This is the easiest way to create simple model functions for fitting.
     * Every AIDA compliant implementation should predefine "G", "E", "Pn"
     * (n is an integer, e.e "P0","P5"). Simple operations are permitted,
     * e.g. "G+P2".
     * @param path  The path of the IFunction. The path can either be a relative or full path.
     *              ("/folder1/folder2/functionName" and "../folder/functionName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param model The model of the function to be created.
     * @return      The newly created function.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IFunction createFunctionByName(String path, String model) throws IllegalArgumentException;

    /**
     * Create function from script. Script conventions:
     *         createFunctionFromScript("f1", 2, "a*x[0]*x[0] + b*x[1]", "a,b","this is my function", "x[0]*x[0],x[1]")
     * @param path        The path of the IFunction. The path can either be a relative or full path.
     *                    ("/folder1/folder2/functionName" and "../folder/functionName" are valid paths).
     *                    All the directories in the path must exist. The characther `/` cannot be used
     *                    in names; it is only used to delimit directories within paths.
     * @param dim         The dimension of the function, i.e. the number of variables.
     * @param valexpr     The expression of the scripted function.
     * @param parameters  A comma separeted list of what has to be considered as a parameter in the valexpr expression.
     * @param description The description of the function.
     * @return            The newly created function
     * @throws            IllegalArgumentException if a directory in the path does not exist, or the path is illegal, or if any of the
     *                    provided expressions is illigal.
     *
     */
    public IFunction createFunctionFromScript(String name, int dim, String valexpr, String parameters, String description) throws IllegalArgumentException;
    /**
     * Create function from script. Script conventions:
     *         createFunctionFromScript("f1", 2, "a*x[0]*x[0] + b*x[1]", "a,b","this is my function", "x[0]*x[0],x[1]")
     * @param path        The path of the IFunction. The path can either be a relative or full path.
     *                    ("/folder1/folder2/functionName" and "../folder/functionName" are valid paths).
     *                    All the directories in the path must exist. The characther `/` cannot be used
     *                    in names; it is only used to delimit directories within paths.
     * @param dim         The dimension of the function, i.e. the number of variables.
     * @param valexpr     The expression of the scripted function.
     * @param parameters  A comma separeted list of what has to be considered as a parameter in the valexpr expression.
     * @param description The description of the function.
     * @param gradexpr    A comma separated list of the expressions for the derivatives of the function with respect to the parameters.
     * @return            The newly created function
     * @throws            IllegalArgumentException if a directory in the path does not exist, or the path is illegal, or if any of the
     *                    provided expressions is illigal.
     *
     */
    public IFunction createFunctionFromScript(String name, int dim, String valexpr, String parameters, String description, String gradexpr) throws IllegalArgumentException;

    /**
     * Create a clone of an existing function.
     * @param path The path of the IFunction. The path can either be a relative or full path.
     *             ("/folder1/folder2/functionName" and "../folder/functionName" are valid paths).
     *             All the directories in the path must exist. The characther `/` cannot be used
     *             in names; it is only used to delimit directories within paths.
     * @param f    The IFunction to be cloned.
     * @return     The clone of the provided IFunction.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IFunction cloneFunction(String path, IFunction f) throws IllegalArgumentException;

    /**
     * get access to the function catalog
     */
    public IFunctionCatalog catalog();

    /** @link association 
     * @directed*/
    /*# IFunctionCatalog lnkIFunctionCatalog; */
} // class or interface

