// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 *
 * Represents the result of the fit.
 *
 * Holds internal copies of fit parameter settings (set in IFitter) and the
 * fitted function (clone of original function). The value of the parameters
 * of the fitted function are obtained from the fitting.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface IFitResult {

    /// True if fit successful, otherwise false.
    public boolean isValid();

    /// Status of the fit. PENDING: what are the suggested values?
    public int fitStatus();

    /// Fitted function. The parameters hold the results of the fit.
    public IFunction fittedFunction();

    /// Quality of the fit. Depending on the fit method this may be the value
    /// of Chi2 or Maximu Likelihood.
    public double quality();

    /// Number of degrees of freedom.
    public int ndf();

    /// Covariance matrix. PENDING: interface for matrix to be defined.
    public double covMatrixElement(int i, int j);

    /// Fit method name as set in the fitter.
    public String fitMethodName();

    /// Engine used to do fitting.
    public String engineName();

    /// Textual description of data - this is a hint for the user how to find
    /// the data in the tree if he wanted to repeat the fit later and lost
    /// the pointer to his orignal data object.
    /// PENDING: the contents and format of this string to be defined.
    /// PENDING: XML? stor name and path? ranges of DataPipe?
    public String dataDescription();

    /// Vector of constraints.
    public String[] constraints();

    /// Access to applied parameter settings.
    public IFitParameterSettings fitParameterSettings(String name);

    /**
     * Get the array of the fitted parameter values (including fixed and constrained ones).
     * @return The array containing the fitted values.
     *
     */
    public double[] fittedParameters();

    /**
     * Get the names of the fitted parameters (including fixed and constrained ones).
     * @return The array containing the names of the fitted parameters.
     *
     */
    public String[] fittedParameterNames();

    /**
     * Get the value of a fitted parameter by name.
     * @return The value.
     *
     */
    public double fittedParameter(String name);

    /**
     * Get the parabolic errors on the fitted parameters. If a parameter was fixed
     * or constrained the error is zero.
     * @return The parabolic errors on the fitted parameters.
     *
     */
    public double[] errors();

    /**
     * Get the positive part of the asymmetric errors on the fitted parameters. If a parameter was fixed
     * or constrained the error is zero.
     * @return The positive part of the asymmetric errors on the fitted parameters.
     *
     */
    public double[] errorsPlus();

    /**
     * Get the negative part of the asymmetric errors on the fitted parameters. If a parameter was fixed
     * or constrained the error is zero.
     * @return The negative part of the asymmetric errors on the fitted parameters.
     *
     */
    public double[] errorsMinus();

    /** @link aggregation 
     * @supplierRole <<internal copy>>*/
    /*#  IFitParameterSettings lnkIFitParameterProperty; */
} // class or interface

