// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 *
 * Fitting-specific settings applied to a parameter of the fitted function.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

public interface IFitParameterSettings {

  /// Name of the parameter to which settings apply.
    public String name();

  /// Step size allows to control the "sensitivity" of the change of the parameter
  /// when fitters looks for the optimal parameter value. Default is 1.0.
    public double stepSize();

  /// Bounds.
    public double upperBound();

    public double lowerBound();

  /// Shortcut for lowerBound() == -INF && upperBound() == +INF.
    public boolean isBound();

  /// Value of the parameter cannot change if isFixed() == true.
  /// Parameter can be fixed independently from setting the bounds.
    public boolean isFixed();

  /// Set the step size for the fitter.
    public void setStepSize(double step);

  /// Set bounds. If bounds not set, then default bound is (-INF,+INF).
    public void setBounds(double lo, double up);

  /// Shortcut for setBounds(-INF,+INF).
    public void removeBounds();

  /// Fix/unfix parameter.
    public void setFixed(boolean isFixed);

  /**
   * Set the lower bound. When this method is
   * invoked any previous bound is reset. The new bounds
   * are (lowerBound, +INF).
   * @param lowerBound The lower bound.
   *
   */
    public void setLowerBound(double lowerBound);

  /**
   * Set the upper bound. When this method is
   * invoked any previous bound is reset. The new bounds
   * are (-INF, upperBound).
   * @param upperBound The upper bound.
   *
   */
    public void setUpperBound(double upperBound);

  /// Reset all settings to the default values (remove bounds, step size = 1.0, no fix).
    public void reset();
} // class or interface

