// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * Basic user-level interface for creating a factory
 * of IDataPointSet.
 * 
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

public interface IDataPointSetFactory {

    /**
     * Create an empty IDataPointSet.
     * @param path        The path of the IDataPointSet. The path can either be a relative or full path.
     *                    ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                    All the directories in the path must exist. The characther `/` cannot be used
     *                    in names; it is only used to delimit directories within paths.
     * @param title       The title of the IDataPointSet.
     * @param dimOfPoints The dimension of the IDataPoints that can be stored in the set.
     * @return            The newly created IDataPointSet.
     * @throws            IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, String title, int dimOfPoints) throws IllegalArgumentException;

    /**
     * Create an empty IDataPointSet.
     * @param pathAndTitle The path of the IDataPointSet. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param dimOfPoints  The dimension of the IDataPoints that can be stored in the set.
     * @return             The newly created IDataPointSet.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String pathAndTitle, int dimOfPoints) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data along y (the x value is 
     * the index of the y value in the array).
     * @param path  The path of the IDataPointSet. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param title The title of the IDataPointSet.
     * @param y     The array of the y values
     * @param ey    The array with the symmetric errors on y
     * @return      The created IDataPointSet.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createY(String path, String title, double[] y, double[] ey) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data along y (the x value is 
     * the index of the y value in the array).
     * @param path  The path of the IDataPointSet. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param title The title of the IDataPointSet.
     * @param y     The array of the y values
     * @param eyp   The array with the plus errors on y
     * @param eym   The array with the minus errors on y
     * @return      The created IDataPointSet.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createY(String path, String title, double[] y, double[] eyp, double[] eym) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data along y (the x value is 
     * the index of the y value in the array).
     * @param pathAndTitle The path of the IDataPointSet. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param y            The array of the y values
     * @param ey           The array with the symmetric errors on y
     * @return             The created IDataPointSet.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createY(String pathAndTitle, double[] y, double[] ey) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data along y (the x value is 
     * the index of the y value in the array).
     * @param pathAndTitle The path of the IDataPointSet. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param y            The array of the y values
     * @param eyp          The array with the plus errors on y
     * @param eym          The array with the minus errors on y
     * @return             The created IDataPointSet.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createY(String pathAndTitle, double[] y, double[] eyp, double[] eym) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data along x (the y value is 
     * the index of the x value in the array).
     * @param path  The path of the IDataPointSet. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param title The title of the IDataPointSet.
     * @param x     The array of the x values
     * @param ex    The array with the symmetric errors on x
     * @return      The created IDataPointSet.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createX(String path, String title, double[] x, double[] ex) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data along x (the y value is 
     * the index of the x value in the array).
     * @param path  The path of the IDataPointSet. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param title The title of the IDataPointSet.
     * @param x     The array of the x values
     * @param exp   The array with the plus errors on x
     * @param exm   The array with the minus errors on x
     * @return      The created IDataPointSet.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createX(String path, String title, double[] x, double[] exp, double[] exm) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data along x (the y value is 
     * the index of the x value in the array).
     * @param pathAndTitle The path of the IDataPointSet. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param x            The array of the x values
     * @param ex           The array with the symmetric errors on x
     * @return             The created IDataPointSet.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createX(String pathAndTitle, double[] x, double[] ex) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data along x (the y value is 
     * the index of the x value in the array).
     * @param pathAndTitle The path of the IDataPointSet. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param x            The array of the x values
     * @param exp          The array with the plus errors on x
     * @param exm          The array with the minus errors on x
     * @return             The created IDataPointSet.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createX(String pathAndTitle, double[] x, double[] exp, double[] exm) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data.
     * @param path  The path of the IDataPointSet. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param title The title of the IDataPointSet.
     * @param x     The array of the x values
     * @param y     The array of the y values
     * @param exp   The array with the plus errors on x
     * @param eyp   The array with the plus errors on y
     * @param exm   The array with the minus errors on x
     * @param eym   The array with the minus errors on y
     * @return      The created IDataPointSet.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createXY(String path, String title, double[] x, double[] y, double[] exp, double[] eyp, double[] exm, double[] eym) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data.
     * @param path  The path of the IDataPointSet. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param title The title of the IDataPointSet.
     * @param x     The array of the x values
     * @param y     The array of the y values
     * @param ex    The array with the symmetric errors on x
     * @param ey    The array with the symmetric errors on y
     * @return      The created IDataPointSet.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createXY(String path, String title, double[] x, double[] y, double[] ex, double[] ey) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data.
     * @param pathAndTitle The path of the IDataPointSet. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param x            The array of the x values
     * @param y            The array of the y values
     * @param exp          The array with the plus errors on x
     * @param eyp          The array with the plus errors on y
     * @param exm          The array with the minus errors on x
     * @param eym          The array with the minus errors on y
     * @return             The created IDataPointSet.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createXY(String pathAndTitle, double[] x, double[] y, double[] exp, double[] eyp, double[] exm, double[] eym) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data.
     * @param pathAndTitle The path of the IDataPointSet. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param x            The array of the x values
     * @param y            The array of the y values
     * @param ex           The array with the symmetric errors on x
     * @param ey           The array with the symmetric errors on y
     * @return             The created IDataPointSet.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createXY(String pathAndTitle, double[] x, double[] y, double[] ex, double[] ey) throws IllegalArgumentException;

    /**
     * Create a three dimensional IDataPointSet providing the data.
     * @param path  The path of the IDataPointSet. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param title The title of the IDataPointSet.
     * @param x     The array of the x values
     * @param y     The array of the y values
     * @param z     The array of the z values
     * @param exp   The array with the plus errors on x
     * @param eyp   The array with the plus errors on y
     * @param ezp   The array with the plus errors on z
     * @param exm   The array with the minus errors on x
     * @param eym   The array with the minus errors on y
     * @param ezm   The array with the minus errors on z
     * @return      The created IDataPointSet.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createXYZ(String path, String title, double[] x, double[] y, double[] z, double[] exp, double[] eyp, double[] ezp, double[] exm, double[] eym, double[] ezm) throws IllegalArgumentException;

    /**
     * Create a three dimensional IDataPointSet providing the data.
     * @param path  The path of the IDataPointSet. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param title The title of the IDataPointSet.
     * @param x     The array of the x values
     * @param y     The array of the y values
     * @param z     The array of the z values
     * @param ex    The array with the symmetric errors on x
     * @param ey    The array with the symmetric errors on y
     * @param ez    The array with the symmetric errors on z
     * @return      The created IDataPointSet.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createXYZ(String path, String title, double[] x, double[] y, double[] z, double[] ex, double[] ey, double[] ez) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data.
     * @param pathAndTitle The path of the IDataPointSet. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param x            The array of the x values
     * @param y            The array of the y values
     * @param z            The array of the z values
     * @param exp          The array with the plus errors on x
     * @param eyp          The array with the plus errors on y
     * @param ezp          The array with the plus errors on z
     * @param exm          The array with the minus errors on x
     * @param eym          The array with the minus errors on y
     * @param ezm          The array with the minus errors on z
     * @return             The created IDataPointSet.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createXYZ(String pathAndTitle, double[] x, double[] y, double[] z, double[] exp, double[] eyp, double[] ezp, double[] exm, double[] eym, double[] ezm) throws IllegalArgumentException;

    /**
     * Create a two dimensional IDataPointSet providing the data.
     * @param pathAndTitle The path of the IDataPointSet. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param x            The array of the x values
     * @param y            The array of the y values
     * @param z            The array of the z values
     * @param exp          The array with the symmetric errors on x
     * @param eyp          The array with the symmetric errors on y
     * @param ezp          The array with the symmetric errors on z
     * @return             The created IDataPointSet.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createXYZ(String pathAndTitle, double[] x, double[] y, double[] z, double[] ex, double[] ey, double[] ez) throws IllegalArgumentException;

    /**
     * Make a copy of a given IDataPointSet.
     * @param path         The path of the IDataPointSet. The path can either be a relative or full path.
     *                     ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param dataPointSet The IDataPointSet to be copied.
     * @return             The copy of the given IDataPointSet.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet createCopy(String path, IDataPointSet dataPointSet) throws IllegalArgumentException;

    /**
     * Destroy a given IDataPointSet.
     * @param dataPointSet  The IDataPointSet to be destroyed.
     * @throws              IllegalArgumentException If dataPointSet cannot be destroyed.
     *
     */
    public void destroy(IDataPointSet dataPointSet) throws IllegalArgumentException;

    /**
     * Create an IDataPointSet from an IHistogram1D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param hist    The IHistogram1D from which the data is taken.
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, IHistogram1D hist) throws IllegalArgumentException;
    /**
     * Create an IDataPointSet from an IHistogram1D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param hist    The IHistogram1D from which the data is taken.
     * @param options Options, currently not specified
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, IHistogram1D hist, String options) throws IllegalArgumentException;

    /**
     * Create an IDataPointSet from an IHistogram2D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param hist    The IHistogram2D from which the data is taken.
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, IHistogram2D hist) throws IllegalArgumentException;
    /**
     * Create an IDataPointSet from an IHistogram2D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param hist    The IHistogram2D from which the data is taken.
     * @param options Options, currently not specified
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, IHistogram2D hist, String options) throws IllegalArgumentException;

    /**
     * Create an IDataPointSet from an IHistogram3D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param hist    The IHistogram3D from which the data is taken.
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, IHistogram3D hist) throws IllegalArgumentException;
    /**
     * Create an IDataPointSet from an IHistogram3D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param hist    The IHistogram3D from which the data is taken.
     * @param options Options, currently not specified
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, IHistogram3D hist, String options) throws IllegalArgumentException;

    /**
     * Create an IDataPointSet from an ICloud1D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param cloud   The ICloud1D from which the data is taken.
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, ICloud1D cloud) throws IllegalArgumentException;
    /**
     * Create an IDataPointSet from an ICloud1D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param cloud   The ICloud1D from which the data is taken.
     * @param options Options, currently not specified
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, ICloud1D cloud, String options) throws IllegalArgumentException;

    /**
     * Create an IDataPointSet from an ICloud2D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param cloud   The ICloud2D from which the data is taken.
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, ICloud2D cloud) throws IllegalArgumentException;
    /**
     * Create an IDataPointSet from an ICloud2D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param cloud   The ICloud2D from which the data is taken.
     * @param options Options, currently not specified
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, ICloud2D cloud, String options) throws IllegalArgumentException;

    /**
     * Create an IDataPointSet from an ICloud3D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param cloud   The ICloud3D from which the data is taken.
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, ICloud3D cloud) throws IllegalArgumentException;
    /**
     * Create an IDataPointSet from an ICloud3D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param cloud   The ICloud3D from which the data is taken.
     * @param options Options, currently not specified
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, ICloud3D cloud, String options) throws IllegalArgumentException;

    /**
     * Create an IDataPointSet from an IProfile1D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param profile The IProfile1D from which the data is taken.
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, IProfile1D profile) throws IllegalArgumentException;
    /**
     * Create an IDataPointSet from an IProfile1D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param profile The IProfile1D from which the data is taken.
     * @param options Options, currently not specified
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, IProfile1D profile, String options) throws IllegalArgumentException;

    /**
     * Create an IDataPointSet from an IProfile2D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param profile The IProfile2D from which the data is taken.
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, IProfile2D profile) throws IllegalArgumentException;
    /**
     * Create an IDataPointSet from an IProfile2D.
     * @param path    The path of the IDataPointSet. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param profile The IProfile2D from which the data is taken.
     * @param options Options, currently not specified
     * @return        The newly created IDataPointSet.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet create(String path, IProfile2D profile, String options) throws IllegalArgumentException;

    /**
     * Add two IDataSetPoint, point by point and measurement by measurement.
     * @param path          The path of resulting the IDataPointSet. The path can either be a relative or full path.
     *                      ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                      All the directories in the path must exist. The characther `/` cannot be used
     *                      in names; it is only used to delimit directories within paths.
     * @param dataPointSet1 The first member of the addition.
     * @param dataPointSet2 The second member of the addition.
     * @throws              IllegalArgumentException if the two IDataPointSet to be added have different dimensions and/or sizes, or
     *                      if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet add(String path, IDataPointSet dataPointSet1, IDataPointSet dataPointSet2) throws IllegalArgumentException;

    /**
     * Subtract two IDataSetPoint, point by point and measurement by measurement.
     * @param path          The path of the resulting IDataPointSet. The path can either be a relative or full path.
     *                      ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                      All the directories in the path must exist. The characther `/` cannot be used
     *                      in names; it is only used to delimit directories within paths.
     * @param dataPointSet1 The first member of the subtraction.
     * @param dataPointSet2 The second member of the subtraction.
     *                      uncorrelated Gaussian error propagation.
     * @throws              IllegalArgumentException if the two IDataPointSet to be subtracted have different dimensions and/or sizes, or
     *                      if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet subtract(String path, IDataPointSet dataPointSet1, IDataPointSet dataPointSet2) throws IllegalArgumentException;

    /**
     * Multiply two IDataSetPoint, point by point and measurement by measurement.
     * @param path          The path of the resulting IDataPointSet. The path can either be a relative or full path.
     *                      ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                      All the directories in the path must exist. The characther `/` cannot be used
     *                      in names; it is only used to delimit directories within paths.
     * @param dataPointSet1 The first member of the multiplication.
     * @param dataPointSet2 The second member of the multiplication.
     *                      uncorrelated Gaussian error propagation.
     * @throws              IllegalArgumentException if the two IDataPointSet to be multiplied have different dimensions and/or sizes, or
     *                      if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet multiply(String path, IDataPointSet dataPointSet1, IDataPointSet dataPointSet2) throws IllegalArgumentException;

    /**
     * Divide two IDataSetPoint, point by point and measurement by measurement.
     * @param path          The path of resulting the IDataPointSet. The path can either be a relative or full path.
     *                      ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                      All the directories in the path must exist. The characther `/` cannot be used
     *                      in names; it is only used to delimit directories within paths.
     * @param dataPointSet1 The first member of the division.
     * @param dataPointSet2 The second member of the division.
     *                      uncorrelated Gaussian error propagation.
     * @throws              IllegalArgumentException if the two IDataPointSet to be divided have different dimensions and/or sizes, or
     *                      if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet divide(String path, IDataPointSet dataPointSet1, IDataPointSet dataPointSet2) throws IllegalArgumentException;

    /**
     * Calculate weighted means of two IDataSetPoint, point by point and measurement by measurement.
     * @param path          The path of the resulting IDataPointSet. The path can either be a relative or full path.
     *                      ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                      All the directories in the path must exist. The characther `/` cannot be used
     *                      in names; it is only used to delimit directories within paths.
     * @param dataPointSet1 The first IDataPointSet.
     * @param dataPointSet2 The second IDataPointSet.
     *                      uncorrelated Gaussian error propagation.
     * @throws              IllegalArgumentException if the two IDataPointSet have different dimensions and/or sizes, or
     *                      if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IDataPointSet weightedMean(String path, IDataPointSet dataPointSet1, IDataPointSet dataPointSet2) throws IllegalArgumentException;
} // class or interface

