// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface to a 1D Cloud.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface ICloud1D extends ICloud {

    /**
     * Fill the ICloud1D with a value and a corresponding weight.
     * @param x      The value.
     * @throws IllegalArgumentException If the ICloud1D is full, if the weight's value is
     *                                  is not between 0 and 1.
     *
     */
    public void fill(double x) throws IllegalArgumentException;
    /**
     * Fill the ICloud1D with a value and a corresponding weight.
     * @param x      The value.
     * @param weight The corresponding weight. By default it is 1.
     * @throws IllegalArgumentException If the ICloud1D is full, if the weight's value is
     *                                  is not between 0 and 1.
     *
     */
    public void fill(double x, double weight) throws IllegalArgumentException;

    /**
     * Get the lower edge of the ICloud1D.
     * @return The lower edge.
     *
     */
    public double lowerEdge();

    /**
     * Get the upper edge of the ICloud1D.
     * @return The upper edge.
     *
     */
    public double upperEdge();

    /**
     * Get the value corresponding to a given entry.
     * @param index The entry's index.
     * @return      The value of the index-th entry.
     * @throws      AlreadyConvertedException If the ICloud1D has already been converted.
     *
     */
      
    public double value(int index) throws AlreadyConvertedException;

    /**
     * Get the weight corresponding to a given entry.
     * @param index The entry's index.
     * @return      The weight of the index-th entry.
     * @throws      AlreadyConvertedException If the ICloud has already been converted.
     *
     */
      
    public double weight(int index) throws AlreadyConvertedException;

    /**
     * Get the mean of the ICloud1D.
     * @return The mean.
     *
     */
    public double mean();

    /**
     * Get the RMS of the ICloud1D.
     * @return The RMS.
     *
     */
    public double rms();

    /**
     * Convert internally the ICloud1D to an IHistogram1D
     * with given number of bins, upper edge and lower edge.
     * @param nBins     The number of bins.
     * @param lowerEdge The lower edge.
     * @param upperEdge The upper edge.
     * @throws AlreadyConvertedException If the ICloud1D has already been converted.
     *
     */
    public void convert(int nBins, double lowerEdge, double upperEdge) throws AlreadyConvertedException;

    /**
     * Convert internally the ICloud1D to an IHistogram1D
     * with given bin edges.
     * @param binEdges The bins edges.
     * @throws         AlreadyConvertedException If the ICloud1D has already been converted.
     *
     */
    public void convert(double[] binEdges) throws AlreadyConvertedException;

    /**
     * Get the internal IHistogram1D in which the ICloud1D converted to.
     * @return The histogram.
     * @throws RuntimeException If the ICloud1D did not convert either automatically
     *                          or because of a convert() method invocation.
     *
     */
    public IHistogram1D histogram() throws RuntimeException;

    /**
     * Project the ICloud1D on an IHistogram1D.
     * @param hist The IHistogram1D to be filled.
     * @throws RuntimeException If the ICloud1D is already converted.
     *
     */
    public void fillHistogram(IHistogram1D hist) throws RuntimeException;
} // class or interface

