// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;



import java.io.*;
/**
 * The "master" factory from which other factories are obtained.
 * Typically accessed by:
 * <pre>
 *   IAnalysisFactory af =(IAnalysisFactory) ServiceManager.create("hep.aida.IAnalysisFactory");
 * </pre>
 *
 * In C++ IAnalysisFactory* af = AIDA_createAnalysisFactory();
 *
 * @author The AIDA team (http://aida.freehep.org/)
 */

public abstract class IAnalysisFactory {



   /**
    * Create an instance of an IAnalysisFactory.
    * This method will  attempt to locate and load an IAnalysisFactory
    * at runtime. If one cannot be found an error message will be printed, and a RuntimeException thrown.
    * The method first checks the System property hep.aida.IAnalysisFactory. If this is not found
    * it uses the services API to find an IAnalysisFactory service in a jar file on the CLASSPATH.
    * @return The IAnalysisFactory
    * @throws RuntimeException If a concrete IAnalysisFactory implementation cannot be located
    */
   public static IAnalysisFactory create()
   {
      String msg = null;
      Throwable detail = null;
      try
      {
         String factory = findFactory("hep.aida.IAnalysisFactory");
         if(factory == null) msg = "No concrete IAnalysisFactory could be located";
         else
         {
            try
            {
               Class factoryClass = Class.forName(factory);
               return(IAnalysisFactory) factoryClass.newInstance();
            }
            catch(ClassCastException x)
            {
               detail = x;
               msg = "Class "+factory+" is not an IAnalysis Factory";
            }
            catch(ClassNotFoundException x)
            {
               detail = x;
               msg = "Class "+factory+" not found";
            }
            catch(IllegalAccessException x)
            {
               detail = x;
               msg = "Class "+factory+" does not have a zero-argument constructor";
            }
            catch(InstantiationException x)
            {
               detail = x;
               msg = "Error while instantiating "+factory;
            }
            catch(NoClassDefFoundError x) {
               detail = x;
               msg = "You may have an old version of aida or freehep in your JDK_HOME/jre/lib/ext directory";
            }
            catch(Throwable x) {
               detail = x;
               msg = "Unknown Error";
            }
         }
      }
      catch(IOException x)
      {
         detail = x;
         msg = "IOException while searching for IAnalysisFactory service";
      }

      System.err.println(detail);
      System.err.println("Error: Unable to create IAnalysisFactory");
      System.err.println("Error: "+msg);
      System.err.println("Error: Please check your CLASSPATH and see the AIDA Users Guide");
      System.err.println("===============================================================");
      RuntimeException x = new RuntimeException(msg);
      // if(detail != null) x.initCause(detail);  // JDK 1.4
      throw x;
   }
   private static String findFactory(String factoryName) throws IOException
   {
      // The only non abstract AIDA method. Code here is copied from org.freehep.util.Factory to
      // avoid introducing any dependencies.

      // try System Property
      String factory = null;
      try
      {
         factory = System.getProperty(factoryName);
         if(factory != null) return factory;
      }
      catch(SecurityException securityexception)
      {}

      // try Services API
      String service1 = "meta-inf/services/" + factoryName;
      String service2 = "META-INF/services/" + factoryName;

      ClassLoader loader = IAnalysisFactory.class.getClassLoader();
      InputStream stream = null;
      if(loader == null) stream = ClassLoader.getSystemResourceAsStream(service1);
      else                stream = loader.getResourceAsStream(service1);

      if(stream == null)
      {
         if(loader == null) stream = ClassLoader.getSystemResourceAsStream(service2);
         else                stream = loader.getResourceAsStream(service2);
      }

      if(stream != null)
      {
         BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
         factory = reader.readLine();
         reader.close();
         if(factory != null && !factory.equals("")) return factory;
      }
      return null;
   }
  /**
   * Create an ITreeFactory.
   * @return The ITreeFactory.
   *
   */
    public abstract ITreeFactory createTreeFactory();

  /**
   * Create an IHistogramFactory.
   * @param tree The ITree which created histograms will be associated to.
   * @throws     IllegalArgumentException if tree is null.
   * @return     The IHistogramFactory.
   *
   */
    public abstract IHistogramFactory createHistogramFactory(ITree tree) throws IllegalArgumentException;

  /**
   * Create an IDataPointSetFactory.
   * @param tree The ITree which created IDataPointSet will be associated to.
   * @throws     IllegalArgumentException if tree is null.
   * @return     The IDataPointSetFactory.
   *
   */
    public abstract IDataPointSetFactory createDataPointSetFactory(ITree tree) throws IllegalArgumentException;

  /**
   * Create an ITupleFactory.
   * @param tree The ITree which created tuples will be associated to.
   * @throws     IllegalArgumentException if tree is null.
   * @return     The ITupleFactory.
   *
   */
    public abstract ITupleFactory createTupleFactory(ITree tree) throws IllegalArgumentException;

  /**
   * Create an IFunctionFactory.
   * @param tree The ITree which created functions will be associated to.
   * @throws     IllegalArgumentException if tree is null.
   * @return     The IFunctionFactory.
   *
   */
    public abstract IFunctionFactory createFunctionFactory(ITree tree) throws IllegalArgumentException;

    /**
     * Create an IPlotterFactory.
     * Due to the fact that the plotter factory may activate a GUI
     * tookit, the process arguments (passed to the main function)
     * could be passed to the plotter factory. Most of the GUI
     * toolkit ask for them (Motif, gtk, Qt, FLTK).
     */
           
    public abstract IPlotterFactory createPlotterFactory();

  /**
   * Create an IFitFactory.
   * @return     The IFitFactory.
   *
   */
    public abstract IFitFactory createFitFactory();
} // class or interface

