// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IFITFACTORY_H
#define AIDA_IFITFACTORY_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <string>

namespace AIDA {

class IFitData;
class IFitter;

/** @interface IFitFactory
 *
 * Factory for fitter and fit data objects.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

class IFitFactory {

public: 
    /// Destructor.
    virtual ~IFitFactory() { /* nop */; }

    virtual IFitData * createFitData() = 0;

    /**
     * Create a new IFitter.
     * @param fitterType The type of fitter. The supported types are:
     *                    - "CHI2" or "Chi2" or "ChiSquared" for chi squared fitter (this is the default),
     *                    - "ML" or "MaxLikelihood" for maximum likelihood fitter,
     *                    - "LS" or "LeastSquares" for Last Squares fitter.
     * @param engineType The type of optimization engine used by the fitter. The available types depend on the
     *                   specific implementation in use. The default is "" (the implementation specific default).
     * @param options    A string of options. The default is "".
     * @return           The IFitter.
     *
     */
    virtual IFitter * createFitter(const std::string & fitterType = "Chi2", const std::string & engineType = "", const std::string & options = "") = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IFITFACTORY_H */
