// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IAXIS_H
#define AIDA_IAXIS_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

namespace AIDA {

/**
 * An IAxis represents a binned histogram axis. A 1D Histogram would have
 * one Axis representing the X axis, while a 2D Histogram would have two
 * axes representing the X and Y Axis.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

class IAxis {

public: 
    /// Destructor.
    virtual ~IAxis() { /* nop */; }

  /**
   * Check if the IAxis has fixed binning, i.e. if all the bins have the same width.
   * @return <code>true</code> if the binning is fixed, <code>false</code> otherwise.
   *
   */
    virtual bool isFixedBinning() const = 0;

  /**
   * Get the lower edge of the IAxis.
   * @return The IAxis's lower edge.
   *
   */
    virtual double lowerEdge() const = 0;

  /**
   * Get the upper edge of the IAxis.
   * @return The IAxis's upper edge.
   *
   */
    virtual double upperEdge() const = 0;

  /** 
   * The number of bins (excluding underflow and overflow) on the IAxis.
   * @return The IAxis's number of bins.
   *
   */
    virtual int bins() const = 0;

  /**
   * Get the lower edge of the specified bin.
   * @param index The bin number: 0 to bins()-1 for the in-range bins or OVERFLOW or UNDERFLOW.
   * @return      The lower edge of the corresponding bin; for the underflow bin this is <tt>Double.NEGATIVE_INFINITY</tt>.
   *
   */
    virtual double binLowerEdge(int index) const = 0;

  /**
   * Get the upper edge of the specified bin.
   * @param index The bin number: 0 to bins()-1 for the in-range bins or OVERFLOW or UNDERFLOW.
   * @return      The upper edge of the corresponding bin; for the overflow bin this is <tt>Double.POSITIVE_INFINITY</tt>.
   *
   */ 
    virtual double binUpperEdge(int index) const = 0;

  /**
   * Get the width of the specified bin.
   * @param index The bin number: 0 to bins()-1) for the in-range bins or OVERFLOW or UNDERFLOW.
   * @return      The width of the corresponding bin.
   *
   */ 
    virtual double binWidth(int index) const = 0;

  /**
   * Convert a coordinate on the axis to a bin number.
   * If the coordinate is less than the lowerEdge UNDERFLOW is returned; if the coordinate is greater or
   * equal to the upperEdge OVERFLOW is returned.
   * @param coord The coordinate to be converted.
   * @return      The corresponding bin number.
   *
   */
    virtual int coordToIndex(double coord) const = 0;

  /**
   * Constants specifying the underflow and the overflow bin.
   * They can be passed to any method accepting a bin number.
   *
   */
    enum { UNDERFLOW_BIN = -2, OVERFLOW_BIN = -1 };
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IAXIS_H */
