/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IEvaluator;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.test.AidaTestCase;
import java.io.File;
import junit.framework.Assert;

public class TestRoot
extends AidaTestCase {
    protected ITree tree;
    private double relPrecision;

    public TestRoot(String testName) {
        super(testName);
        this.setRelPrecision(1.0E-4);
    }

    protected void setRelPrecision(double relPrecision) {
        this.relPrecision = relPrecision;
    }

    protected void tearDown() throws Exception {
        this.tree.close();
        super.tearDown();
    }

    protected String convertName(int id) {
        return id >= 0 ? "/h" + id : "/h_" + id;
    }

    public void test1DHistogramAccess() {
        IHistogram1D hist = (IHistogram1D)this.tree.find(this.convertName(110));
        Assert.assertNotNull((Object)hist);
        Assert.assertEquals((String)hist.title().trim(), (String)"TEST OF HBOOK1");
        Assert.assertEquals((int)hist.entries(), (int)5000);
        Assert.assertEquals((int)hist.extraEntries(), (int)0);
        AidaTestCase.assertEqualsDouble(hist.mean(), 0.49817, this.relPrecision);
        AidaTestCase.assertEqualsDouble(hist.rms(), 0.22046, this.relPrecision);
    }

    public void test2DHistogramAccess() {
        IHistogram2D hist = (IHistogram2D)this.tree.find(this.convertName(210));
        Assert.assertNotNull((Object)hist);
        Assert.assertEquals((String)hist.title().trim(), (String)"TEST OF HBOOK2");
        Assert.assertEquals((int)hist.entries(), (int)5000);
        Assert.assertEquals((int)hist.extraEntries(), (int)0);
        AidaTestCase.assertEqualsDouble(hist.meanX(), 0.4806, this.relPrecision);
        AidaTestCase.assertEqualsDouble(hist.meanY(), 0.48094, this.relPrecision);
        AidaTestCase.assertEqualsDouble(hist.rmsX(), 0.21781, this.relPrecision);
        AidaTestCase.assertEqualsDouble(hist.rmsY(), 0.21768, this.relPrecision);
    }

    public void testSimpleFit() throws Exception {
        ITuple tuple = (ITuple)this.tree.find(this.convertName(30));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 50, -4.0, 4.0);
        IEvaluator x = tf.createEvaluator("X");
        tuple.project(hist, x);
        Assert.assertEquals((int)hist.entries(), (int)10000);
        IFitFactory ff = af.createFitFactory();
        IFitResult result = ff.createFitter().fit((IBaseHistogram)hist, "g");
        IFunction fitted = result.fittedFunction();
        AidaTestCase.assertEqualsDouble(result.quality(), 0.579, 0.01);
        Assert.assertEquals((int)result.ndf(), (int)43);
        Assert.assertTrue((boolean)result.isValid());
        Assert.assertEquals((double)fitted.parameter("mean"), (double)0.0, (double)0.01);
        AidaTestCase.assertEqualsDouble(fitted.parameter("sigma"), 1.0, 0.03);
        AidaTestCase.assertEqualsDouble(fitted.parameter("amplitude"), 643.0, 0.01);
        temp.close();
    }

    public void testFolderAccess() {
        IHistogram1D hist = (IHistogram1D)this.tree.find("BS" + this.convertName(100));
        Assert.assertNotNull((Object)hist);
        Assert.assertEquals((String)hist.title().trim(), (String)"BREM P M");
        Assert.assertEquals((int)hist.entries(), (int)15896);
        Assert.assertEquals((int)hist.extraEntries(), (int)0);
        AidaTestCase.assertEqualsDouble(hist.mean(), 0.28203, 1.0E-4);
        AidaTestCase.assertEqualsDouble(hist.rms(), 0.10821, 1.0E-4);
    }

    public void testTuple() {
        ITuple tuple = (ITuple)this.tree.find(this.convertName(30));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 40, 0.0, 10.0);
        IEvaluator x = tf.createEvaluator("Z");
        tuple.project(hist, x);
        Assert.assertEquals((int)9934, (int)hist.entries());
        AidaTestCase.assertEqualsDouble(1.9721, hist.mean(), 1.0E-4);
        AidaTestCase.assertEqualsDouble(1.9925, hist.rms(), 1.0E-4);
    }

    public void testTupleAge() {
        ITuple tuple = (ITuple)this.tree.find("STAFF" + this.convertName(10));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 44, 20.5, 64.5);
        IEvaluator x = tf.createEvaluator("Age");
        tuple.project(hist, x);
        Assert.assertEquals((int)3354, (int)hist.entries());
        AidaTestCase.assertEqualsDouble(47.153, hist.mean(), 1.0E-4);
        AidaTestCase.assertEqualsDouble(8.643, hist.rms(), 1.0E-4);
    }

    public void testTupleNation() {
        ITuple tuple = (ITuple)this.tree.find("STAFF" + this.convertName(10));
        int nationIndex = tuple.findColumn("Nation");
        int n = 0;
        tuple.start();
        while (tuple.next()) {
            String nation = tuple.getString(nationIndex);
            if (!nation.equals("CH")) continue;
            ++n;
        }
        Assert.assertEquals((int)465, (int)n);
    }

    public void testWalkTree() {
        String[] names = this.tree.listObjectNames("/", true);
        Assert.assertEquals((int)266, (int)names.length);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.openFile();
    }

    protected void openFile() throws Exception {
        String testDataDir = System.getProperty("hep.aida.test.data");
        File f = new File(testDataDir, "pawdemo.root");
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        this.tree = tf.create(f.getAbsolutePath(), "root", true, false, null);
    }
}

