/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.util.Random;

public class TestHistogramSlices
extends AidaTestCase {
    Random r = null;

    public TestHistogramSlices(String testName) {
        super(testName);
    }

    public void testTestSlices2D() {
        this.r = this.getRandomNumberGenerator();
        int xBins = this.r.nextInt(39) + 1;
        int yBins = this.r.nextInt(24) + 1;
        int nEntries = this.r.nextInt(3000);
        double xmin = -18.5;
        double xmax = 10.9;
        double ymin = 12.0;
        double ymax = 43.0;
        int indexX2 = this.r.nextInt(xBins);
        int indexX1 = this.r.nextInt(indexX2 + 1) - 2;
        int indexY2 = this.r.nextInt(yBins);
        int indexY1 = this.r.nextInt(indexY2 + 1) - 2;
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = analysisFactory.createTreeFactory().create();
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IHistogram1D h11 = histogramFactory.createHistogram1D("Projection X", xBins, xmin, xmax);
        IHistogram1D h12 = histogramFactory.createHistogram1D("Projection Y", yBins, ymin, ymax);
        IHistogram1D h13 = histogramFactory.createHistogram1D("Slice X", xBins, xmin, xmax);
        IHistogram1D h14 = histogramFactory.createHistogram1D("Slice Y", yBins, ymin, ymax);
        IHistogram2D h2D = histogramFactory.createHistogram2D("Hist2D 1", xBins, xmin, xmax, yBins, ymin, ymax);
        int i = 0;
        while (i < nEntries) {
            double xv = this.value(xmin, xmax);
            double yv = this.value(ymin, ymax);
            double wv = this.r.nextDouble();
            int nx = h2D.xAxis().coordToIndex(xv);
            int ny = h2D.yAxis().coordToIndex(yv);
            h2D.fill(xv, yv, wv);
            h11.fill(xv, wv);
            h12.fill(yv, wv);
            if (ny >= indexY1 && ny <= indexY2) {
                h13.fill(xv, wv);
            }
            if (nx >= indexX1 && nx <= indexX2) {
                h14.fill(yv, wv);
            }
            ++i;
        }
        IHistogram1D h21 = histogramFactory.projectionX("Projection X", h2D);
        IHistogram1D h22 = histogramFactory.projectionY("Projection Y", h2D);
        IHistogram1D h23 = histogramFactory.sliceX("Slice X", h2D, indexY1, indexY2);
        IHistogram1D h24 = histogramFactory.sliceY("Slice Y", h2D, indexX1, indexX2);
        AidaTestCase.assertEquals(h21, h11);
        AidaTestCase.assertEquals(h22, h12);
        AidaTestCase.assertEquals(h23, h13);
        AidaTestCase.assertEquals(h24, h14);
    }

    public void testTestSlices3D() {
        this.r = this.getRandomNumberGenerator();
        int xBins = this.r.nextInt(39) + 1;
        int yBins = this.r.nextInt(24) + 1;
        int zBins = this.r.nextInt(53) + 1;
        int nEntries = this.r.nextInt(3000);
        double xmin = -18.5;
        double xmax = 10.9;
        double ymin = 12.0;
        double ymax = 43.0;
        double zmin = -1.15;
        double zmax = -0.01;
        int indexX2 = this.r.nextInt(xBins);
        int indexX1 = this.r.nextInt(indexX2 + 1) - 2;
        int indexY2 = this.r.nextInt(yBins);
        int indexY1 = this.r.nextInt(indexY2 + 1) - 2;
        int indexZ2 = this.r.nextInt(zBins);
        int indexZ1 = this.r.nextInt(indexZ2 + 1) - 2;
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = analysisFactory.createTreeFactory().create();
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IHistogram2D h2D11 = histogramFactory.createHistogram2D("Projection XY", xBins, xmin, xmax, yBins, ymin, ymax);
        IHistogram2D h2D12 = histogramFactory.createHistogram2D("Projection YZ", yBins, ymin, ymax, zBins, zmin, zmax);
        IHistogram2D h2D13 = histogramFactory.createHistogram2D("Projection XZ", xBins, xmin, xmax, zBins, zmin, zmax);
        IHistogram2D h2D14 = histogramFactory.createHistogram2D("Slice XY", xBins, xmin, xmax, yBins, ymin, ymax);
        IHistogram2D h2D15 = histogramFactory.createHistogram2D("Slice YZ", yBins, ymin, ymax, zBins, zmin, zmax);
        IHistogram2D h2D16 = histogramFactory.createHistogram2D("Slice XZ", xBins, xmin, xmax, zBins, zmin, zmax);
        IHistogram3D h3D = histogramFactory.createHistogram3D("Hist3D 1", xBins, xmin, xmax, yBins, ymin, ymax, zBins, zmin, zmax);
        int i = 0;
        while (i < nEntries) {
            double xv = this.value(xmin, xmax);
            double yv = this.value(ymin, ymax);
            double zv = this.value(zmin, zmax);
            double wv = this.r.nextDouble();
            int nx = h3D.xAxis().coordToIndex(xv);
            int ny = h3D.yAxis().coordToIndex(yv);
            int nz = h3D.zAxis().coordToIndex(zv);
            h3D.fill(xv, yv, zv, wv);
            h2D11.fill(xv, yv, wv);
            h2D12.fill(yv, zv, wv);
            h2D13.fill(xv, zv, wv);
            if (nz >= indexZ1 && nz <= indexZ2) {
                h2D14.fill(xv, yv, wv);
            }
            if (nx >= indexX1 && nx <= indexX2) {
                h2D15.fill(yv, zv, wv);
            }
            if (ny >= indexY1 && ny <= indexY2) {
                h2D16.fill(xv, zv, wv);
            }
            ++i;
        }
        IHistogram2D h2D21 = histogramFactory.projectionXY("Projection XY", h3D);
        IHistogram2D h2D22 = histogramFactory.projectionYZ("Projection YZ", h3D);
        IHistogram2D h2D23 = histogramFactory.projectionXZ("Projection XZ", h3D);
        IHistogram2D h2D24 = histogramFactory.sliceXY("Slice XY", h3D, indexZ1, indexZ2);
        IHistogram2D h2D25 = histogramFactory.sliceYZ("Slice YZ", h3D, indexX1, indexX2);
        IHistogram2D h2D26 = histogramFactory.sliceXZ("Slice XZ", h3D, indexY1, indexY2);
        AidaTestCase.assertEquals(h2D11, h2D21);
        AidaTestCase.assertEquals(h2D12, h2D22);
        AidaTestCase.assertEquals(h2D13, h2D23);
        AidaTestCase.assertEquals(h2D14, h2D24);
        AidaTestCase.assertEquals(h2D15, h2D25);
        AidaTestCase.assertEquals(h2D16, h2D26);
    }

    private double value(double vmin, double vmax) {
        return this.r.nextGaussian() * (vmax - vmin) / 3.0 + (vmin + vmax) / 2.0;
    }
}

