/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IMeasurement;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;

public class TestDataPointSet
extends AidaTestCase {
    public TestDataPointSet(String testName) {
        super(testName);
    }

    public void testDataPointSetSaveRestore() throws IOException {
        Random r = this.getRandomNumberGenerator();
        String outputName = "testDataPointSet.aida";
        String options = "compress=no";
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree = tf.create(outputName, "", false, true, options);
        IDataPointSetFactory df = af.createDataPointSetFactory(tree);
        IDataPointSet ps = df.create("ps", "Test for DataPointSet", 5);
        int nPoints = 10;
        int i = 0;
        while (i < nPoints) {
            ps.addPoint();
            IDataPoint point = ps.point(i);
            int j = 0;
            while (j < point.dimension()) {
                IMeasurement m = point.coordinate(j);
                m.setValue(r.nextDouble());
                m.setErrorPlus(r.nextDouble());
                m.setErrorMinus(r.nextDouble());
                ++j;
            }
            ++i;
        }
        tree.commit();
        ITree newTree = tf.create(outputName, null, true, false);
        AidaTestCase.assertEquals(ps, (IDataPointSet)newTree.find("ps"));
        Assert.assertEquals((int)ps.size(), (int)nPoints);
    }
}

