function outstr = GE_dumpImageHeader(img)
%
% outstr = GE_dumpImageHeader(img)
%
% Writes the image header to the string outstr
%
% Souheil J. Inati
% Dartmouth College
% May 2000
% souheil.inati@dartmouth.edu
%

outstr = sprintf('im_suid: %s\n',         char(img.im_suid));
outstr  = strcat(outstr, sprintf('im_uniq: %d\n',         img.im_uniq));
outstr  = strcat(outstr, sprintf('im_diskid: %s\n',       char(img.im_diskid)));
outstr  = strcat(outstr, sprintf('im_exno: %d\n',         img.im_exno));
outstr  = strcat(outstr, sprintf('im_seno: %d\n',         img.im_seno));
outstr  = strcat(outstr, sprintf('im_no: %d\n',           img.im_no));
outstr  = strcat(outstr, sprintf('im_datetime: %d\n',     img.im_datetime));
outstr  = strcat(outstr, sprintf('im_actual_dt: %d\n',    img.im_actual_dt));
outstr  = strcat(outstr, sprintf('sctime: %f\n',          img.sctime));
outstr  = strcat(outstr, sprintf('slthick: %f\n',         img.slthick));
outstr  = strcat(outstr, sprintf('imatrix_X: %d\n',       img.imatrix_X));
outstr  = strcat(outstr, sprintf('imatrix_Y: %d\n',       img.imatrix_Y));
outstr  = strcat(outstr, sprintf('dfov: %f\n',            img.dfov));
outstr  = strcat(outstr, sprintf('dfov_rect: %f\n',       img.dfov_rect));
outstr  = strcat(outstr, sprintf('dim_X: %f\n',           img.dim_X));
outstr  = strcat(outstr, sprintf('dim_Y: %f\n',           img.dim_Y));
outstr  = strcat(outstr, sprintf('pixsize_X: %f\n',       img.pixsize_X));
outstr  = strcat(outstr, sprintf('pixsize_Y: %f\n',       img.pixsize_Y));
outstr  = strcat(outstr, sprintf('pdid: %s\n',            sprintf('%s',img.pdid)));
outstr  = strcat(outstr, sprintf('contrastIV: %s\n',      cstring(img.contrastIV)));
outstr  = strcat(outstr, sprintf('contrastOral: %s\n',    cstring(img.contrastOral)));
outstr  = strcat(outstr, sprintf('contmode: %d\n',        img.contmode));
outstr  = strcat(outstr, sprintf('serrx: %d\n',           img.serrx));
outstr  = strcat(outstr, sprintf('imgrx: %d\n',           img.imgrx));
outstr  = strcat(outstr, sprintf('screenformat: %d\n',    img.screenformat));
outstr  = strcat(outstr, sprintf('plane: %d\n',           img.plane));
outstr  = strcat(outstr, sprintf('scanspacing: %f\n',     img.scanspacing));
outstr  = strcat(outstr, sprintf('im_compress: %d\n',     img.im_compress));
outstr  = strcat(outstr, sprintf('im_scouttype: %d\n',    img.im_scouttype));
outstr  = strcat(outstr, sprintf('loc_ras: %s\n',         char(img.loc_ras)));
outstr  = strcat(outstr, sprintf('loc: %f\n',          img.loc));
outstr  = strcat(outstr, sprintf('ctr_R: %f\n',        img.ctr_R));
outstr  = strcat(outstr, sprintf('ctr_A: %f\n',        img.ctr_A));
outstr  = strcat(outstr, sprintf('ctr_S: %f\n',        img.ctr_S));
outstr  = strcat(outstr, sprintf('norm_R: %f\n',       img.norm_R));
outstr  = strcat(outstr, sprintf('norm_A: %f\n',       img.norm_A));
outstr  = strcat(outstr, sprintf('norm_S: %f\n',       img.norm_S));
outstr  = strcat(outstr, sprintf('tlhc_R: %f\n',       img.tlhc_R));
outstr  = strcat(outstr, sprintf('tlhc_A: %f\n',       img.tlhc_A));
outstr  = strcat(outstr, sprintf('tlhc_S: %f\n',       img.tlhc_S));
outstr  = strcat(outstr, sprintf('trhc_R: %f\n',       img.trhc_R));
outstr  = strcat(outstr, sprintf('trhc_A: %f\n',       img.trhc_A));
outstr  = strcat(outstr, sprintf('trhc_S: %f\n',       img.trhc_S));
outstr  = strcat(outstr, sprintf('brhc_R: %f\n',       img.brhc_R));
outstr  = strcat(outstr, sprintf('brhc_A: %f\n',       img.brhc_A));
outstr  = strcat(outstr, sprintf('brhc_S: %f\n',       img.brhc_S));
outstr  = strcat(outstr, sprintf('forimgrev: %s\n',    char(img.forimgrev)));
outstr  = strcat(outstr, sprintf('tr: %d\n',           img.tr));
outstr  = strcat(outstr, sprintf('ti: %d\n',           img.ti));
outstr  = strcat(outstr, sprintf('te: %d\n',           img.te));
outstr  = strcat(outstr, sprintf('te2: %d\n',          img.te2));
outstr  = strcat(outstr, sprintf('numecho: %d\n',      img.numecho));
outstr  = strcat(outstr, sprintf('echonum: %d\n',      img.echonum));
outstr  = strcat(outstr, sprintf('tbldlta: %f\n',      img.tbldlta));
outstr  = strcat(outstr, sprintf('nex: %f\n',          img.nex));
outstr  = strcat(outstr, sprintf('contig: %d\n',       img.contig));
outstr  = strcat(outstr, sprintf('hrtrate: %d\n',      img.hrtrate));
outstr  = strcat(outstr, sprintf('tdel: %d\n',         img.tdel));
outstr  = strcat(outstr, sprintf('saravg: %f\n',       img.saravg));
outstr  = strcat(outstr, sprintf('sarpeak: %f\n',      img.sarpeak));
outstr  = strcat(outstr, sprintf('monsar: %d\n',          img.monsar));
outstr  = strcat(outstr, sprintf('trgwindow: %d\n',       img.trgwindow));
outstr  = strcat(outstr, sprintf('reptime: %f\n',         img.reptime));
outstr  = strcat(outstr, sprintf('imgpcyc: %d\n',         img.imgpcyc));
outstr  = strcat(outstr, sprintf('xmtgain: %d\n',         img.xmtgain));
outstr  = strcat(outstr, sprintf('rcvgain1: %d\n',        img.rcvgain1));
outstr  = strcat(outstr, sprintf('rcvgain2: %d\n',        img.rcvgain2));
outstr  = strcat(outstr, sprintf('mr_flip: %d\n',         img.mr_flip));
outstr  = strcat(outstr, sprintf('mindat: %d\n',          img.mindat));
outstr  = strcat(outstr, sprintf('cphase: %d\n',          img.cphase));
outstr  = strcat(outstr, sprintf('swappf: %d\n',          img.swappf));
outstr  = strcat(outstr, sprintf('pauseint: %d\n',        img.pauseint));
outstr  = strcat(outstr, sprintf('pausetime: %f\n',       img.pausetime));
outstr  = strcat(outstr, sprintf('obplane: %d\n',         img.obplane));
outstr  = strcat(outstr, sprintf('slocfov: %d\n',         img.slocfov));
outstr  = strcat(outstr, sprintf('xmtfreq: %d\n',         img.xmtfreq));
outstr  = strcat(outstr, sprintf('autoxmtfreq: %d\n',     img.autoxmtfreq));
outstr  = strcat(outstr, sprintf('autoxmtgain: %d\n',     img.autoxmtgain));
outstr  = strcat(outstr, sprintf('prescan_r1: %d\n',      img.prescan_r1));
outstr  = strcat(outstr, sprintf('prescan_r2: %d\n',      img.prescan_r2));
outstr  = strcat(outstr, sprintf('user_bitmap: %d\n',     img.user_bitmap));
outstr  = strcat(outstr, sprintf('cenfreq: %d\n',         img.cenfreq));
outstr  = strcat(outstr, sprintf('imode: %d\n',           img.imode));
outstr  = strcat(outstr, sprintf('iopt: %d\n',            img.iopt));
outstr  = strcat(outstr, sprintf('pseq: %d\n',            img.pseq));
outstr  = strcat(outstr, sprintf('pseqmode: %d\n',        img.pseqmode));
outstr  = strcat(outstr, sprintf('psdname: %s\n',         cstring(img.psdname)));
outstr  = strcat(outstr, sprintf('psd_datetime: %d\n',    img.psd_datetime));
outstr  = strcat(outstr, sprintf('psd_iname: %s\n',       cstring(img.psd_iname)));
outstr  = strcat(outstr, sprintf('ctyp: %d\n',            img.ctyp));
outstr  = strcat(outstr, sprintf('cname: %s\n',         cstring(img.cname)));
outstr  = strcat(outstr, sprintf('surfctyp: %d\n',      img.surfctyp));
outstr  = strcat(outstr, sprintf('surfcext: %d\n',      img.surfcext));
outstr  = strcat(outstr, sprintf('rawrunnum: %d\n',     img.rawrunnum));
outstr  = strcat(outstr, sprintf('cal_fldstr: %d\n',    img.cal_fldstr));
outstr  = strcat(outstr, sprintf('supp_tech: %d\n',     img.supp_tech));
outstr  = strcat(outstr, sprintf('vbw: %f\n',           img.vbw));
outstr  = strcat(outstr, sprintf('slquant: %d\n',       img.slquant));
outstr  = strcat(outstr, sprintf('gpre: %d\n',          img.gpre));
outstr  = strcat(outstr, sprintf('intr_del: %d\n',      img.intr_del));
outstr  = strcat(outstr, sprintf('user0: %f\n',         img.user0));
outstr  = strcat(outstr, sprintf('user1: %f\n',         img.user1));
outstr  = strcat(outstr, sprintf('user2: %f\n',         img.user2));
outstr  = strcat(outstr, sprintf('user3: %f\n',         img.user3));
outstr  = strcat(outstr, sprintf('user4: %f\n',         img.user4));
outstr  = strcat(outstr, sprintf('user5: %f\n',         img.user5));
outstr  = strcat(outstr, sprintf('user6: %f\n',         img.user6));
outstr  = strcat(outstr, sprintf('user7: %f\n',         img.user7));
outstr  = strcat(outstr, sprintf('user8: %f\n',         img.user8));
outstr  = strcat(outstr, sprintf('user9: %f\n',         img.user9));
outstr  = strcat(outstr, sprintf('user10: %f\n',        img.user10));
outstr  = strcat(outstr, sprintf('user11: %f\n',        img.user11));
outstr  = strcat(outstr, sprintf('user12: %f\n',        img.user12));
outstr  = strcat(outstr, sprintf('user13: %f\n',        img.user13));
outstr  = strcat(outstr, sprintf('user14: %f\n',        img.user14));
outstr  = strcat(outstr, sprintf('user15: %f\n',        img.user15));
outstr  = strcat(outstr, sprintf('user16: %f\n',        img.user16));
outstr  = strcat(outstr, sprintf('user17: %f\n',        img.user17));
outstr  = strcat(outstr, sprintf('user18: %f\n',        img.user18));
outstr  = strcat(outstr, sprintf('user19: %f\n',        img.user19));
outstr  = strcat(outstr, sprintf('user20: %f\n',          img.user20));
outstr  = strcat(outstr, sprintf('user21: %f\n',          img.user21));
outstr  = strcat(outstr, sprintf('user22: %f\n',          img.user22));
outstr  = strcat(outstr, sprintf('user23: %f\n',          img.user23));
outstr  = strcat(outstr, sprintf('user24: %f\n',          img.user24));
outstr  = strcat(outstr, sprintf('im_alloc_key: %s\n',    sprintf('%s',img.im_alloc_key)));
outstr  = strcat(outstr, sprintf('im_lastmod: %d\n',      img.im_lastmod));
outstr  = strcat(outstr, sprintf('im_verscre: %s\n',      char(img.im_verscre)));
outstr  = strcat(outstr, sprintf('im_verscur: %s\n',      char(img.im_verscur)));
outstr  = strcat(outstr, sprintf('im_pds_a: %d\n',        img.im_pds_a));
outstr  = strcat(outstr, sprintf('im_pds_c: %d\n',        img.im_pds_c));
outstr  = strcat(outstr, sprintf('im_pds_u: %d\n',        img.im_pds_u));
outstr  = strcat(outstr, sprintf('im_checksum: %d\n',     img.im_checksum));
outstr  = strcat(outstr, sprintf('im_archived: %d\n',     img.im_archived));
outstr  = strcat(outstr, sprintf('im_complete: %d\n',     img.im_complete));
outstr  = strcat(outstr, sprintf('satbits: %d\n',         img.satbits));
outstr  = strcat(outstr, sprintf('scic: %d\n',            img.scic));
outstr  = strcat(outstr, sprintf('satxloc1: %d\n',        img.satxloc1));
outstr  = strcat(outstr, sprintf('satxloc2: %d\n',        img.satxloc2));
outstr  = strcat(outstr, sprintf('satyloc1: %d\n',        img.satyloc1));
outstr  = strcat(outstr, sprintf('satyloc2: %d\n',        img.satyloc2));
outstr  = strcat(outstr, sprintf('satzloc1: %d\n',        img.satzloc1));
outstr  = strcat(outstr, sprintf('satzloc2: %d\n',        img.satzloc2));
outstr  = strcat(outstr, sprintf('satxthick: %d\n',       img.satxthick));
outstr  = strcat(outstr, sprintf('satythick: %d\n',       img.satythick));
outstr  = strcat(outstr, sprintf('satzthick: %d\n',       img.satzthick));
outstr  = strcat(outstr, sprintf('flax: %d\n',            img.flax));
outstr  = strcat(outstr, sprintf('venc: %d\n',            img.venc));
outstr  = strcat(outstr, sprintf('thk_disclmr: %d\n',     img.thk_disclmr));
outstr  = strcat(outstr, sprintf('ps_flag: %d\n',         img.ps_flag));
outstr  = strcat(outstr, sprintf('ps_status: %d\n',       img.ps_status));
outstr  = strcat(outstr, sprintf('image_type: %d\n',      img.image_type));
outstr  = strcat(outstr, sprintf('vas_collapse: %d\n',    img.vas_collapse));
outstr  = strcat(outstr, sprintf('user23n: %f\n',         img.user23n));
outstr  = strcat(outstr, sprintf('user24n: %f\n',         img.user24n));
outstr  = strcat(outstr, sprintf('proj_alg: %d\n',        img.proj_alg));
outstr  = strcat(outstr, sprintf('proj_name: %s\n',       cstring(img.proj_name)));
outstr  = strcat(outstr, sprintf('x_axis_rot: %f\n',      img.x_axis_rot));
outstr  = strcat(outstr, sprintf('y_axis_rot: %f\n',      img.y_axis_rot));
outstr  = strcat(outstr, sprintf('z_axis_rot: %f\n',      img.z_axis_rot));
outstr  = strcat(outstr, sprintf('thresh_min1: %d\n',     img.thresh_min1));
outstr  = strcat(outstr, sprintf('thresh_max1: %d\n',     img.thresh_max1));
outstr  = strcat(outstr, sprintf('thresh_min2: %d\n',     img.thresh_min2));
outstr  = strcat(outstr, sprintf('thresh_max2: %d\n',     img.thresh_max2));
outstr  = strcat(outstr, sprintf('echo_trn_len: %d\n',    img.echo_trn_len));
outstr  = strcat(outstr, sprintf('frac_echo: %d\n',       img.frac_echo));
outstr  = strcat(outstr, sprintf('prep_pulse: %d\n',      img.prep_pulse));
outstr  = strcat(outstr, sprintf('cphasenum: %d\n',       img.cphasenum));
outstr  = strcat(outstr, sprintf('var_echo: %d\n',        img.var_echo));
outstr  = strcat(outstr, sprintf('ref_img: %s\n',         char(img.ref_img)));
outstr  = strcat(outstr, sprintf('sum_img: %s\n',         char(img.sum_img)));
outstr  = strcat(outstr, sprintf('img_window: %d\n',      img.img_window));
outstr  = strcat(outstr, sprintf('img_level: %d\n',       img.img_level));
outstr  = strcat(outstr, sprintf('slop_int_1: %d\n',      img.slop_int_1));
outstr  = strcat(outstr, sprintf('slop_int_2: %d\n',      img.slop_int_2));
outstr  = strcat(outstr, sprintf('slop_int_3: %d\n',      img.slop_int_3));
outstr  = strcat(outstr, sprintf('slop_int_4: %d\n',      img.slop_int_4));
outstr  = strcat(outstr, sprintf('slop_int_5: %d\n',      img.slop_int_5));
outstr  = strcat(outstr, sprintf('slop_float_1: %f\n',    img.slop_float_1));
outstr  = strcat(outstr, sprintf('slop_float_2: %f\n',    img.slop_float_2));
outstr  = strcat(outstr, sprintf('slop_float_3: %f\n',    img.slop_float_3));
outstr  = strcat(outstr, sprintf('slop_float_4: %f\n',    img.slop_float_4));
outstr  = strcat(outstr, sprintf('slop_float_5: %f\n',    img.slop_float_5));
outstr  = strcat(outstr, sprintf('slop_str_1: %s\n',      cstring(img.slop_str_1)));
outstr  = strcat(outstr, sprintf('slop_str_2: %s\n',      cstring(img.slop_str_2)));
outstr  = strcat(outstr, sprintf('scanactno: %d\n',       img.scanactno));
outstr  = strcat(outstr, sprintf('vasflags: %d\n',        img.vasflags));
outstr  = strcat(outstr, sprintf('vencscale: %f\n',       img.vencscale));
outstr  = strcat(outstr, sprintf('integrity: %d\n',       img.integrity));
outstr  = strcat(outstr, sprintf('fphase: %d\n',          img.fphase));
outstr  = strcat(outstr, sprintf('freq_dir: %d\n',        img.freq_dir));
outstr  = strcat(outstr, sprintf('vas_mode: %d\n',        img.vas_mode));
outstr  = strcat(outstr, sprintf('image_uid: %s\n',       sprintf('%s',img.image_uid)));
outstr  = strcat(outstr, sprintf('sop_uid: %s\n',         sprintf('%s',img.sop_uid)));
outstr  = strcat(outstr, sprintf('dont_use_1: %d\n',      img.dont_use_1));
outstr  = strcat(outstr, sprintf('dont_use_2: %d\n',      img.dont_use_2));
outstr  = strcat(outstr, sprintf('dont_use_3: %d\n',      img.dont_use_3));
outstr  = strcat(outstr, sprintf('pscopts: %d\n',         img.pscopts));
outstr  = strcat(outstr, sprintf('asoffsetx: %d\n',       img.asoffsetx));
outstr  = strcat(outstr, sprintf('asoffsety: %d\n',       img.asoffsety));
outstr  = strcat(outstr, sprintf('asoffsetz: %d\n',           img.asoffsetz));
outstr  = strcat(outstr, sprintf('unoriginal: %d\n',          img.unoriginal));
outstr  = strcat(outstr, sprintf('interleaves: %d\n',         img.interleaves));
outstr  = strcat(outstr, sprintf('effechospace: %d\n',        img.effechospace));
outstr  = strcat(outstr, sprintf('viewsperseg: %d\n',         img.viewsperseg));
outstr  = strcat(outstr, sprintf('rbpm: %d\n',                img.rbpm));
outstr  = strcat(outstr, sprintf('rtpoint: %d\n',             img.rtpoint));
outstr  = strcat(outstr, sprintf('rcvrtype: %d\n',            img.rcvrtype));
outstr  = strcat(outstr, sprintf('dbdt: %f\n',                img.dbdt));
outstr  = strcat(outstr, sprintf('dbdtper: %f\n',             img.dbdtper));
outstr  = strcat(outstr, sprintf('estdbdtper: %f\n',          img.estdbdtper));
outstr  = strcat(outstr, sprintf('estdbdtts: %f\n',           img.estdbdtts));
outstr  = strcat(outstr, sprintf('saravghead: %f\n',          img.saravghead));
outstr  = strcat(outstr, sprintf('neg_scanspacing: %f\n',     img.neg_scanspacing));
outstr  = strcat(outstr, sprintf('offsetfreq: %d\n',          img.offsetfreq));
outstr  = strcat(outstr, sprintf('user_usage_tag: %d\n',      img.user_usage_tag));
outstr  = strcat(outstr, sprintf('user_fill_mapMSW: %d\n',    img.user_fill_mapMSW));
outstr  = strcat(outstr, sprintf('user_fill_mapLSW: %d\n',    img.user_fill_mapLSW));
outstr  = strcat(outstr, sprintf('user25: %f\n',              img.user25));
outstr  = strcat(outstr, sprintf('user26: %f\n',              img.user26));
outstr  = strcat(outstr, sprintf('user27: %f\n',              img.user27));
outstr  = strcat(outstr, sprintf('user28: %f\n',              img.user28));
outstr  = strcat(outstr, sprintf('user29: %f\n',              img.user29));
outstr  = strcat(outstr, sprintf('user30: %f\n',              img.user30));
outstr  = strcat(outstr, sprintf('user31: %f\n',              img.user31));
outstr  = strcat(outstr, sprintf('user32: %f\n',              img.user32));
outstr  = strcat(outstr, sprintf('user33: %f\n',              img.user33));
outstr  = strcat(outstr, sprintf('user34: %f\n',              img.user34));
outstr  = strcat(outstr, sprintf('user35: %f\n',              img.user35));
outstr  = strcat(outstr, sprintf('user36: %f\n',              img.user36));
outstr  = strcat(outstr, sprintf('user37: %f\n',              img.user37));
outstr  = strcat(outstr, sprintf('user38: %f\n',              img.user38));
outstr  = strcat(outstr, sprintf('user39: %f\n',              img.user39));
outstr  = strcat(outstr, sprintf('user40: %f\n',              img.user40));
outstr  = strcat(outstr, sprintf('user41: %f\n',              img.user41));
outstr  = strcat(outstr, sprintf('user42: %f\n',              img.user42));
outstr  = strcat(outstr, sprintf('user43: %f\n',              img.user43));
outstr  = strcat(outstr, sprintf('user44: %f\n',              img.user44));
outstr  = strcat(outstr, sprintf('user45: %f\n',              img.user45));
outstr  = strcat(outstr, sprintf('user46: %f\n',              img.user46));
outstr  = strcat(outstr, sprintf('user47: %f\n',              img.user47));
outstr  = strcat(outstr, sprintf('user48: %f\n',              img.user48));
outstr  = strcat(outstr, sprintf('slop_int_6: %d\n',          img.slop_int_6));
outstr  = strcat(outstr, sprintf('slop_int_7: %d\n',          img.slop_int_7));
outstr  = strcat(outstr, sprintf('slop_int_8: %d\n',          img.slop_int_8));
outstr  = strcat(outstr, sprintf('slop_int_9: %d\n',          img.slop_int_9));
outstr  = strcat(outstr, sprintf('mr_padding: %s\n',          cstring(img.mr_padding)));

return
