/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.HeaderBlock;
import com.webcodepro.shrinkit.ThreadClass;
import com.webcodepro.shrinkit.ThreadFormat;
import com.webcodepro.shrinkit.ThreadKind;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import com.webcodepro.shrinkit.io.NufxLzw1InputStream;
import com.webcodepro.shrinkit.io.NufxLzw2InputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ThreadRecord {
    private ThreadClass threadClass;
    private ThreadFormat threadFormat;
    private ThreadKind threadKind;
    private int threadCrc;
    private long threadEof;
    private long compThreadEof;
    private byte[] threadData;

    public ThreadRecord(LittleEndianByteInputStream littleEndianByteInputStream) throws IOException {
        this(null, littleEndianByteInputStream);
    }

    public ThreadRecord(HeaderBlock headerBlock, LittleEndianByteInputStream littleEndianByteInputStream) throws IOException {
        this.threadClass = ThreadClass.find(littleEndianByteInputStream.readWord());
        this.threadFormat = ThreadFormat.find(littleEndianByteInputStream.readWord());
        this.threadKind = ThreadKind.find(littleEndianByteInputStream.readWord(), this.threadClass);
        this.threadCrc = littleEndianByteInputStream.readWord();
        this.threadEof = littleEndianByteInputStream.readLong();
        this.compThreadEof = littleEndianByteInputStream.readLong();
        if (this.threadKind == ThreadKind.DISK_IMAGE && headerBlock != null) {
            this.threadEof = headerBlock.getStorageType() <= 13 ? headerBlock.getExtraType() * 512L : (headerBlock.getStorageType() == 256 && headerBlock.getExtraType() == 280L && headerBlock.getFileSysId() == 2 ? headerBlock.getExtraType() * 512L : headerBlock.getExtraType() * (long)headerBlock.getStorageType());
        }
    }

    public void readThreadData(LittleEndianByteInputStream littleEndianByteInputStream) throws IOException {
        this.threadData = littleEndianByteInputStream.readBytes((int)this.compThreadEof);
    }

    public boolean isText() {
        return this.threadKind == ThreadKind.ASCII_TEXT || this.threadKind == ThreadKind.FILENAME;
    }

    public String getText() {
        return this.isText() ? new String(this.threadData, 0, (int)this.threadEof) : null;
    }

    public byte[] getBytes() {
        return this.threadData;
    }

    public InputStream getRawInputStream() {
        return new ByteArrayInputStream(this.threadData);
    }

    public InputStream getInputStream() throws IOException {
        switch (this.threadFormat) {
            case UNCOMPRESSED: {
                return this.getRawInputStream();
            }
            case DYNAMIC_LZW1: {
                return new NufxLzw1InputStream(new LittleEndianByteInputStream(this.getRawInputStream()));
            }
            case DYNAMIC_LZW2: {
                return new NufxLzw2InputStream(new LittleEndianByteInputStream(this.getRawInputStream()));
            }
        }
        throw new IOException("The thread format " + (Object)((Object)this.threadFormat) + " does not have an InputStream associated with it!");
    }

    public ThreadClass getThreadClass() {
        return this.threadClass;
    }

    public void setThreadClass(ThreadClass threadClass) {
        this.threadClass = threadClass;
    }

    public ThreadFormat getThreadFormat() {
        return this.threadFormat;
    }

    public void setThreadFormat(ThreadFormat threadFormat) {
        this.threadFormat = threadFormat;
    }

    public ThreadKind getThreadKind() {
        return this.threadKind;
    }

    public void setThreadKind(ThreadKind threadKind) {
        this.threadKind = threadKind;
    }

    public int getThreadCrc() {
        return this.threadCrc;
    }

    public void setThreadCrc(int n) {
        this.threadCrc = n;
    }

    public long getThreadEof() {
        return this.threadEof;
    }

    public void setThreadEof(long l) {
        this.threadEof = l;
    }

    public long getCompThreadEof() {
        return this.compThreadEof;
    }

    public void setCompThreadEof(long l) {
        this.compThreadEof = l;
    }

    public byte[] getThreadData() {
        return this.threadData;
    }

    public void setThreadData(byte[] byArray) {
        this.threadData = byArray;
    }
}

