/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.rdos;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.rdos.RdosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class RdosFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    private byte[] fileEntry;
    private RdosFormatDisk disk;

    public RdosFileEntry(byte[] byArray, RdosFormatDisk rdosFormatDisk) {
        this.fileEntry = byArray;
        this.disk = rdosFormatDisk;
    }

    public int getSizeInBlocks() {
        return AppleUtil.getUnsignedByte(this.fileEntry[25]);
    }

    public int getStartingBlock() {
        return AppleUtil.getWordValue(this.fileEntry, 30);
    }

    public int getAddress() {
        return AppleUtil.getWordValue(this.fileEntry, 26);
    }

    public String getFilename() {
        return this.isDeleted() ? this.textBundle.get("RdosFileEntry.NotInUse") : AppleUtil.getString(this.fileEntry, 0, 24).trim();
    }

    public void setFilename(String string) {
    }

    public int getMaximumFilenameLength() {
        return 24;
    }

    public String getFiletype() {
        return this.isDeleted() ? " " : AppleUtil.getString(this.fileEntry, 24, 1);
    }

    public void setFiletype(String string) {
    }

    public boolean isLocked() {
        return false;
    }

    public void setLocked(boolean bl) {
    }

    public int getSize() {
        return AppleUtil.getWordValue(this.fileEntry, 28);
    }

    public boolean isDirectory() {
        return false;
    }

    public List getFiles() {
        return null;
    }

    public boolean isDeleted() {
        return AppleUtil.getUnsignedByte(this.fileEntry[0]) == 128;
    }

    public void delete() {
    }

    public List getFileColumnData(int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 2: {
                arrayList.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getSizeInBlocks()));
                arrayList.add(this.getFilename());
                numberFormat.setMinimumIntegerDigits(1);
                arrayList.add(numberFormat.format(this.getSize()));
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getStartingBlock()));
                break;
            }
            case 3: {
                arrayList.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getSizeInBlocks()));
                arrayList.add(this.getFilename());
                numberFormat.setMinimumIntegerDigits(1);
                arrayList.add(numberFormat.format(this.getSize()));
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getStartingBlock()));
                arrayList.add("$" + AppleUtil.getFormattedWord(this.getAddress()));
                arrayList.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                break;
            }
            default: {
                arrayList.add(this.getFilename());
                arrayList.add(this.getFiletype());
                arrayList.add(numberFormat.format(this.getSize()));
                arrayList.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return arrayList;
    }

    public byte[] getFileData() {
        byte[] byArray = this.disk.getFileData(this);
        byte[] byArray2 = new byte[this.getSize()];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public void setFileData(byte[] byArray) throws DiskFullException {
    }

    public FileFilter getSuggestedFilter() {
        if (this.isApplesoftBasicFile()) {
            return new ApplesoftFileFilter();
        }
        if (this.isIntegerBasicFile()) {
            return new IntegerBasicFileFilter();
        }
        if (this.isTextFile()) {
            return new TextFileFilter();
        }
        if (this.isBinaryFile()) {
            int n = this.getSize();
            GraphicsFileFilter graphicsFileFilter = new GraphicsFileFilter();
            if (n >= 8185 && n <= 8192) {
                graphicsFileFilter.setMode(2);
                return graphicsFileFilter;
            }
            if (n >= 16377 && n <= 16384) {
                graphicsFileFilter.setMode(4);
                return graphicsFileFilter;
            }
        }
        return new BinaryFileFilter();
    }

    public boolean isTextFile() {
        return "T".equals(this.getFiletype());
    }

    public boolean isApplesoftBasicFile() {
        return "A".equals(this.getFiletype());
    }

    public boolean isIntegerBasicFile() {
        return "I".equals(this.getFiletype());
    }

    public boolean isBinaryFile() {
        return "B".equals(this.getFiletype());
    }

    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    public boolean needsAddress() {
        return this.disk.needsAddress(this.getFiletype());
    }

    public void setAddress(int n) {
    }

    public boolean canCompile() {
        return this.isApplesoftBasicFile();
    }
}

