/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.nakedos;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.nakedos.NakedosFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.List;

public class NakedosFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int TRACK_LOCATION_INDEX = 0;
    public static final int SECTOR_LOCATION_INDEX = 1;
    public static final int CATALOG_TRACK = 0;
    public static final int VTOC_SECTOR = 3;
    public static final int TRACK_SECTOR_PAIRS = 122;
    private static final String[] filetypes = new String[]{"B"};
    private int usedSectors = 0;
    private static final int[] sectorTranslate = new int[]{0, 7, 14, 6, 13, 5, 12, 4, 11, 3, 10, 2, 9, 1, 8, 15};

    public NakedosFormatDisk(String string, ImageOrder imageOrder) {
        super(string, imageOrder);
    }

    public static NakedosFormatDisk[] create(String string, ImageOrder imageOrder) {
        NakedosFormatDisk nakedosFormatDisk = new NakedosFormatDisk(string, imageOrder);
        nakedosFormatDisk.format();
        return new NakedosFormatDisk[]{nakedosFormatDisk};
    }

    public String getFormat() {
        return this.textBundle.get("NakedOS");
    }

    public List getFiles() {
        int n;
        ArrayList<NakedosFileEntry> arrayList = new ArrayList<NakedosFileEntry>();
        int n2 = 0;
        int[] nArray = new int[256];
        byte[] byArray = this.readSector(0, 3);
        byte[] byArray2 = this.readSector(0, 10);
        byte[] byArray3 = this.readSector(0, 2);
        for (n = 0; n < 48; ++n) {
            if (byArray[n + 208] != -2 && byArray[n + 208] != -1) {
                int n3 = AppleUtil.getUnsignedByte(byArray[n + 208]);
                nArray[n3] = nArray[n3] + 1;
            }
            if (byArray[n + 208] == -1) continue;
            ++n2;
        }
        for (n = 0; n < 256; ++n) {
            if (byArray2[n] != -2 && byArray2[n] != -1) {
                int n4 = AppleUtil.getUnsignedByte(byArray2[n]);
                nArray[n4] = nArray[n4] + 1;
            }
            if (byArray3[n] != -2 && byArray3[n] != -1) {
                int n5 = AppleUtil.getUnsignedByte(byArray3[n]);
                nArray[n5] = nArray[n5] + 1;
            }
            if (byArray2[n] != -1) {
                ++n2;
            }
            if (byArray3[n] == -1) continue;
            ++n2;
        }
        for (n = 0; n < 256; ++n) {
            if (nArray[n] == 0) continue;
            arrayList.add(new NakedosFileEntry(this, n, nArray[n]));
        }
        this.usedSectors = n2;
        return arrayList;
    }

    public FileEntry createFile() throws DiskFullException {
        return new NakedosFileEntry(this, -2, 0);
    }

    public boolean canCreateDirectories() {
        return false;
    }

    public boolean canCreateFile() {
        return false;
    }

    public int getFreeSpace() {
        return this.getFreeSectors() * 256;
    }

    public int getFreeSectors() {
        return this.getTotalSectors() - this.getUsedSectors();
    }

    public int getUsedSpace() {
        return this.usedSectors * 256;
    }

    public int getUsedSectors() {
        return this.usedSectors;
    }

    public int getTotalSectors() {
        int n = this.getTracks();
        int n2 = this.getSectors();
        return n * n2;
    }

    public String getDiskName() {
        return "";
    }

    protected byte[] readVtoc() {
        return this.readSector(0, 3);
    }

    protected void writeVtoc(byte[] byArray) {
        this.writeSector(0, 3, byArray);
    }

    public FormattedDisk.DiskUsage getDiskUsage() {
        return new WPDiskUsage();
    }

    public int getTracks() {
        return 35;
    }

    public int getSectors() {
        return 16;
    }

    public int[] getBitmapDimensions() {
        int n = this.getTracks();
        int n2 = this.getSectors();
        return new int[]{n, n2};
    }

    public int getBitmapLength() {
        return this.getTotalSectors();
    }

    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("DosFormatDisk.Track"), this.textBundle.get("DosFormatDisk.Sector")};
    }

    public List getDiskInformation() {
        this.getFiles();
        List list = super.getDiskInformation();
        return list;
    }

    public List getFileColumnHeaders(int n) {
        ArrayList<FormattedDisk.FileColumnHeader> arrayList = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (n) {
            case 2: {
                arrayList.add(new FormattedDisk.FileColumnHeader(" ", 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.Type"), 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 30, 1));
                break;
            }
            case 3: {
                arrayList.add(new FormattedDisk.FileColumnHeader(" ", 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.Type"), 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 30, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.TrackAndSectorList"), 7, 2));
                break;
            }
            default: {
                arrayList.addAll(super.getFileColumnHeaders(n));
            }
        }
        return arrayList;
    }

    public boolean supportsDeletedFiles() {
        return true;
    }

    public boolean canReadFileData() {
        return true;
    }

    public boolean canWriteFileData() {
        return false;
    }

    public boolean canHaveDirectories() {
        return false;
    }

    public boolean canDeleteFile() {
        return false;
    }

    public byte[] getFileData(FileEntry fileEntry) {
        byte[] byArray;
        int n;
        if (!(fileEntry instanceof NakedosFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("DosFormatDisk.InvalidFileEntryError"));
        }
        int n2 = 0;
        byte[] byArray2 = this.readSector(0, 3);
        byte[] byArray3 = this.readSector(0, 10);
        byte[] byArray4 = this.readSector(0, 2);
        NakedosFileEntry nakedosFileEntry = (NakedosFileEntry)fileEntry;
        byte[] byArray5 = new byte[nakedosFileEntry.getSize()];
        for (n = 0; n < 48; ++n) {
            if (AppleUtil.getUnsignedByte(byArray2[n + 208]) != nakedosFileEntry.getFileNumber()) continue;
            byArray = this.readSector(n / 16, sectorTranslate[n % 16]);
            System.arraycopy(byArray, 0, byArray5, n2, byArray.length);
            n2 += byArray.length;
        }
        for (n = 0; n < 256; ++n) {
            if (AppleUtil.getUnsignedByte(byArray3[n]) != nakedosFileEntry.getFileNumber()) continue;
            byArray = this.readSector((n + 48) / 16, sectorTranslate[(n + 48) % 16]);
            System.arraycopy(byArray, 0, byArray5, n2, byArray.length);
            n2 += byArray.length;
        }
        for (n = 0; n < 256; ++n) {
            if (AppleUtil.getUnsignedByte(byArray4[n]) != nakedosFileEntry.getFileNumber()) continue;
            byArray = this.readSector((n + 48 + 256) / 16, sectorTranslate[(n + 48 + 256) % 16]);
            System.arraycopy(byArray, 0, byArray5, n2, byArray.length);
            n2 += byArray.length;
        }
        return byArray5;
    }

    public void setFileData(FileEntry fileEntry, byte[] byArray) throws DiskFullException {
        this.setFileData((NakedosFileEntry)fileEntry, byArray);
    }

    protected void setFileData(NakedosFileEntry nakedosFileEntry, byte[] byArray) throws DiskFullException {
    }

    public void format() {
        this.getImageOrder().format();
        this.format();
    }

    protected void format(int n, int n2) {
    }

    protected void checkRange(int n, int n2) {
        if (n > 50 || n2 > 32) {
            throw new IllegalArgumentException(this.textBundle.format("DosFormatDisk.InvalidTrackAndSectorCombinationError", n, n2));
        }
    }

    public int getLogicalDiskNumber() {
        return 0;
    }

    public String getSuggestedFilename(String string) {
        int n = Math.min(string.length(), 2);
        return string.toUpperCase().substring(0, n).trim();
    }

    public String getSuggestedFiletype(String string) {
        return "B";
    }

    public String[] getFiletypes() {
        return filetypes;
    }

    public boolean needsAddress(String string) {
        return "B".equals(string);
    }

    public boolean supportsDiskMap() {
        return true;
    }

    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    public DirectoryEntry createDirectory() throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    public DirectoryEntry createDirectory(String string) throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    private class WPDiskUsage
    implements FormattedDisk.DiskUsage {
        private int[] location = null;

        private WPDiskUsage() {
        }

        public boolean hasNext() {
            return this.location == null || this.location[0] < NakedosFormatDisk.this.getTracks() && this.location[1] < NakedosFormatDisk.this.getSectors();
        }

        public void next() {
            if (this.location == null) {
                this.location = new int[2];
            } else {
                this.location[1] = this.location[1] + 1;
                if (this.location[1] >= NakedosFormatDisk.this.getSectors()) {
                    this.location[1] = 0;
                    this.location[0] = this.location[0] + 1;
                }
            }
        }

        public boolean isFree() {
            if (this.location == null || this.location.length != 2) {
                throw new IllegalArgumentException(StorageBundle.getInstance().get("DosFormatDisk.InvalidDimensionError"));
            }
            return false;
        }

        public boolean isUsed() {
            return !this.isFree();
        }
    }
}

