/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.transport;

import java.util.Vector;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;
import jssc.SerialPortTimeoutException;
import org.adtpro.gui.Gui;
import org.adtpro.resources.Messages;
import org.adtpro.transport.ATransport;
import org.adtpro.transport.TransportTimeoutException;
import org.adtpro.utilities.Log;
import org.adtpro.utilities.StringUtilities;
import org.adtpro.utilities.UnsignedByte;

public class SerialTransport
extends ATransport {
    protected SerialPort port;
    protected boolean connected;
    protected String _portName = null;
    protected int _currentSpeed = 0;
    protected boolean _hardware = false;
    protected Gui _parent = null;
    int _outPacketPtr = 0;
    byte[] _sendBuffer = null;

    public SerialTransport(Gui gui, String string, String string2, boolean bl) throws Exception {
        Log.getSingleton();
        Log.println(false, "SerialTransport constructor entry.");
        this._portName = string;
        this.connected = false;
        this._parent = gui;
        this._hardware = bl;
        this._currentSpeed = Integer.parseInt(string2);
        this._sendBuffer = new byte[32768];
        Log.println(false, "SerialTransport constructor exit.");
    }

    @Override
    public int transportType() {
        return 1;
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.connected) {
            this.connected = false;
            Log.println(false, "SerialTransport.close() closing port...");
            this.port.closePort();
            this.port = null;
            Log.println(false, "SerialTransport.close() closed port.");
            Log.println(true, "SerialTransport closed port.");
        } else {
            Log.println(false, "SerialTransport.close() didn't think port was connected.");
        }
    }

    public static String[] getPortNames() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = SerialPortList.getPortNames();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray2[i] = (String)vector.elementAt(i);
        }
        return stringArray2;
    }

    @Override
    public void open() throws Exception {
        if (this.connected) {
            return;
        }
        this.open(this._portName, this._currentSpeed, this._hardware);
    }

    public void open(String string, int n, boolean bl) throws Exception {
        Log.println(false, "SerialTransport.open() entry.");
        if (this.connected) {
            Log.println(false, "SerialTransport.open() was connected; closing.");
            this.close();
        }
        this.port = new SerialPort(string);
        this.port.openPort();
        this.port.setParams(n, 8, 1, 0);
        this.setHardwareHandshaking(bl);
        this.port.purgePort(12);
        this.flushReceiveBuffer();
        this.connected = true;
        Log.println(true, "SerialTransport opened port named " + string + " at speed " + n + ".");
    }

    @Override
    public byte readByte(int n) throws TransportTimeoutException {
        int n2 = 0;
        boolean bl = false;
        byte by = 0;
        while (!bl && this.connected) {
            try {
                by = this.port.readBytes(1, n * 1000)[0];
                bl = true;
            }
            catch (SerialPortTimeoutException serialPortTimeoutException) {
                ++n2;
            }
            catch (SerialPortException serialPortException) {
                Log.printStackTrace(serialPortException);
            }
            if (n2 / 4 <= n) continue;
            throw new TransportTimeoutException();
        }
        return by;
    }

    public void setParms(String string, int n, boolean bl) throws Exception {
        if (!string.equals(this._portName)) {
            this.close();
            this.open(string, n, bl);
            this._portName = string;
        } else {
            this.setHardwareHandshaking(bl);
            if (this._currentSpeed != n) {
                this.flushReceiveBuffer();
                this.flushSendBuffer();
                this._currentSpeed = n;
                this.port.setParams(n, 8, 1, 0);
            }
        }
    }

    @Override
    public void setSpeed(int n) {
        if (this._currentSpeed != n) {
            try {
                this.flushReceiveBuffer();
                this.flushSendBuffer();
                this._currentSpeed = n;
                this.port.setParams(n, 8, 1, 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void writeBytes(byte[] byArray, String string) {
        Log.println(false, "SerialTransport.writeBytes() adding " + byArray.length + " bytes to the stream.");
        if (this._outPacketPtr + byArray.length > this._sendBuffer.length) {
            int n;
            Log.println(false, "SerialTransport.writeBytes() Re-allocating the send buffer: " + this._sendBuffer.length + " bytes is the new size.");
            byte[] byArray2 = new byte[this._sendBuffer.length + byArray.length];
            for (n = 0; n < this._sendBuffer.length; ++n) {
                byArray2[n] = this._sendBuffer[n];
            }
            this._sendBuffer = new byte[byArray2.length * 2];
            for (n = 0; n < byArray2.length; ++n) {
                this._sendBuffer[n] = byArray2[n];
            }
            this._outPacketPtr = byArray2.length;
        }
        for (int i = 0; i < byArray.length; ++i) {
            this._sendBuffer[this._outPacketPtr++] = byArray[i];
        }
        if (this._outPacketPtr > 255) {
            Log.println(false, "SerialTransport.writeBytes() has " + this._outPacketPtr + " bytes to send.");
            this.pushBuffer();
        }
    }

    @Override
    public void writeBytes(String string) {
        this.writeBytes(string.getBytes(), "");
    }

    @Override
    public void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, "");
    }

    @Override
    public void writeBytes(char[] cArray) {
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        this.writeBytes(byArray, "");
    }

    @Override
    public void writeByte(char c) {
        byte[] byArray = new byte[]{(byte)c};
        this.writeBytes(byArray, "");
    }

    @Override
    public void writeByte(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.writeBytes(byArray, "");
    }

    @Override
    public void writeByte(byte by) {
        byte[] byArray = new byte[]{by};
        this.writeBytes(byArray, "");
    }

    public void writeByte(byte by, String string) {
        byte[] byArray = new byte[]{by};
        this.writeBytes(byArray, string);
    }

    public void pullBuffer() {
    }

    @Override
    public void pushBuffer() {
        Log.println(false, "SerialTransport.pushBuffer() entry, pushing " + this._outPacketPtr + " bytes.");
        if (this._outPacketPtr > 0) {
            if (Log.getSingleton().isLogging()) {
                Log.println(false, "SerialTransport.pushBuffer() pushing data:");
                for (int i = 0; i < this._outPacketPtr; ++i) {
                    if (i % 32 == 0 && i != 0) {
                        Log.println(false, "");
                    }
                    Log.print(false, UnsignedByte.toString(this._sendBuffer[i]) + " ");
                }
                Log.println(false, "");
            }
            try {
                while (this.port.getOutputBufferBytesCount() > 1) {
                }
                if (this._outPacketPtr == 1) {
                    this.port.writeByte(this._sendBuffer[0]);
                } else {
                    byte[] byArray = new byte[this._outPacketPtr];
                    for (int i = 0; i < this._outPacketPtr; ++i) {
                        byArray[i] = this._sendBuffer[i];
                    }
                    this.port.writeBytes(byArray);
                }
            }
            catch (SerialPortException serialPortException) {
                Log.printStackTrace(serialPortException);
                serialPortException.printStackTrace();
            }
            this._outPacketPtr = 0;
        }
        Log.println(false, "SerialTransport.pushBuffer() exit.");
    }

    @Override
    public void flushReceiveBuffer() {
    }

    @Override
    public void flushSendBuffer() {
    }

    @Override
    public void setFullSpeed() {
        try {
            this.port.setParams(this._currentSpeed, 8, 1, 0);
        }
        catch (SerialPortException serialPortException) {
            Log.printStackTrace(serialPortException);
        }
    }

    @Override
    public void setFullSpeed(int n) {
        try {
            this.port.setParams(this._currentSpeed, 8, 1, 0);
        }
        catch (SerialPortException serialPortException) {
            Log.printStackTrace(serialPortException);
        }
    }

    @Override
    public void setSlowSpeed(int n) {
        Log.println(false, "SerialTransport.setSlowSpeed() setting speed to " + n);
        try {
            this.port.setParams(n, 8, 1, 0);
        }
        catch (SerialPortException serialPortException) {
            Log.printStackTrace(serialPortException);
        }
    }

    @Override
    public boolean supportsBootstrap() {
        return true;
    }

    @Override
    public void pauseIncorrectCRC() {
    }

    public void setHardwareHandshaking(boolean bl) throws SerialPortException {
        this._hardware = bl;
        if (bl) {
            this.port.setFlowControlMode(3);
        } else {
            this.port.setFlowControlMode(0);
        }
    }

    @Override
    public String getInstructionsDone(String string) {
        Log.println(false, "SerialTransport.getInstructionsDone() getting instructions for: " + string);
        String string2 = "";
        if (string.equals(Messages.getString("Gui.BS.ProDOSFast")) || string.equals(Messages.getString("Gui.BS.ProDOSVSDrive"))) {
            this._parent.setSerialSpeed(115200);
        } else if (string.equals(Messages.getString("Gui.BS.ProDOS"))) {
            string2 = Messages.getString("Gui.BS.DumpProDOSInstructionsDone");
        } else if (string.equals(Messages.getString("Gui.BS.ProDOS2"))) {
            string2 = Messages.getString("Gui.BS.DumpProDOSInstructions2Done");
        } else if (string.equals(Messages.getString("Gui.BS.DOS"))) {
            string2 = Messages.getString("Gui.BS.DumpDOSInstructionsDone");
        } else if (string.equals(Messages.getString("Gui.BS.SOS"))) {
            // empty if block
        }
        Log.println(false, "SerialTransport.getInstructionsDone() returning: " + string2);
        return string2;
    }

    @Override
    public String getInstructions(String string, int n, int n2) {
        String string2;
        String string3 = "'SerialTransport.getInstructions() - returned null!'";
        if (string.equals(Messages.getString("Gui.BS.ProDOSFast"))) {
            string3 = Messages.getString("Gui.BS.DumpProDOSFastInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ProDOSVSDrive"))) {
            string3 = Messages.getString("Gui.BS.DumpProDOSVSDriveInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ProDOS"))) {
            string3 = Messages.getString("Gui.BS.DumpProDOSInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ProDOS2"))) {
            string3 = Messages.getString("Gui.BS.DumpProDOSInstructions2");
        } else if (string.equals(Messages.getString("Gui.BS.DOS"))) {
            string3 = Messages.getString("Gui.BS.DumpDOSInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.SOS"))) {
            string3 = Messages.getString("Gui.BS.DumpSOSInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ADT"))) {
            string3 = Messages.getString("Gui.BS.DumpADTInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ADTPro"))) {
            string3 = Messages.getString("Gui.BS.DumpProInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ADTProAudio"))) {
            string3 = Messages.getString("Gui.BS.DumpProAudioSerialInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ADTProEthernet"))) {
            string3 = Messages.getString("Gui.BS.DumpProEthernetInstructions");
        }
        switch (n2) {
            case 300: {
                string2 = "6";
                break;
            }
            case 600: {
                string2 = "7";
                break;
            }
            case 1200: {
                string2 = "8";
                break;
            }
            case 1800: {
                string2 = "9";
                break;
            }
            case 2400: {
                string2 = "10";
                break;
            }
            case 3600: {
                string2 = "11";
                break;
            }
            case 4800: {
                string2 = "12";
                break;
            }
            case 7200: {
                string2 = "13";
                break;
            }
            case 9600: {
                string2 = "14";
                break;
            }
            case 19200: {
                string2 = "15";
                break;
            }
            default: {
                string2 = "6";
            }
        }
        string3 = StringUtilities.replaceSubstring(string3, "%1%", string2);
        Log.println(false, "SerialTransport.getInstructions() returning:\n" + string3);
        return string3;
    }
}

