/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.transport;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.adtpro.resources.Messages;
import org.adtpro.transport.ATransport;
import org.adtpro.transport.TransportTimeoutException;
import org.adtpro.utilities.Log;
import org.adtpro.utilities.StringUtilities;
import org.adtpro.utilities.UnsignedByte;

public class SerialIPTransport
extends ATransport {
    String _host;
    int _port;
    int _inPacketPtr = 0;
    int _inPacketLen = 0;
    int _outPacketPtr = 0;
    Socket _socket = null;
    InetAddress _address = null;
    byte[] _receiveBuffer = null;
    byte[] _sendBuffer = null;

    public SerialIPTransport(String string, String string2) throws Exception {
        this._host = string;
        try {
            this._port = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this._port = 1977;
        }
        this._sendBuffer = new byte[1500];
    }

    @Override
    public int transportType() {
        return 4;
    }

    @Override
    public byte readByte(int n) throws TransportTimeoutException {
        if (this._receiveBuffer == null) {
            Log.println(false, "SerialIPTransport.readByte() needs to pull a buffer; buffer is null.");
            try {
                this.pullBuffer(n);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new TransportTimeoutException();
            }
            catch (Exception exception) {
                throw new TransportTimeoutException();
            }
        }
        if (this._inPacketPtr + 1 > this._inPacketLen) {
            Log.println(false, "SerialIPTransport.readByte() needs to pull a buffer; we're out of data.");
            try {
                this.pullBuffer(n);
            }
            catch (Exception exception) {
                throw new TransportTimeoutException();
            }
        }
        return this._receiveBuffer[this._inPacketPtr++];
    }

    @Override
    public synchronized void close() throws Exception {
        Log.println(false, "SerialIPTransport.close() entry.");
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
            Log.println(true, "SerialIPTransport closed SerialIP port " + this._port + ".");
        }
        Log.println(false, "SerialIPTransport.close() exit.");
    }

    @Override
    public void open() throws Exception {
        if (this._socket != null) {
            return;
        }
        this._address = InetAddress.getByName(this._host);
        try {
            this._socket = new Socket(this._address, this._port);
            this._socket.setSoTimeout(15000);
            Log.println(false, "SerialIPTransport opened SerialIP port " + this._port + " on host " + this._host);
        }
        catch (ConnectException connectException) {
            this._socket = null;
            Log.println(true, "SerialIPTransport failed to open SerialIP port " + this._port + " on host " + this._host);
        }
    }

    @Override
    public void writeBytes(byte[] byArray) {
        if (1499 - this._outPacketPtr < byArray.length) {
            this.pushBuffer();
        }
        if (1499 - this._outPacketPtr >= byArray.length) {
            if (this._outPacketPtr == 0) {
                // empty if block
            }
            for (int i = 0; i < byArray.length; ++i) {
                this._sendBuffer[this._outPacketPtr++] = byArray[i];
            }
        }
    }

    @Override
    public void writeBytes(char[] cArray) {
        if (1499 - this._outPacketPtr >= cArray.length) {
            if (this._outPacketPtr == 0) {
                // empty if block
            }
            for (int i = 0; i < cArray.length; ++i) {
                this._sendBuffer[this._outPacketPtr++] = (byte)cArray[i];
            }
        }
    }

    @Override
    public void writeBytes(String string) {
        this.writeBytes(string.getBytes());
    }

    @Override
    public void writeByte(char c) {
        byte[] byArray = new byte[]{(byte)c};
        this.writeBytes(byArray);
    }

    @Override
    public void writeByte(int n) {
        byte[] byArray = new byte[]{(byte)n};
        this.writeBytes(byArray);
    }

    @Override
    public void writeByte(byte by) {
        byte[] byArray = new byte[]{by};
        this.writeBytes(byArray);
    }

    @Override
    public void pushBuffer() {
        if (this._socket != null) {
            try {
                DataOutputStream dataOutputStream = null;
                dataOutputStream = new DataOutputStream(this._socket.getOutputStream());
                dataOutputStream.write(this._sendBuffer, 0, this._outPacketPtr);
                dataOutputStream.flush();
            }
            catch (SocketException socketException) {
                this._socket = null;
            }
            catch (Exception exception) {
                Log.printStackTrace(exception);
            }
        } else {
            Log.println(false, "SerialIPTransport.pushBuffer() socket not connected.");
        }
        this._outPacketPtr = 0;
    }

    public void pullBuffer(int n) throws Exception {
        Log.println(false, "SerialIPTransport.pullBuffer() entry.");
        int n2 = -1;
        this._receiveBuffer = new byte[1500];
        if (this._socket == null) {
            this.open();
        }
        DataInputStream dataInputStream = new DataInputStream(this._socket.getInputStream());
        try {
            n2 = dataInputStream.read(this._receiveBuffer, 0, 1500);
        }
        catch (IOException iOException) {
            Log.println(false, "SerialIPTransport.pullBuffer() got an ioexception from the socket read:");
            Log.println(false, iOException.getMessage());
            throw new TransportTimeoutException("No data");
        }
        Log.println(false, "SerialIPTransport.pullBuffer() received a packet.");
        if (n2 > 0) {
            this._inPacketLen = n2;
            this._inPacketPtr = 0;
            Log.println(false, "SerialIPTransport.pullBuffer() pulled data:");
            for (int i = 0; i < this._inPacketLen; ++i) {
                if (i % 32 == 0 && i != 0) {
                    Log.println(false, "");
                }
                Log.print(false, UnsignedByte.toString(this._receiveBuffer[i]) + " ");
            }
        } else {
            Log.println(false, "SerialIPTransport.pullBuffer() got 0 or -1 from our socket read.");
            if (n2 == -1) {
                this._socket = null;
            }
            throw new TransportTimeoutException("No data");
        }
        Log.println(false, "");
    }

    @Override
    public void flushReceiveBuffer() {
        this._receiveBuffer = null;
    }

    @Override
    public void flushSendBuffer() {
        this._outPacketPtr = 0;
    }

    @Override
    public void setSpeed(int n) {
    }

    @Override
    public void setFullSpeed() {
    }

    @Override
    public void setFullSpeed(int n) {
    }

    @Override
    public void setSlowSpeed(int n) {
    }

    @Override
    public boolean supportsBootstrap() {
        return true;
    }

    @Override
    public void pauseIncorrectCRC() {
    }

    @Override
    public String getInstructionsDone(String string) {
        Log.println(false, "SerialTransport.getInstructionsDone() getting instructions for: " + string);
        String string2 = "";
        if (!string.equals(Messages.getString("Gui.BS.ProDOSFast"))) {
            if (string.equals(Messages.getString("Gui.BS.ProDOS"))) {
                string2 = Messages.getString("Gui.BS.DumpProDOSInstructionsDone");
            } else if (string.equals(Messages.getString("Gui.BS.ProDOS2"))) {
                string2 = Messages.getString("Gui.BS.DumpProDOSInstructions2Done");
            } else if (string.equals(Messages.getString("Gui.BS.DOS"))) {
                string2 = Messages.getString("Gui.BS.DumpDOSInstructionsDone");
            } else if (string.equals(Messages.getString("Gui.BS.SOS"))) {
                // empty if block
            }
        }
        Log.println(false, "SerialTransport.getInstructionsDone() returning: " + string2);
        return string2;
    }

    @Override
    public String getInstructions(String string, int n, int n2) {
        String string2;
        String string3 = "'SerialTransport.getInstructions() - returned null!'";
        if (string.equals(Messages.getString("Gui.BS.ProDOSFast"))) {
            string3 = Messages.getString("Gui.BS.DumpProDOSFastInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ProDOSVSDrive"))) {
            string3 = Messages.getString("Gui.BS.DumpProDOSVSDriveInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ProDOS"))) {
            string3 = Messages.getString("Gui.BS.DumpProDOSInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ProDOS2"))) {
            string3 = Messages.getString("Gui.BS.DumpProDOSInstructions2");
        } else if (string.equals(Messages.getString("Gui.BS.DOS"))) {
            string3 = Messages.getString("Gui.BS.DumpDOSInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.SOS"))) {
            string3 = Messages.getString("Gui.BS.DumpSOSInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ADT"))) {
            string3 = Messages.getString("Gui.BS.DumpADTInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ADTPro"))) {
            string3 = Messages.getString("Gui.BS.DumpProInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ADTProAudio"))) {
            string3 = Messages.getString("Gui.BS.DumpProAudioSerialInstructions");
        } else if (string.equals(Messages.getString("Gui.BS.ADTProEthernet"))) {
            string3 = Messages.getString("Gui.BS.DumpProEthernetInstructions");
        }
        switch (n2) {
            case 300: {
                string2 = "6";
                break;
            }
            case 600: {
                string2 = "7";
                break;
            }
            case 1200: {
                string2 = "8";
                break;
            }
            case 1800: {
                string2 = "9";
                break;
            }
            case 2400: {
                string2 = "10";
                break;
            }
            case 3600: {
                string2 = "11";
                break;
            }
            case 4800: {
                string2 = "12";
                break;
            }
            case 7200: {
                string2 = "13";
                break;
            }
            case 9600: {
                string2 = "14";
                break;
            }
            case 19200: {
                string2 = "15";
                break;
            }
            default: {
                string2 = "6";
            }
        }
        string3 = StringUtilities.replaceSubstring(string3, "%1%", string2);
        Log.println(false, "SerialTransport.getInstructions() returning:\n" + string3);
        return string3;
    }
}

