/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.transport;

import org.adtpro.ADTProperties;
import org.adtpro.gui.Gui;
import org.adtpro.resources.Messages;
import org.adtpro.transport.ATransport;
import org.adtpro.transport.TransportClosedException;
import org.adtpro.transport.TransportTimeoutException;
import org.adtpro.transport.audio.BytesToWav;
import org.adtpro.transport.audio.CaptureThread;
import org.adtpro.transport.audio.PlaybackThread;
import org.adtpro.utilities.Log;
import org.adtpro.utilities.StringUtilities;
import org.adtpro.utilities.UnsignedByte;

public class AudioTransport
extends ATransport {
    int _inPacketPtr = 0;
    int _inPacketLen = 0;
    int _outPacketPtr = 0;
    int _bigOutPacketPtr = 0;
    byte[] _receiveBuffer = null;
    byte[] _sendBuffer = null;
    byte[] _bigBuffer = null;
    CaptureThread _captureThread = null;
    PlaybackThread _sendThread = null;
    ADTProperties _properties = null;

    public AudioTransport(ADTProperties aDTProperties) {
        this._properties = aDTProperties;
    }

    @Override
    public void open() throws Exception {
        Log.getSingleton();
        Log.println(false, "AudioTransport.open() entry...");
        int n = 0;
        try {
            n = Integer.parseInt(this._properties.getProperty("AudioHardwareIndex", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this._captureThread = new CaptureThread(n);
        this._captureThread.start();
        Log.println(true, "AudioTransport opened.");
        this._sendBuffer = new byte[4000];
        Log.println(false, "AudioTransport.open() exit.");
    }

    @Override
    public int transportType() {
        return 3;
    }

    @Override
    public void setSpeed(int n) {
    }

    @Override
    public void setSlowSpeed(int n) {
    }

    @Override
    public void setFullSpeed() {
    }

    @Override
    public void setFullSpeed(int n) {
    }

    @Override
    public void writeBytes(byte[] byArray) {
        if (3999 - this._outPacketPtr >= byArray.length) {
            for (int i = 0; i < byArray.length; ++i) {
                this._sendBuffer[this._outPacketPtr++] = byArray[i];
            }
        } else {
            Log.println(false, "AudioTransport.writeBytes() didn't have room - need " + byArray.length + " more bytes!");
        }
    }

    @Override
    public void writeBytes(char[] cArray) {
        if (3999 - this._outPacketPtr >= cArray.length) {
            for (int i = 0; i < cArray.length; ++i) {
                this._sendBuffer[this._outPacketPtr++] = (byte)cArray[i];
            }
        } else {
            Log.println(true, "AudioTransport.writeBytes(char[]) - buffer too large!");
        }
    }

    public void writeBigBytes(byte[] byArray) {
        this._bigBuffer = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this._bigBuffer[this._bigOutPacketPtr++] = byArray[i];
        }
    }

    @Override
    public void writeBytes(String string) {
        this.writeBytes(string.getBytes());
    }

    @Override
    public void writeByte(char c) {
        byte[] byArray = new byte[]{(byte)c};
        this.writeBytes(byArray);
    }

    @Override
    public void writeByte(int n) {
        byte[] byArray = new byte[]{(byte)n};
        this.writeBytes(byArray);
    }

    @Override
    public void writeByte(byte by) {
        byte[] byArray = new byte[]{by};
        this.writeBytes(byArray);
    }

    @Override
    public byte readByte(int n) throws TransportTimeoutException {
        byte by = 0;
        if (this._receiveBuffer == null) {
            try {
                this.pullBuffer(n);
            }
            catch (TransportTimeoutException transportTimeoutException) {
                throw transportTimeoutException;
            }
            catch (TransportClosedException transportClosedException) {
                throw new TransportTimeoutException();
            }
        }
        if (this._inPacketPtr + 1 > this._inPacketLen) {
            try {
                this.pullBuffer(n);
            }
            catch (TransportTimeoutException transportTimeoutException) {
                throw transportTimeoutException;
            }
            catch (TransportClosedException transportClosedException) {
                throw new TransportTimeoutException();
            }
        }
        if (this._receiveBuffer != null) {
            by = this._receiveBuffer.length > 0 ? this._receiveBuffer[this._inPacketPtr++] : (byte)0;
        }
        return by;
    }

    @Override
    public void pushBuffer() {
        Log.println(false, "AudioTransport.pushBuffer() entry, pushing " + this._outPacketPtr + " bytes.");
        Log.println(false, "AudioTransport.pushBuffer() pushing data:");
        for (int i = 0; i < this._outPacketPtr; ++i) {
            if (i % 32 == 0 && i != 0) {
                Log.println(false, "");
            }
            Log.print(false, UnsignedByte.toString(this._sendBuffer[i]) + " ");
        }
        Log.println(false, "");
        byte[] byArray = BytesToWav.encode(this._sendBuffer, this._outPacketPtr);
        if (this._sendThread != null) {
            try {
                this._sendThread.join();
            }
            catch (InterruptedException interruptedException) {
                Log.printStackTrace(interruptedException);
            }
        }
        this._sendThread = new PlaybackThread(byArray);
        this._sendThread.start();
        this._outPacketPtr = 0;
        this.flushReceiveBuffer();
        try {
            this._sendThread.join();
        }
        catch (InterruptedException interruptedException) {
            Log.printStackTrace(interruptedException);
        }
        this._inPacketLen = 0;
        this._receiveBuffer = null;
        this._inPacketPtr = 0;
        Log.println(false, "AudioTransport.pushBuffer() exit.");
    }

    public void pushBigBuffer(Gui gui) {
        Log.println(false, "AudioTransport.pushBigBuffer() entry, pushing " + this._bigBuffer.length + " bytes.");
        if (this._sendThread != null) {
            try {
                Log.println(false, "AudioTransport.pushBigBuffer() waiting for another send thread to end...");
                this._sendThread.join();
                Log.println(false, "AudioTransport.pushBigBuffer() done waiting.");
            }
            catch (InterruptedException interruptedException) {
                Log.printStackTrace(interruptedException);
            }
        }
        Log.println(false, "AudioTransport.pushBigBuffer() pushing data:");
        for (int i = 0; i < this._bigBuffer.length; ++i) {
            if (i % 32 == 0 && i != 0) {
                Log.println(false, "");
            }
            Log.print(false, UnsignedByte.toString(this._bigBuffer[i]) + " ");
        }
        Log.println(false, "");
        byte[] byArray = BytesToWav.encode(this._bigBuffer, this._bigOutPacketPtr, 7000);
        this._sendThread = new PlaybackThread(byArray, gui);
        this._sendThread.play();
        this._bigOutPacketPtr = 0;
        this._bigBuffer = null;
        Log.println(false, "AudioTransport.pushBigBuffer() exit.");
    }

    public void pullBuffer(int n) throws TransportTimeoutException, TransportClosedException {
        int n2 = 0;
        while (this._captureThread != null && this._captureThread.receiveBufferSize() == 0 && n2 / 4 < n) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n2;
        }
        if (this._captureThread != null) {
            if (this._captureThread.receiveBufferSize() == 0) {
                throw new TransportTimeoutException();
            }
            if (this._captureThread.receiveBufferSize() > 0) {
                this._receiveBuffer = this._captureThread.retrieveReceiveBuffer();
                this._inPacketLen = this._receiveBuffer.length;
                this._inPacketPtr = 0;
                Log.println(false, "AudioTransport.pullBuffer() pulled data:");
                for (int i = 0; i < this._inPacketLen; ++i) {
                    if (i % 32 == 0 && i != 0) {
                        Log.println(false, "");
                    }
                    Log.print(false, UnsignedByte.toString(this._receiveBuffer[i]) + " ");
                }
            }
        } else {
            throw new TransportClosedException();
        }
        Log.println(false, "");
        Log.println(false, "AudioTransport.pullBuffer() exit; _inPacketLen = " + this._inPacketLen);
    }

    @Override
    public void flushSendBuffer() {
        Log.println(false, "AudioTransport.flushSendBuffer() entry.");
        this._outPacketPtr = 0;
        Log.println(false, "AudioTransport.flushSendBuffer() exit.");
    }

    @Override
    public void flushReceiveBuffer() {
        Log.println(false, "AudioTransport.flushReceiveBuffer() entry.");
        if (this._captureThread != null) {
            this._captureThread.flushReceiveBuffer();
        }
        Log.println(false, "AudioTransport.flushReceiveBuffer() exit.");
    }

    @Override
    public void close() throws Exception {
        Log.println(false, "AudioTransport.close() entry.");
        if (this._captureThread != null) {
            this._captureThread.requestStop();
            this._captureThread = null;
        }
        if (this._sendThread != null) {
            this._sendThread.requestStop();
            this._sendThread = null;
        }
        this._sendBuffer = null;
        Log.println(true, "AudioTransport closed.");
        Log.println(false, "AudioTransport.close() exit.");
    }

    @Override
    public boolean supportsBootstrap() {
        return true;
    }

    @Override
    public void pauseIncorrectCRC() {
        try {
            Log.getSingleton();
            Log.println(false, "AudioTransport.pauseIncorrectCRC() Pausing for garbled data...");
            Thread.sleep(7000L);
            Log.println(false, "AudioTransport.pauseIncorrectCRC() Done pausing.");
        }
        catch (InterruptedException interruptedException) {
            Log.printStackTrace(interruptedException);
        }
    }

    @Override
    public String getInstructions(String string, int n, int n2) {
        String string2 = "AudioTransport.getInstructions() - returned null!";
        int n3 = 0;
        if (string.equals(Messages.getString("Gui.BS.ProDOS"))) {
            string2 = Messages.getString("Gui.BS.DumpProDOSAudioInstructions");
            n3 = n - 1 + 8192;
            String string3 = UnsignedByte.toString(UnsignedByte.hiByte(n3)) + UnsignedByte.toString(UnsignedByte.loByte(n3));
            string2 = StringUtilities.replaceSubstring(string2, "%1%", string3);
        } else if (string.equals(Messages.getString("Gui.BS.DOS"))) {
            string2 = Messages.getString("Gui.BS.DumpDOSAudioInstructions");
            n3 = n - 1 + 976;
            String string4 = UnsignedByte.toString(UnsignedByte.hiByte(n3)) + UnsignedByte.toString(UnsignedByte.loByte(n3));
            string2 = StringUtilities.replaceSubstring(string2, "%1%", string4);
            string2 = StringUtilities.replaceSubstring(string2, "0.0", "0.");
        } else if (string.equals(Messages.getString("Gui.BS.ADT"))) {
            string2 = Messages.getString("Gui.BS.DumpADTAudioInstructions");
            n3 = n - 1 + 2051;
            String string5 = UnsignedByte.toString(UnsignedByte.hiByte(n3)) + UnsignedByte.toString(UnsignedByte.loByte(n3));
            string2 = StringUtilities.replaceSubstring(string2, "%1%", string5);
        } else if (string.equals(Messages.getString("Gui.BS.DOS2"))) {
            string2 = Messages.getString("Gui.BS.DumpDOSAudioInstructions2");
        } else if (string.equals(Messages.getString("Gui.BS.ADTPro")) || string.equals(Messages.getString("Gui.BS.ADTProAudio")) || string.equals(Messages.getString("Gui.BS.ADTProEthernet"))) {
            if (string.equals(Messages.getString("Gui.BS.ADTPro"))) {
                string2 = Messages.getString("Gui.BS.DumpProAudioInstructions");
            } else if (string.equals(Messages.getString("Gui.BS.ADTProAudio"))) {
                string2 = Messages.getString("Gui.BS.DumpProAudioAudioInstructions");
            } else if (string.equals(Messages.getString("Gui.BS.ADTProEthernet"))) {
                string2 = Messages.getString("Gui.BS.DumpProEthernetAudioInstructions");
            }
            n3 = n - 1 + 2048;
            String string6 = UnsignedByte.toString(UnsignedByte.hiByte(n3)) + UnsignedByte.toString(UnsignedByte.loByte(n3));
            string2 = StringUtilities.replaceSubstring(string2, "%1%", string6);
        }
        Log.println(false, "AudioTransport.getInstructions() returning:\n" + string2);
        return string2;
    }

    public void setAudioParms() throws Exception {
        this._captureThread.requestStop();
        int n = 0;
        try {
            n = Integer.parseInt(this._properties.getProperty("AudioHardwareIndex", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this._captureThread = new CaptureThread(n);
        this._captureThread.start();
    }

    @Override
    public String getInstructionsDone(String string) {
        Log.println(false, "AudioTransport.getInstructionsDone() entry for command: " + string);
        String string2 = "AudioTransport.getInstructionsDone() - returned null!";
        if (string.equals(Messages.getString("Gui.BS.ProDOS"))) {
            string2 = Messages.getString("Gui.BS.DumpProDOSAudioInstructionsDone");
        } else if (string.equals(Messages.getString("Gui.BS.ProDOS2"))) {
            string2 = Messages.getString("Gui.BS.DumpProDOSAudioInstructions2Done");
        } else if (string.equals(Messages.getString("Gui.BS.DOS"))) {
            string2 = Messages.getString("Gui.BS.DumpDOSAudioInstructionsDone");
        } else if (string.equals(Messages.getString("Gui.BS.DOS2"))) {
            string2 = Messages.getString("Gui.BS.DumpDOSAudioInstructions2Done");
        } else if (string.equals(Messages.getString("Gui.BS.ADT")) || string.equals(Messages.getString("Gui.BS.ADTPro")) || string.equals(Messages.getString("Gui.BS.ADTProAudio")) || string.equals(Messages.getString("Gui.BS.ADTProEthernet"))) {
            if (string.equals(Messages.getString("Gui.BS.ADT"))) {
                string2 = Messages.getString("Gui.BS.DumpADTAudioInstructionsDone");
            } else if (string.equals(Messages.getString("Gui.BS.ADTPro"))) {
                string2 = Messages.getString("Gui.BS.DumpProAudioInstructionsDone");
            } else if (string.equals(Messages.getString("Gui.BS.ADTProAudio"))) {
                string2 = Messages.getString("Gui.BS.DumpProAudioAudioInstructionsDone");
            } else if (string.equals(Messages.getString("Gui.BS.ADTProEthernet"))) {
                string2 = Messages.getString("Gui.BS.DumpProEthernetAudioInstructionsDone");
            }
        }
        Log.println(false, "AudioTransport.getInstructionsDone() returning:\n" + string2);
        return string2;
    }
}

