!!****f* ABINIT/ptg_Oh
!!
!! NAME
!! ptg_Oh
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2010-2020 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      m_ptgroups
!!
!! CHILDREN
!!
!! SOURCE
!!
!********************************************************************************
! This include file has been automatically generated by the script ptg.py
! Do not edit! Change the script source instead.
!********************************************************************************

! Point group name  Oh (m-3m)

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


module m_ptg_Oh
contains
!!**



 subroutine ptg_Oh (nsym,nclass,sym,class_ids,class_names,Irr)

#ifdef FC_INTEL
!DEC$ NOOPTIMIZE
#endif

 use defs_basis
 use m_abicore
 use m_defs_ptgroups,  only : irrep_t
 implicit none
!Arguments ------------------------------------
 integer,intent(out) :: nclass,nsym 
 !arrays
 integer,allocatable,intent(out) :: sym(:,:,:), class_ids(:,:)
 character(len=5),allocatable,intent(out) :: class_names(:)
 type(irrep_t),allocatable,intent(out) :: Irr(:)
 !Local variables-------------------------------
 complex(dpc) :: j=(0.0_dp,1.0_dp) 
 ! ********************************************************************************
! List of symmetries packed in classes
 nsym = 48
 ABI_MALLOC(sym, (3,3,nsym))
 sym(:,:,1) = RESHAPE( (/1, 0, 0, 0, 1, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,2) = RESHAPE( (/-1, 0, 0, 0, -1, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,3) = RESHAPE( (/1, 0, 0, 0, -1, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,4) = RESHAPE( (/-1, 0, 0, 0, 1, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,5) = RESHAPE( (/0, 1, 0, 0, 0, 1, 1, 0, 0/) ,(/3,3/) )
 sym(:,:,6) = RESHAPE( (/0, -1, 0, 0, 0, -1, 1, 0, 0/) ,(/3,3/) )
 sym(:,:,7) = RESHAPE( (/0, 1, 0, 0, 0, -1, -1, 0, 0/) ,(/3,3/) )
 sym(:,:,8) = RESHAPE( (/0, -1, 0, 0, 0, 1, -1, 0, 0/) ,(/3,3/) )
 sym(:,:,9) = RESHAPE( (/0, 0, 1, 1, 0, 0, 0, 1, 0/) ,(/3,3/) )
 sym(:,:,10) = RESHAPE( (/0, 0, -1, -1, 0, 0, 0, 1, 0/) ,(/3,3/) )
 sym(:,:,11) = RESHAPE( (/0, 0, 1, -1, 0, 0, 0, -1, 0/) ,(/3,3/) )
 sym(:,:,12) = RESHAPE( (/0, 0, -1, 1, 0, 0, 0, -1, 0/) ,(/3,3/) )
 sym(:,:,13) = RESHAPE( (/0, 1, 0, 1, 0, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,14) = RESHAPE( (/0, -1, 0, -1, 0, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,15) = RESHAPE( (/-1, 0, 0, 0, 0, 1, 0, 1, 0/) ,(/3,3/) )
 sym(:,:,16) = RESHAPE( (/-1, 0, 0, 0, 0, -1, 0, -1, 0/) ,(/3,3/) )
 sym(:,:,17) = RESHAPE( (/0, 0, 1, 0, -1, 0, 1, 0, 0/) ,(/3,3/) )
 sym(:,:,18) = RESHAPE( (/0, 0, -1, 0, -1, 0, -1, 0, 0/) ,(/3,3/) )
 sym(:,:,19) = RESHAPE( (/0, 1, 0, -1, 0, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,20) = RESHAPE( (/0, -1, 0, 1, 0, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,21) = RESHAPE( (/1, 0, 0, 0, 0, -1, 0, 1, 0/) ,(/3,3/) )
 sym(:,:,22) = RESHAPE( (/1, 0, 0, 0, 0, 1, 0, -1, 0/) ,(/3,3/) )
 sym(:,:,23) = RESHAPE( (/0, 0, -1, 0, 1, 0, 1, 0, 0/) ,(/3,3/) )
 sym(:,:,24) = RESHAPE( (/0, 0, 1, 0, 1, 0, -1, 0, 0/) ,(/3,3/) )
 sym(:,:,25) = RESHAPE( (/-1, 0, 0, 0, -1, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,26) = RESHAPE( (/1, 0, 0, 0, 1, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,27) = RESHAPE( (/-1, 0, 0, 0, 1, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,28) = RESHAPE( (/1, 0, 0, 0, -1, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,29) = RESHAPE( (/0, -1, 0, 0, 0, -1, -1, 0, 0/) ,(/3,3/) )
 sym(:,:,30) = RESHAPE( (/0, 1, 0, 0, 0, 1, -1, 0, 0/) ,(/3,3/) )
 sym(:,:,31) = RESHAPE( (/0, -1, 0, 0, 0, 1, 1, 0, 0/) ,(/3,3/) )
 sym(:,:,32) = RESHAPE( (/0, 1, 0, 0, 0, -1, 1, 0, 0/) ,(/3,3/) )
 sym(:,:,33) = RESHAPE( (/0, 0, -1, -1, 0, 0, 0, -1, 0/) ,(/3,3/) )
 sym(:,:,34) = RESHAPE( (/0, 0, 1, 1, 0, 0, 0, -1, 0/) ,(/3,3/) )
 sym(:,:,35) = RESHAPE( (/0, 0, -1, 1, 0, 0, 0, 1, 0/) ,(/3,3/) )
 sym(:,:,36) = RESHAPE( (/0, 0, 1, -1, 0, 0, 0, 1, 0/) ,(/3,3/) )
 sym(:,:,37) = RESHAPE( (/0, -1, 0, -1, 0, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,38) = RESHAPE( (/0, 1, 0, 1, 0, 0, 0, 0, 1/) ,(/3,3/) )
 sym(:,:,39) = RESHAPE( (/1, 0, 0, 0, 0, -1, 0, -1, 0/) ,(/3,3/) )
 sym(:,:,40) = RESHAPE( (/1, 0, 0, 0, 0, 1, 0, 1, 0/) ,(/3,3/) )
 sym(:,:,41) = RESHAPE( (/0, 0, -1, 0, 1, 0, -1, 0, 0/) ,(/3,3/) )
 sym(:,:,42) = RESHAPE( (/0, 0, 1, 0, 1, 0, 1, 0, 0/) ,(/3,3/) )
 sym(:,:,43) = RESHAPE( (/0, -1, 0, 1, 0, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,44) = RESHAPE( (/0, 1, 0, -1, 0, 0, 0, 0, -1/) ,(/3,3/) )
 sym(:,:,45) = RESHAPE( (/-1, 0, 0, 0, 0, 1, 0, -1, 0/) ,(/3,3/) )
 sym(:,:,46) = RESHAPE( (/-1, 0, 0, 0, 0, -1, 0, 1, 0/) ,(/3,3/) )
 sym(:,:,47) = RESHAPE( (/0, 0, 1, 0, -1, 0, -1, 0, 0/) ,(/3,3/) )
 sym(:,:,48) = RESHAPE( (/0, 0, -1, 0, -1, 0, 1, 0, 0/) ,(/3,3/) )

! Number of classes and corresponding indeces
 nclass = 10
 ABI_MALLOC(class_ids, (2,nclass))
 class_ids(1,1) = 1
 class_ids(2,1) = 1
 class_ids(1,2) = 2
 class_ids(2,2) = 4
 class_ids(1,3) = 5
 class_ids(2,3) = 12
 class_ids(1,4) = 13
 class_ids(2,4) = 18
 class_ids(1,5) = 19
 class_ids(2,5) = 24
 class_ids(1,6) = 25
 class_ids(2,6) = 25
 class_ids(1,7) = 26
 class_ids(2,7) = 28
 class_ids(1,8) = 29
 class_ids(2,8) = 36
 class_ids(1,9) = 37
 class_ids(2,9) = 42
 class_ids(1,10) = 43
 class_ids(2,10) = 48

ABI_MALLOC(class_names,(10))
 class_names(1) = "1+" 
 class_names(2) = "2+" 
 class_names(3) = "3+" 
 class_names(4) = "2+" 
 class_names(5) = "4+" 
 class_names(6) = "-2-" 
 class_names(7) = "-2+" 
 class_names(8) = "-6-" 
 class_names(9) = "-2+" 
 class_names(10) = "-4+" 

! List of irreducible representations.
 ABI_DT_MALLOC(Irr, (10))
 Irr(1)%name = "A1g"
 Irr(1)%dim = 1
 Irr(1)%nsym = 48
 ABI_MALLOC(Irr(1)%mat, (1,1,48))
 Irr(1)%mat(:,:,1) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,2) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,3) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,4) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,5) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,6) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,7) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,8) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,9) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,10) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,11) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,12) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,13) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,14) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,15) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,16) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,17) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,18) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,19) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,20) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,21) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,22) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,23) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,24) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,25) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,26) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,27) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,28) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,29) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,30) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,31) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,32) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,33) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,34) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,35) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,36) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,37) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,38) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,39) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,40) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,41) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,42) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,43) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,44) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,45) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,46) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,47) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(1)%mat(:,:,48) =  RESHAPE( (/1.0/), (/1, 1/) )

 Irr(2)%name = "A1u"
 Irr(2)%dim = 1
 Irr(2)%nsym = 48
 ABI_MALLOC(Irr(2)%mat, (1,1,48))
 Irr(2)%mat(:,:,1) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,2) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,3) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,4) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,5) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,6) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,7) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,8) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,9) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,10) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,11) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,12) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,13) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,14) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,15) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,16) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,17) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,18) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,19) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,20) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,21) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,22) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,23) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,24) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,25) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,26) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,27) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,28) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,29) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,30) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,31) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,32) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,33) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,34) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,35) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,36) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,37) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,38) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,39) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,40) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,41) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,42) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,43) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,44) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,45) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,46) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,47) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(2)%mat(:,:,48) =  RESHAPE( (/-1.0/), (/1, 1/) )

 Irr(3)%name = "A2g"
 Irr(3)%dim = 1
 Irr(3)%nsym = 48
 ABI_MALLOC(Irr(3)%mat, (1,1,48))
 Irr(3)%mat(:,:,1) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,2) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,3) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,4) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,5) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,6) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,7) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,8) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,9) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,10) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,11) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,12) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,13) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,14) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,15) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,16) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,17) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,18) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,19) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,20) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,21) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,22) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,23) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,24) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,25) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,26) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,27) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,28) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,29) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,30) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,31) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,32) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,33) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,34) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,35) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,36) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,37) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,38) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,39) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,40) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,41) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,42) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,43) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,44) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,45) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,46) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,47) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(3)%mat(:,:,48) =  RESHAPE( (/-1.0/), (/1, 1/) )

 Irr(4)%name = "A2u"
 Irr(4)%dim = 1
 Irr(4)%nsym = 48
 ABI_MALLOC(Irr(4)%mat, (1,1,48))
 Irr(4)%mat(:,:,1) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,2) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,3) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,4) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,5) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,6) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,7) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,8) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,9) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,10) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,11) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,12) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,13) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,14) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,15) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,16) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,17) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,18) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,19) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,20) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,21) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,22) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,23) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,24) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,25) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,26) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,27) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,28) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,29) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,30) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,31) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,32) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,33) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,34) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,35) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,36) =  RESHAPE( (/-1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,37) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,38) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,39) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,40) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,41) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,42) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,43) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,44) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,45) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,46) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,47) =  RESHAPE( (/1.0/), (/1, 1/) )
 Irr(4)%mat(:,:,48) =  RESHAPE( (/1.0/), (/1, 1/) )

 Irr(5)%name = "Eu"
 Irr(5)%dim = 2
 Irr(5)%nsym = 48
 ABI_MALLOC(Irr(5)%mat, (2,2,48))
 Irr(5)%mat(:,:,1) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(5)%mat(:,:,2) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(5)%mat(:,:,3) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(5)%mat(:,:,4) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(5)%mat(:,:,5) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,6) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,7) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,8) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,9) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,10) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,11) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,12) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,13) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(5)%mat(:,:,14) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(5)%mat(:,:,15) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,16) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,17) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,18) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,19) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(5)%mat(:,:,20) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(5)%mat(:,:,21) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,22) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,23) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,24) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,25) =  RESHAPE( (/-1.0, 0.0, 0.0, -1.0/), (/2, 2/) )
 Irr(5)%mat(:,:,26) =  RESHAPE( (/-1.0, 0.0, 0.0, -1.0/), (/2, 2/) )
 Irr(5)%mat(:,:,27) =  RESHAPE( (/-1.0, 0.0, 0.0, -1.0/), (/2, 2/) )
 Irr(5)%mat(:,:,28) =  RESHAPE( (/-1.0, 0.0, 0.0, -1.0/), (/2, 2/) )
 Irr(5)%mat(:,:,29) =  RESHAPE( (/0.5-0.86603*j, 0*j, 0*j, 0.5+0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,30) =  RESHAPE( (/0.5-0.86603*j, 0*j, 0*j, 0.5+0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,31) =  RESHAPE( (/0.5-0.86603*j, 0*j, 0*j, 0.5+0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,32) =  RESHAPE( (/0.5-0.86603*j, 0*j, 0*j, 0.5+0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,33) =  RESHAPE( (/0.5+0.86603*j, 0*j, 0*j, 0.5-0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,34) =  RESHAPE( (/0.5+0.86603*j, 0*j, 0*j, 0.5-0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,35) =  RESHAPE( (/0.5+0.86603*j, 0*j, 0*j, 0.5-0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,36) =  RESHAPE( (/0.5+0.86603*j, 0*j, 0*j, 0.5-0.86603*j/), (/2, 2/) )
 Irr(5)%mat(:,:,37) =  RESHAPE( (/0.0, -1.0, -1.0, 0.0/), (/2, 2/) )
 Irr(5)%mat(:,:,38) =  RESHAPE( (/0.0, -1.0, -1.0, 0.0/), (/2, 2/) )
 Irr(5)%mat(:,:,39) =  RESHAPE( (/0*j, 0.5-0.86603*j, 0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,40) =  RESHAPE( (/0*j, 0.5-0.86603*j, 0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,41) =  RESHAPE( (/0*j, 0.5+0.86603*j, 0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,42) =  RESHAPE( (/0*j, 0.5+0.86603*j, 0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,43) =  RESHAPE( (/0.0, -1.0, -1.0, 0.0/), (/2, 2/) )
 Irr(5)%mat(:,:,44) =  RESHAPE( (/0.0, -1.0, -1.0, 0.0/), (/2, 2/) )
 Irr(5)%mat(:,:,45) =  RESHAPE( (/0*j, 0.5-0.86603*j, 0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,46) =  RESHAPE( (/0*j, 0.5-0.86603*j, 0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,47) =  RESHAPE( (/0*j, 0.5+0.86603*j, 0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(5)%mat(:,:,48) =  RESHAPE( (/0*j, 0.5+0.86603*j, 0.5-0.86603*j, 0*j/), (/2, 2/) )

 Irr(6)%name = "Eg"
 Irr(6)%dim = 2
 Irr(6)%nsym = 48
 ABI_MALLOC(Irr(6)%mat, (2,2,48))
 Irr(6)%mat(:,:,1) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(6)%mat(:,:,2) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(6)%mat(:,:,3) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(6)%mat(:,:,4) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(6)%mat(:,:,5) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,6) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,7) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,8) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,9) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,10) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,11) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,12) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,13) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(6)%mat(:,:,14) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(6)%mat(:,:,15) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,16) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,17) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,18) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,19) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(6)%mat(:,:,20) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(6)%mat(:,:,21) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,22) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,23) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,24) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,25) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(6)%mat(:,:,26) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(6)%mat(:,:,27) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(6)%mat(:,:,28) =  RESHAPE( (/1.0, 0.0, 0.0, 1.0/), (/2, 2/) )
 Irr(6)%mat(:,:,29) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,30) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,31) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,32) =  RESHAPE( (/-0.5+0.86603*j, 0*j, 0*j, -0.5-0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,33) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,34) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,35) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,36) =  RESHAPE( (/-0.5-0.86603*j, 0*j, 0*j, -0.5+0.86603*j/), (/2, 2/) )
 Irr(6)%mat(:,:,37) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(6)%mat(:,:,38) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(6)%mat(:,:,39) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,40) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,41) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,42) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,43) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(6)%mat(:,:,44) =  RESHAPE( (/0.0, 1.0, 1.0, 0.0/), (/2, 2/) )
 Irr(6)%mat(:,:,45) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,46) =  RESHAPE( (/0*j, -0.5+0.86603*j, -0.5-0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,47) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )
 Irr(6)%mat(:,:,48) =  RESHAPE( (/0*j, -0.5-0.86603*j, -0.5+0.86603*j, 0*j/), (/2, 2/) )

 Irr(7)%name = "T2u"
 Irr(7)%dim = 3
 Irr(7)%nsym = 48
 ABI_MALLOC(Irr(7)%mat, (3,3,48))
 Irr(7)%mat(:,:,1) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,2) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,3) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,4) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,5) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,6) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,7) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,8) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,9) =  RESHAPE( (/0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,10) =  RESHAPE( (/0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,11) =  RESHAPE( (/0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,12) =  RESHAPE( (/0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,13) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,14) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,15) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,16) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,17) =  RESHAPE( (/0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,18) =  RESHAPE( (/0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,19) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,20) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,21) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,22) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,23) =  RESHAPE( (/0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,24) =  RESHAPE( (/0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,25) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,26) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,27) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,28) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,29) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,30) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,31) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,32) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,33) =  RESHAPE( (/0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,34) =  RESHAPE( (/0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,35) =  RESHAPE( (/0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,36) =  RESHAPE( (/0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,37) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,38) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,39) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,40) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,41) =  RESHAPE( (/0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,42) =  RESHAPE( (/0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,43) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,44) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,45) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,46) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(7)%mat(:,:,47) =  RESHAPE( (/0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(7)%mat(:,:,48) =  RESHAPE( (/0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )

 Irr(8)%name = "T2g"
 Irr(8)%dim = 3
 Irr(8)%nsym = 48
 ABI_MALLOC(Irr(8)%mat, (3,3,48))
 Irr(8)%mat(:,:,1) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,2) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,3) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,4) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,5) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,6) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,7) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,8) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,9) =  RESHAPE( (/0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,10) =  RESHAPE( (/0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,11) =  RESHAPE( (/0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,12) =  RESHAPE( (/0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,13) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,14) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,15) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,16) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,17) =  RESHAPE( (/0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,18) =  RESHAPE( (/0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,19) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,20) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,21) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,22) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,23) =  RESHAPE( (/0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,24) =  RESHAPE( (/0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,25) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,26) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,27) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,28) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,29) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,30) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,31) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,32) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,33) =  RESHAPE( (/0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,34) =  RESHAPE( (/0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,35) =  RESHAPE( (/0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,36) =  RESHAPE( (/0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,37) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,38) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,39) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,40) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,41) =  RESHAPE( (/0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,42) =  RESHAPE( (/0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,43) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,44) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,45) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,46) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(8)%mat(:,:,47) =  RESHAPE( (/0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(8)%mat(:,:,48) =  RESHAPE( (/0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )

 Irr(9)%name = "T1u"
 Irr(9)%dim = 3
 Irr(9)%nsym = 48
 ABI_MALLOC(Irr(9)%mat, (3,3,48))
 Irr(9)%mat(:,:,1) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,2) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,3) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,4) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,5) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,6) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,7) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,8) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,9) =  RESHAPE( (/0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,10) =  RESHAPE( (/0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,11) =  RESHAPE( (/0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,12) =  RESHAPE( (/0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,13) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,14) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,15) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,16) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,17) =  RESHAPE( (/0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,18) =  RESHAPE( (/0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,19) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,20) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,21) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,22) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,23) =  RESHAPE( (/0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,24) =  RESHAPE( (/0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,25) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,26) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,27) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,28) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,29) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,30) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,31) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,32) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,33) =  RESHAPE( (/0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,34) =  RESHAPE( (/0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,35) =  RESHAPE( (/0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,36) =  RESHAPE( (/0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,37) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,38) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,39) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,40) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,41) =  RESHAPE( (/0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,42) =  RESHAPE( (/0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,43) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,44) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,45) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,46) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(9)%mat(:,:,47) =  RESHAPE( (/0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(9)%mat(:,:,48) =  RESHAPE( (/0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )

 Irr(10)%name = "T1g"
 Irr(10)%dim = 3
 Irr(10)%nsym = 48
 ABI_MALLOC(Irr(10)%mat, (3,3,48))
 Irr(10)%mat(:,:,1) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,2) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,3) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,4) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,5) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,6) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,7) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,8) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,9) =  RESHAPE( (/0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,10) =  RESHAPE( (/0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,11) =  RESHAPE( (/0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,12) =  RESHAPE( (/0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,13) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,14) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,15) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,16) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,17) =  RESHAPE( (/0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,18) =  RESHAPE( (/0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,19) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,20) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,21) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,22) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,23) =  RESHAPE( (/0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,24) =  RESHAPE( (/0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,25) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,26) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,27) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,28) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,29) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,30) =  RESHAPE( (/0.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,31) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,32) =  RESHAPE( (/0.0, -1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,33) =  RESHAPE( (/0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,34) =  RESHAPE( (/0.0, 0.0, 1.0, -1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,35) =  RESHAPE( (/0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,36) =  RESHAPE( (/0.0, 0.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,37) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,38) =  RESHAPE( (/-1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,39) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,40) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,41) =  RESHAPE( (/0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,42) =  RESHAPE( (/0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,43) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,44) =  RESHAPE( (/1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,45) =  RESHAPE( (/0.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,46) =  RESHAPE( (/0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0/), (/3, 3/) )
 Irr(10)%mat(:,:,47) =  RESHAPE( (/0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )
 Irr(10)%mat(:,:,48) =  RESHAPE( (/0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0/), (/3, 3/) )

 RETURN
  if (.FALSE.) write(std_out,*) j
 end subroutine ptg_Oh 
!!***

end module m_ptg_Oh
!!***
