# -*- Autoconf -*-
#
# Copyright (C) 2005-2020 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-options on 2020/05/17 03:54:46 +0000

#
# Command-line options for the "configure" script
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-options
# script. If you try to edit it, your changes will systematically be
# overwritten.
#



# ABI_OPTIONS_DEFINE()
# --------------------
#
# Declares command-line arguments for the "configure" script.
#
AC_DEFUN([ABI_OPTIONS_DEFINE],[
  # Count use of deprecated options
  abi_opt_deprecated_count=0
  abi_opt_deprecated_used=""


  #
  # --enable arguments
  #

  AC_ARG_ENABLE(avx-safe-mode,
    AC_HELP_STRING([--enable-avx-safe-mode],
      [Disable vectorization in problematic procedures (default: no)]),
    [abi_avx_safe_mode_enable="${enableval}"; abi_avx_safe_mode_init="yon"],
    [abi_avx_safe_mode_enable="no"; abi_avx_safe_mode_init="def"])
  AC_SUBST(enable_avx_safe_mode)
  AC_SUBST(abi_avx_safe_mode_enable)

  AC_ARG_ENABLE(bse-unpacked,
    AC_HELP_STRING([--enable-bse-unpacked],
      [Activate Bethe-Salpeter unpacking (default: no)]),
    [abi_bse_unpacked_enable="${enableval}"; abi_bse_unpacked_init="yon"],
    [abi_bse_unpacked_enable="no"; abi_bse_unpacked_init="def"])
  AC_SUBST(enable_bse_unpacked)
  AC_SUBST(abi_bse_unpacked_enable)

  AC_ARG_ENABLE(cclock,
    AC_HELP_STRING([--enable-cclock],
      [Use C clock for timings (default: no)]),
    [abi_cclock_enable="${enableval}"; abi_cclock_init="yon"],
    [abi_cclock_enable="no"; abi_cclock_init="def"])
  AC_SUBST(enable_cclock)
  AC_SUBST(abi_cclock_enable)

  AC_ARG_ENABLE(crpa-optim,
    AC_HELP_STRING([--enable-crpa-optim],
      [Enable optimize cRPA calculations for ifort <= 17.0 (default: no)]),
    [abi_crpa_optim_enable="${enableval}"; abi_crpa_optim_init="yon"],
    [abi_crpa_optim_enable="no"; abi_crpa_optim_init="def"])
  AC_SUBST(enable_crpa_optim)
  AC_SUBST(abi_crpa_optim_enable)

  AC_ARG_ENABLE(exports,
    AC_HELP_STRING([--enable-exports],
      [Activate build of exported libraries (default: no)]),
    [abi_exports_enable="${enableval}"; abi_exports_init="yon"],
    [abi_exports_enable="no"; abi_exports_init="def"])
  AC_SUBST(enable_exports)
  AC_SUBST(abi_exports_enable)

  AC_ARG_ENABLE(fc-wrapper,
    AC_HELP_STRING([--enable-fc-wrapper],
      [Wrap Fortran compiler calls (default: no)]),
    [abi_fc_wrapper_enable="${enableval}"; abi_fc_wrapper_init="yon"],
    [abi_fc_wrapper_enable="no"; abi_fc_wrapper_init="def"])
  AC_SUBST(enable_fc_wrapper)
  AC_SUBST(abi_fc_wrapper_enable)

  AC_ARG_ENABLE(gw-dpc,
    AC_HELP_STRING([--enable-gw-dpc],
      [Activate double-precision GW calculations (default: no)]),
    [abi_gw_dpc_enable="${enableval}"; abi_gw_dpc_init="yon"],
    [abi_gw_dpc_enable="no"; abi_gw_dpc_init="def"])
  AC_SUBST(enable_gw_dpc)
  AC_SUBST(abi_gw_dpc_enable)

  AC_ARG_ENABLE(hints,
    AC_HELP_STRING([--enable-hints],
      [Automatically adjust build flags to the current configuration (default: yes)]),
    [abi_hints_enable="${enableval}"; abi_hints_init="yon"],
    [abi_hints_enable="yes"; abi_hints_init="def"])
  AC_SUBST(enable_hints)
  AC_SUBST(abi_hints_enable)

  AC_ARG_ENABLE(libtetra,
    AC_HELP_STRING([--enable-libtetra],
      [Activate internal support for libtetra(hedron) in ABINIT (default: yes)]),
    [abi_libtetra_enable="${enableval}"; abi_libtetra_init="yon"],
    [abi_libtetra_enable="yes"; abi_libtetra_init="def"])
  AC_SUBST(enable_libtetra)
  AC_SUBST(abi_libtetra_enable)

  AC_ARG_ENABLE(lotf,
    AC_HELP_STRING([--enable-lotf],
      [Activate LOTF functionality (UNMAINTAINED) (default: no)]),
    [abi_lotf_enable="${enableval}"; abi_lotf_init="yon"],
    [abi_lotf_enable="no"; abi_lotf_init="def"])
  AC_SUBST(enable_lotf)
  AC_SUBST(abi_lotf_enable)

  AC_ARG_ENABLE(memory-profiling,
    AC_HELP_STRING([--enable-memory-profiling],
      [Enable memory profiling (default: no)]),
    [abi_memory_profiling_enable="${enableval}"; abi_memory_profiling_init="yon"],
    [abi_memory_profiling_enable="no"; abi_memory_profiling_init="def"])
  AC_SUBST(enable_memory_profiling)
  AC_SUBST(abi_memory_profiling_enable)

  AC_ARG_ENABLE(mpi-inplace,
    AC_HELP_STRING([--enable-mpi-inplace],
      [Activate support for MPI_IN_PLACE (default: no)]),
    [abi_mpi_inplace_enable="${enableval}"; abi_mpi_inplace_init="yon"],
    [abi_mpi_inplace_enable="no"; abi_mpi_inplace_init="def"])
  AC_SUBST(enable_mpi_inplace)
  AC_SUBST(abi_mpi_inplace_enable)

  AC_ARG_ENABLE(mpi-io,
    AC_HELP_STRING([--enable-mpi-io],
      [Enable MPI I/O (default: auto)]),
    [abi_mpi_io_enable="${enableval}"; abi_mpi_io_init="yon"],
    [abi_mpi_io_enable="auto"; abi_mpi_io_init="def"])
  AC_SUBST(enable_mpi_io)
  AC_SUBST(abi_mpi_io_enable)

  AC_ARG_ENABLE(mpi-io-default,
    AC_HELP_STRING([--enable-mpi-io-default],
      [Use MPI I/O as default I/O library (maintainer-only option) (default: no)]),
    [abi_mpi_io_default_enable="${enableval}"; abi_mpi_io_default_init="yon"],
    [abi_mpi_io_default_enable="no"; abi_mpi_io_default_init="def"])
  AC_SUBST(enable_mpi_io_default)
  AC_SUBST(abi_mpi_io_default_enable)

  AC_ARG_ENABLE(netcdf-default,
    AC_HELP_STRING([--enable-netcdf-default],
      [Use NetCDF as default I/O library (maintainer-only option) (default: no)]),
    [abi_netcdf_default_enable="${enableval}"; abi_netcdf_default_init="yon"],
    [abi_netcdf_default_enable="no"; abi_netcdf_default_init="def"])
  AC_SUBST(enable_netcdf_default)
  AC_SUBST(abi_netcdf_default_enable)

  AC_ARG_ENABLE(openmp,
    AC_HELP_STRING([--enable-openmp],
      [Activate support for OpenMP (default: no)]),
    [abi_openmp_enable="${enableval}"; abi_openmp_init="yon"],
    [abi_openmp_enable="no"; abi_openmp_init="def"])
  AC_SUBST(enable_openmp)
  AC_SUBST(abi_openmp_enable)

  AC_ARG_ENABLE(python-invocation,
    AC_HELP_STRING([--enable-python-invocation],
      [Activate possibility to call python scripts externally by invoking a python interpreter (default: no)]),
    [abi_python_invocation_enable="${enableval}"; abi_python_invocation_init="yon"],
    [abi_python_invocation_enable="no"; abi_python_invocation_init="def"])
  AC_SUBST(enable_python_invocation)
  AC_SUBST(abi_python_invocation_enable)

  AC_ARG_ENABLE(source-debug,
    AC_HELP_STRING([--enable-source-debug],
      [Build debugging instructions present in the source code (default: no)]),
    [abi_source_debug_enable="${enableval}"; abi_source_debug_init="yon"],
    [abi_source_debug_enable="no"; abi_source_debug_init="def"])
  AC_SUBST(enable_source_debug)
  AC_SUBST(abi_source_debug_enable)

  AC_ARG_ENABLE(stdin,
    AC_HELP_STRING([--enable-stdin],
      [Tell ABINIT to read file lists from standard input (default: yes)]),
    [abi_stdin_enable="${enableval}"; abi_stdin_init="yon"],
    [abi_stdin_enable="yes"; abi_stdin_init="def"])
  AC_SUBST(enable_stdin)
  AC_SUBST(abi_stdin_enable)

  AC_ARG_ENABLE(timer,
    AC_HELP_STRING([--enable-timer],
      [Activate support for the internal ABINIT timer (default: yes)]),
    [abi_timer_enable="${enableval}"; abi_timer_init="yon"],
    [abi_timer_enable="yes"; abi_timer_init="def"])
  AC_SUBST(enable_timer)
  AC_SUBST(abi_timer_enable)

  AC_ARG_ENABLE(triqs-v1-4,
    AC_HELP_STRING([--enable-triqs-v1-4],
      [Activate internal support for TRIQS 1.4 (default: no)]),
    [abi_triqs_v1_4_enable="${enableval}"; abi_triqs_v1_4_init="yon"],
    [abi_triqs_v1_4_enable="no"; abi_triqs_v1_4_init="def"])
  AC_SUBST(enable_triqs_v1_4)
  AC_SUBST(abi_triqs_v1_4_enable)

  AC_ARG_ENABLE(triqs-v2-0,
    AC_HELP_STRING([--enable-triqs-v2-0],
      [Activate internal support for TRIQS 2.0 (This option is dominant over the others versions) (default: no)]),
    [abi_triqs_v2_0_enable="${enableval}"; abi_triqs_v2_0_init="yon"],
    [abi_triqs_v2_0_enable="no"; abi_triqs_v2_0_init="def"])
  AC_SUBST(enable_triqs_v2_0)
  AC_SUBST(abi_triqs_v2_0_enable)

  AC_ARG_ENABLE(zdot-bugfix,
    AC_HELP_STRING([--enable-zdot-bugfix],
      [Activate workaround for bugged ZDOTC and ZDOTU (default: no)]),
    [abi_zdot_bugfix_enable="${enableval}"; abi_zdot_bugfix_init="yon"],
    [abi_zdot_bugfix_enable="no"; abi_zdot_bugfix_init="def"])
  AC_SUBST(enable_zdot_bugfix)
  AC_SUBST(abi_zdot_bugfix_enable)

  #
  # --with arguments
  #

  AC_ARG_WITH(config_file,
    AC_HELP_STRING([--with-config-file],
      [Specify config file to read options from (default: '')]),
    [ abi_config_file="${withval}"
      case "${withval}" in
        no|yes)
          abi_config_file_init="yon"
          ;;
        *)
          abi_config_file_init="kwd"
          ;;
      esac],
    [ abi_config_file_init="def"; abi_config_file=""])
  AC_SUBST(with_config_file)

  AC_ARG_WITH(debug_flavor,
    AC_HELP_STRING([--with-debug-flavor],
      [Set debug level (default: 'basic')]),
    [ abi_debug_flavor="${withval}"
      case "${withval}" in
        no|yes)
          abi_debug_flavor_init="yon"
          ;;
        *)
          abi_debug_flavor_init="kwd"
          ;;
      esac],
    [ abi_debug_flavor_init="def"; abi_debug_flavor="basic"])
  AC_SUBST(with_debug_flavor)

  AC_ARG_WITH(fallbacks,
    AC_HELP_STRING([--with-fallbacks],
      [Installation prefix of the ABINIT Fallbacks (default: '')]),
    [ abi_fallbacks="${withval}"
      case "${withval}" in
        no|yes)
          abi_fallbacks_init="yon"
          ;;
        *)
          abi_fallbacks_init="dir"
          ;;
      esac],
    [ abi_fallbacks_init="def"; abi_fallbacks=""])
  AC_SUBST(with_fallbacks)

  AC_ARG_WITH(fc_vendor,
    AC_HELP_STRING([--with-fc-vendor],
      [Fortran compiler vendor to be used by the build system (default: '')]),
    [ abi_fc_vendor="${withval}"
      case "${withval}" in
        no|yes)
          abi_fc_vendor_init="yon"
          ;;
        *)
          abi_fc_vendor_init="kwd"
          ;;
      esac],
    [ abi_fc_vendor_init="def"; abi_fc_vendor=""])
  AC_SUBST(with_fc_vendor)

  AC_ARG_WITH(fc_version,
    AC_HELP_STRING([--with-fc-version],
      [Fortran compiler version to be used by the build system (default: '')]),
    [ abi_fc_version="${withval}"
      case "${withval}" in
        no|yes)
          abi_fc_version_init="yon"
          ;;
        *)
          abi_fc_version_init="kwd"
          ;;
      esac],
    [ abi_fc_version_init="def"; abi_fc_version=""])
  AC_SUBST(with_fc_version)

  AC_ARG_WITH(libxml2,
    AC_HELP_STRING([--with-libxml2],
      [Enable support for the C XML library (default: '')]),
    [ abi_libxml2="${withval}"
      case "${withval}" in
        no|yes)
          abi_libxml2_init="yon"
          ;;
        *)
          abi_libxml2_init="dir"
          ;;
      esac],
    [ abi_libxml2_init="def"; abi_libxml2=""])
  AC_SUBST(with_libxml2)

  AC_ARG_WITH(mpi_level,
    AC_HELP_STRING([--with-mpi-level],
      [level of the MPI standard to use (default: '2')]),
    [ abi_mpi_level="${withval}"
      case "${withval}" in
        no|yes)
          abi_mpi_level_init="yon"
          ;;
        *)
          abi_mpi_level_init="kwd"
          ;;
      esac],
    [ abi_mpi_level_init="def"; abi_mpi_level="2"])
  AC_SUBST(with_mpi_level)

  AC_ARG_WITH(optim_flavor,
    AC_HELP_STRING([--with-optim-flavor],
      [Set optimization level (default: 'standard')]),
    [ abi_optim_flavor="${withval}"
      case "${withval}" in
        no|yes)
          abi_optim_flavor_init="yon"
          ;;
        *)
          abi_optim_flavor_init="kwd"
          ;;
      esac],
    [ abi_optim_flavor_init="def"; abi_optim_flavor="standard"])
  AC_SUBST(with_optim_flavor)
]) # ABI_OPTIONS_DEFINE



# ABI_OPTIONS_SETUP()
# -------------------
#
# Sets the default values of command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_SETUP],[

  #
  # --enable arguments
  #

  if test "${enable_avx_safe_mode}" = ""; then
    abi_avx_safe_mode_enable="no"
  fi
  if test "${enable_bse_unpacked}" = ""; then
    abi_bse_unpacked_enable="no"
  fi
  if test "${enable_cclock}" = ""; then
    abi_cclock_enable="no"
  fi
  if test "${enable_crpa_optim}" = ""; then
    abi_crpa_optim_enable="no"
  fi
  if test "${enable_exports}" = ""; then
    abi_exports_enable="no"
  fi
  if test "${enable_fc_wrapper}" = ""; then
    abi_fc_wrapper_enable="no"
  fi
  if test "${enable_gw_dpc}" = ""; then
    abi_gw_dpc_enable="no"
  fi
  if test "${enable_hints}" = ""; then
    abi_hints_enable="yes"
  fi
  if test "${enable_libtetra}" = ""; then
    abi_libtetra_enable="yes"
  fi
  if test "${enable_lotf}" = ""; then
    abi_lotf_enable="no"
  fi
  if test "${enable_memory_profiling}" = ""; then
    abi_memory_profiling_enable="no"
  fi
  if test "${enable_mpi_inplace}" = ""; then
    abi_mpi_inplace_enable="no"
  fi
  if test "${enable_mpi_io}" = ""; then
    abi_mpi_io_enable="auto"
  fi
  if test "${enable_mpi_io_default}" = ""; then
    abi_mpi_io_default_enable="no"
  fi
  if test "${enable_netcdf_default}" = ""; then
    abi_netcdf_default_enable="no"
  fi
  if test "${enable_openmp}" = ""; then
    abi_openmp_enable="no"
  fi
  if test "${enable_python_invocation}" = ""; then
    abi_python_invocation_enable="no"
  fi
  if test "${enable_source_debug}" = ""; then
    abi_source_debug_enable="no"
  fi
  if test "${enable_stdin}" = ""; then
    abi_stdin_enable="yes"
  fi
  if test "${enable_timer}" = ""; then
    abi_timer_enable="yes"
  fi
  if test "${enable_triqs_v1_4}" = ""; then
    abi_triqs_v1_4_enable="no"
  fi
  if test "${enable_triqs_v2_0}" = ""; then
    abi_triqs_v2_0_enable="no"
  fi
  if test "${enable_zdot_bugfix}" = ""; then
    abi_zdot_bugfix_enable="no"
  fi

  #
  # --with arguments
  #

  if test "${with_config_file}" = "no"; then
    abi_config_file=""
  fi
  if test "${with_debug_flavor}" = ""; then
    abi_debug_flavor="basic"
  fi
  if test "${with_debug_flavor}" = "no"; then
    abi_debug_flavor="none"
  fi
  if test "${with_fallbacks}" = "no"; then
    abi_fallbacks=""
  fi
  if test "${with_fc_vendor}" = "no"; then
    abi_fc_vendor="generic"
  fi
  if test "${with_fc_version}" = "no"; then
    abi_fc_version="0.0"
  fi
  if test "${with_libxml2}" = "no"; then
    abi_libxml2=""
  fi
  if test "${with_mpi_level}" = ""; then
    abi_mpi_level="2"
  fi
  if test "${with_mpi_level}" = "no"; then
    abi_mpi_level=""
  fi
  if test "${with_optim_flavor}" = ""; then
    abi_optim_flavor="standard"
  fi
  if test "${with_optim_flavor}" = "no"; then
    abi_optim_flavor="none"
  fi
]) # ABI_OPTIONS_SETUP



# ABI_OPTIONS_BACKUP()
# --------------------
#
# Saves all command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_BACKUP],[

  #
  # --enable arguments
  #
  cmd_enable_avx_safe_mode="${enable_avx_safe_mode}"
  cmd_enable_bse_unpacked="${enable_bse_unpacked}"
  cmd_enable_cclock="${enable_cclock}"
  cmd_enable_crpa_optim="${enable_crpa_optim}"
  cmd_enable_exports="${enable_exports}"
  cmd_enable_fc_wrapper="${enable_fc_wrapper}"
  cmd_enable_gw_dpc="${enable_gw_dpc}"
  cmd_enable_hints="${enable_hints}"
  cmd_enable_libtetra="${enable_libtetra}"
  cmd_enable_lotf="${enable_lotf}"
  cmd_enable_memory_profiling="${enable_memory_profiling}"
  cmd_enable_mpi_inplace="${enable_mpi_inplace}"
  cmd_enable_mpi_io="${enable_mpi_io}"
  cmd_enable_mpi_io_default="${enable_mpi_io_default}"
  cmd_enable_netcdf_default="${enable_netcdf_default}"
  cmd_enable_openmp="${enable_openmp}"
  cmd_enable_python_invocation="${enable_python_invocation}"
  cmd_enable_source_debug="${enable_source_debug}"
  cmd_enable_stdin="${enable_stdin}"
  cmd_enable_timer="${enable_timer}"
  cmd_enable_triqs_v1_4="${enable_triqs_v1_4}"
  cmd_enable_triqs_v2_0="${enable_triqs_v2_0}"
  cmd_enable_zdot_bugfix="${enable_zdot_bugfix}"

  #
  # --with arguments
  #
  cmd_with_config_file="${with_config_file}"
  cmd_with_debug_flavor="${with_debug_flavor}"
  cmd_with_fallbacks="${with_fallbacks}"
  cmd_with_fc_vendor="${with_fc_vendor}"
  cmd_with_fc_version="${with_fc_version}"
  cmd_with_libxml2="${with_libxml2}"
  cmd_with_mpi_level="${with_mpi_level}"
  cmd_with_optim_flavor="${with_optim_flavor}"
  cmd_with_abinit_common="${with_abinit_common}"
  cmd_with_bigdft="${with_bigdft}"
  cmd_with_fft="${with_fft}"
  cmd_with_fft_flavor="${with_fft_flavor}"
  cmd_with_fftw3="${with_fftw3}"
  cmd_with_gpu="${with_gpu}"
  cmd_with_gpu_flavor="${with_gpu_flavor}"
  cmd_with_hdf5="${with_hdf5}"
  cmd_with_levmar="${with_levmar}"
  cmd_with_libpaw="${with_libpaw}"
  cmd_with_libpsml="${with_libpsml}"
  cmd_with_libxc="${with_libxc}"
  cmd_with_linalg="${with_linalg}"
  cmd_with_linalg_flavor="${with_linalg_flavor}"
  cmd_with_mpi="${with_mpi}"
  cmd_with_mpi_flavor="${with_mpi_flavor}"
  cmd_with_netcdf="${with_netcdf}"
  cmd_with_netcdf_fortran="${with_netcdf_fortran}"
  cmd_with_papi="${with_papi}"
  cmd_with_pfft="${with_pfft}"
  cmd_with_triqs="${with_triqs}"
  cmd_with_wannier90="${with_wannier90}"
  cmd_with_xmlf90="${with_xmlf90}"

  #
  # Prefix
  #
  if test "${prefix}" != "NONE"; then
    cmd_prefix="${prefix}"
  fi
]) # ABI_OPTIONS_BACKUP



# ABI_OPTIONS_CFG_TRANSFER()
# --------------------------
#
# Transfer options from the config file to internal variables.
#
AC_DEFUN([ABI_OPTIONS_CFG_TRANSFER],[

  #
  # --enable arguments
  #

  if test "${enable_avx_safe_mode}" != ""; then
    abi_avx_safe_mode_enable="${enable_avx_safe_mode}"
  fi

  if test "${enable_bse_unpacked}" != ""; then
    abi_bse_unpacked_enable="${enable_bse_unpacked}"
  fi

  if test "${enable_cclock}" != ""; then
    abi_cclock_enable="${enable_cclock}"
  fi

  if test "${enable_crpa_optim}" != ""; then
    abi_crpa_optim_enable="${enable_crpa_optim}"
  fi

  if test "${enable_exports}" != ""; then
    abi_exports_enable="${enable_exports}"
  fi

  if test "${enable_fc_wrapper}" != ""; then
    abi_fc_wrapper_enable="${enable_fc_wrapper}"
  fi

  if test "${enable_gw_dpc}" != ""; then
    abi_gw_dpc_enable="${enable_gw_dpc}"
  fi

  if test "${enable_hints}" != ""; then
    abi_hints_enable="${enable_hints}"
  fi

  if test "${enable_libtetra}" != ""; then
    abi_libtetra_enable="${enable_libtetra}"
  fi

  if test "${enable_lotf}" != ""; then
    abi_lotf_enable="${enable_lotf}"
  fi

  if test "${enable_memory_profiling}" != ""; then
    abi_memory_profiling_enable="${enable_memory_profiling}"
  fi

  if test "${enable_mpi_inplace}" != ""; then
    abi_mpi_inplace_enable="${enable_mpi_inplace}"
  fi

  if test "${enable_mpi_io}" != ""; then
    abi_mpi_io_enable="${enable_mpi_io}"
  fi

  if test "${enable_mpi_io_default}" != ""; then
    abi_mpi_io_default_enable="${enable_mpi_io_default}"
  fi

  if test "${enable_netcdf_default}" != ""; then
    abi_netcdf_default_enable="${enable_netcdf_default}"
  fi

  if test "${enable_openmp}" != ""; then
    abi_openmp_enable="${enable_openmp}"
  fi

  if test "${enable_python_invocation}" != ""; then
    abi_python_invocation_enable="${enable_python_invocation}"
  fi

  if test "${enable_source_debug}" != ""; then
    abi_source_debug_enable="${enable_source_debug}"
  fi

  if test "${enable_stdin}" != ""; then
    abi_stdin_enable="${enable_stdin}"
  fi

  if test "${enable_timer}" != ""; then
    abi_timer_enable="${enable_timer}"
  fi

  if test "${enable_triqs_v1_4}" != ""; then
    abi_triqs_v1_4_enable="${enable_triqs_v1_4}"
  fi

  if test "${enable_triqs_v2_0}" != ""; then
    abi_triqs_v2_0_enable="${enable_triqs_v2_0}"
  fi

  if test "${enable_zdot_bugfix}" != ""; then
    abi_zdot_bugfix_enable="${enable_zdot_bugfix}"
  fi

  #
  # --with arguments
  #

  if test "${with_config_file}" != ""; then
    abi_config_file="${with_config_file}"
  fi

  if test "${with_debug_flavor}" != ""; then
    abi_debug_flavor="${with_debug_flavor}"
  fi

  if test "${with_fallbacks}" != ""; then
    abi_fallbacks="${with_fallbacks}"
  fi

  if test "${with_fc_vendor}" != ""; then
    abi_fc_vendor="${with_fc_vendor}"
  fi

  if test "${with_fc_version}" != ""; then
    abi_fc_version="${with_fc_version}"
  fi

  if test "${with_libxml2}" != ""; then
    abi_libxml2="${with_libxml2}"
  fi

  if test "${with_mpi_level}" != ""; then
    abi_mpi_level="${with_mpi_level}"
  fi

  if test "${with_optim_flavor}" != ""; then
    abi_optim_flavor="${with_optim_flavor}"
  fi

]) # ABI_OPTIONS_CFG_TRANSFER



# ABI_OPTIONS_RECALL()
# --------------------
#
# Restores all previously-saved command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_RECALL],[

  #
  # --enable arguments
  #
  if test "${cmd_enable_avx_safe_mode}" != ""; then
    abi_avx_safe_mode_enable="${cmd_enable_avx_safe_mode}"
  fi
  if test "${cmd_enable_bse_unpacked}" != ""; then
    abi_bse_unpacked_enable="${cmd_enable_bse_unpacked}"
  fi
  if test "${cmd_enable_cclock}" != ""; then
    abi_cclock_enable="${cmd_enable_cclock}"
  fi
  if test "${cmd_enable_crpa_optim}" != ""; then
    abi_crpa_optim_enable="${cmd_enable_crpa_optim}"
  fi
  if test "${cmd_enable_exports}" != ""; then
    abi_exports_enable="${cmd_enable_exports}"
  fi
  if test "${cmd_enable_fc_wrapper}" != ""; then
    abi_fc_wrapper_enable="${cmd_enable_fc_wrapper}"
  fi
  if test "${cmd_enable_gw_dpc}" != ""; then
    abi_gw_dpc_enable="${cmd_enable_gw_dpc}"
  fi
  if test "${cmd_enable_hints}" != ""; then
    abi_hints_enable="${cmd_enable_hints}"
  fi
  if test "${cmd_enable_libtetra}" != ""; then
    abi_libtetra_enable="${cmd_enable_libtetra}"
  fi
  if test "${cmd_enable_lotf}" != ""; then
    abi_lotf_enable="${cmd_enable_lotf}"
  fi
  if test "${cmd_enable_memory_profiling}" != ""; then
    abi_memory_profiling_enable="${cmd_enable_memory_profiling}"
  fi
  if test "${cmd_enable_mpi_inplace}" != ""; then
    abi_mpi_inplace_enable="${cmd_enable_mpi_inplace}"
  fi
  if test "${cmd_enable_mpi_io}" != ""; then
    abi_mpi_io_enable="${cmd_enable_mpi_io}"
  fi
  if test "${cmd_enable_mpi_io_default}" != ""; then
    abi_mpi_io_default_enable="${cmd_enable_mpi_io_default}"
  fi
  if test "${cmd_enable_netcdf_default}" != ""; then
    abi_netcdf_default_enable="${cmd_enable_netcdf_default}"
  fi
  if test "${cmd_enable_openmp}" != ""; then
    abi_openmp_enable="${cmd_enable_openmp}"
  fi
  if test "${cmd_enable_python_invocation}" != ""; then
    abi_python_invocation_enable="${cmd_enable_python_invocation}"
  fi
  if test "${cmd_enable_source_debug}" != ""; then
    abi_source_debug_enable="${cmd_enable_source_debug}"
  fi
  if test "${cmd_enable_stdin}" != ""; then
    abi_stdin_enable="${cmd_enable_stdin}"
  fi
  if test "${cmd_enable_timer}" != ""; then
    abi_timer_enable="${cmd_enable_timer}"
  fi
  if test "${cmd_enable_triqs_v1_4}" != ""; then
    abi_triqs_v1_4_enable="${cmd_enable_triqs_v1_4}"
  fi
  if test "${cmd_enable_triqs_v2_0}" != ""; then
    abi_triqs_v2_0_enable="${cmd_enable_triqs_v2_0}"
  fi
  if test "${cmd_enable_zdot_bugfix}" != ""; then
    abi_zdot_bugfix_enable="${cmd_enable_zdot_bugfix}"
  fi

  #
  # --with arguments
  #
  if test "${cmd_with_config_file}" != ""; then
    with_config_file="${cmd_with_config_file}"
  fi
  if test "${cmd_with_debug_flavor}" != ""; then
    with_debug_flavor="${cmd_with_debug_flavor}"
  fi
  if test "${cmd_with_fallbacks}" != ""; then
    with_fallbacks="${cmd_with_fallbacks}"
  fi
  if test "${cmd_with_fc_vendor}" != ""; then
    with_fc_vendor="${cmd_with_fc_vendor}"
  fi
  if test "${cmd_with_fc_version}" != ""; then
    with_fc_version="${cmd_with_fc_version}"
  fi
  if test "${cmd_with_libxml2}" != ""; then
    with_libxml2="${cmd_with_libxml2}"
  fi
  if test "${cmd_with_mpi_level}" != ""; then
    with_mpi_level="${cmd_with_mpi_level}"
  fi
  if test "${cmd_with_optim_flavor}" != ""; then
    with_optim_flavor="${cmd_with_optim_flavor}"
  fi
  if test "${cmd_with_abinit_common}" != ""; then
    with_abinit_common="${cmd_with_abinit_common}"
  fi
  if test "${cmd_with_bigdft}" != ""; then
    with_bigdft="${cmd_with_bigdft}"
  fi
  if test "${cmd_with_fft}" != ""; then
    with_fft="${cmd_with_fft}"
  fi
  if test "${cmd_with_fft_flavor}" != ""; then
    with_fft_flavor="${cmd_with_fft_flavor}"
  fi
  if test "${cmd_with_fftw3}" != ""; then
    with_fftw3="${cmd_with_fftw3}"
  fi
  if test "${cmd_with_gpu}" != ""; then
    with_gpu="${cmd_with_gpu}"
  fi
  if test "${cmd_with_gpu_flavor}" != ""; then
    with_gpu_flavor="${cmd_with_gpu_flavor}"
  fi
  if test "${cmd_with_hdf5}" != ""; then
    with_hdf5="${cmd_with_hdf5}"
  fi
  if test "${cmd_with_levmar}" != ""; then
    with_levmar="${cmd_with_levmar}"
  fi
  if test "${cmd_with_libpaw}" != ""; then
    with_libpaw="${cmd_with_libpaw}"
  fi
  if test "${cmd_with_libpsml}" != ""; then
    with_libpsml="${cmd_with_libpsml}"
  fi
  if test "${cmd_with_libxc}" != ""; then
    with_libxc="${cmd_with_libxc}"
  fi
  if test "${cmd_with_linalg}" != ""; then
    with_linalg="${cmd_with_linalg}"
  fi
  if test "${cmd_with_linalg_flavor}" != ""; then
    with_linalg_flavor="${cmd_with_linalg_flavor}"
  fi
  if test "${cmd_with_mpi}" != ""; then
    with_mpi="${cmd_with_mpi}"
  fi
  if test "${cmd_with_mpi_flavor}" != ""; then
    with_mpi_flavor="${cmd_with_mpi_flavor}"
  fi
  if test "${cmd_with_netcdf}" != ""; then
    with_netcdf="${cmd_with_netcdf}"
  fi
  if test "${cmd_with_netcdf_fortran}" != ""; then
    with_netcdf_fortran="${cmd_with_netcdf_fortran}"
  fi
  if test "${cmd_with_papi}" != ""; then
    with_papi="${cmd_with_papi}"
  fi
  if test "${cmd_with_pfft}" != ""; then
    with_pfft="${cmd_with_pfft}"
  fi
  if test "${cmd_with_triqs}" != ""; then
    with_triqs="${cmd_with_triqs}"
  fi
  if test "${cmd_with_wannier90}" != ""; then
    with_wannier90="${cmd_with_wannier90}"
  fi
  if test "${cmd_with_xmlf90}" != ""; then
    with_xmlf90="${cmd_with_xmlf90}"
  fi

  #
  # Prefix
  #
  if test "${cmd_prefix}" != ""; then
    prefix="${cmd_prefix}"
  fi
]) # ABI_OPTIONS_RECALL



# ABI_INFO_OPTIONS_CHANGED()
# --------------------------
#
# Display changes of user interface between versions and warns about
# obsolete uses.
#
AC_DEFUN([ABI_INFO_OPTIONS_CHANGED],[
  AC_MSG_NOTICE([])
  AC_MSG_NOTICE([reporting user interface changes:])
  AC_MSG_NOTICE([])

  # Removed --enable-64bit-flags option
  AC_MSG_NOTICE([  * removed option --enable-64bit-flags])
  if test "${enable_64bit_flags}" != ""; then
    AC_MSG_ERROR([removed option --enable-64bit-flags has been used])
  fi

  # Removed --enable-config-file option
  AC_MSG_NOTICE([  * removed option --enable-config-file])
  if test "${enable_config_file}" != ""; then
    AC_MSG_ERROR([removed option --enable-config-file has been used])
  fi

  # Removed --enable-connectors option
  AC_MSG_NOTICE([  * removed option --enable-connectors])
  if test "${enable_connectors}" != ""; then
    AC_MSG_ERROR([removed option --enable-connectors has been used])
  fi

  # Removed --enable-debug option
  AC_MSG_NOTICE([  * removed option --enable-debug])
  AC_MSG_NOTICE([    >>> use --with-debug-flavor instead])
  if test "${enable_debug}" != ""; then
    AC_MSG_ERROR([removed option --enable-debug has been used])
  fi

  # Removed --enable-fallbacks option
  AC_MSG_NOTICE([  * removed option --enable-fallbacks])
  AC_MSG_NOTICE([    >>> use --with-fallbacks instead])
  if test "${enable_fallbacks}" != ""; then
    AC_MSG_ERROR([removed option --enable-fallbacks has been used])
  fi

  # Removed --enable-gpu option
  AC_MSG_NOTICE([  * removed option --enable-gpu])
  AC_MSG_NOTICE([    >>> use --with-gpu instead])
  if test "${enable_gpu}" != ""; then
    AC_MSG_ERROR([removed option --enable-gpu has been used])
  fi

  # Removed --enable-macroave option
  AC_MSG_NOTICE([  * removed option --enable-macroave])
  if test "${enable_macroave}" != ""; then
    AC_MSG_ERROR([removed option --enable-macroave has been used])
  fi

  # Removed --enable-mpi option
  AC_MSG_NOTICE([  * removed option --enable-mpi])
  AC_MSG_NOTICE([    >>> use --with-mpi instead])
  if test "${enable_mpi}" != ""; then
    AC_MSG_ERROR([removed option --enable-mpi has been used])
  fi

  # Removed --enable-optim option
  AC_MSG_NOTICE([  * removed option --enable-optim])
  AC_MSG_NOTICE([    >>> use --with-optim-flavor instead])
  if test "${enable_optim}" != ""; then
    AC_MSG_ERROR([removed option --enable-optim has been used])
  fi

  # Removed --enable-wannier90-v1 option
  AC_MSG_NOTICE([  * removed option --enable-wannier90-v1])
  if test "${enable_wannier90_v1}" != ""; then
    AC_MSG_ERROR([removed option --enable-wannier90-v1 has been used])
  fi

  # Removed --with-algo-flavor option
  AC_MSG_NOTICE([  * removed option --with-algo-flavor])
  AC_MSG_NOTICE([    >>> use --with-levmar instead])
  if test "${with_algo_flavor}" != ""; then
    AC_MSG_ERROR([removed option --with-algo-flavor has been used])
  fi

  # Removed --with-algo-incs option
  AC_MSG_NOTICE([  * removed option --with-algo-incs])
  AC_MSG_NOTICE([    >>> use LEVMAR_CPPFLAGS, LEVMAR_FCFLAGS instead])
  if test "${with_algo_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-algo-incs has been used])
  fi

  # Removed --with-algo-libs option
  AC_MSG_NOTICE([  * removed option --with-algo-libs])
  AC_MSG_NOTICE([    >>> use LEVMAR_LIBS instead])
  if test "${with_algo_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-algo-libs has been used])
  fi

  # Removed --with-atompaw-bins option
  AC_MSG_NOTICE([  * removed option --with-atompaw-bins])
  if test "${with_atompaw_bins}" != ""; then
    AC_MSG_ERROR([removed option --with-atompaw-bins has been used])
  fi

  # Removed --with-atompaw-incs option
  AC_MSG_NOTICE([  * removed option --with-atompaw-incs])
  if test "${with_atompaw_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-atompaw-incs has been used])
  fi

  # Removed --with-atompaw-libs option
  AC_MSG_NOTICE([  * removed option --with-atompaw-libs])
  if test "${with_atompaw_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-atompaw-libs has been used])
  fi

  # Removed --with-dft-flavor option
  AC_MSG_NOTICE([  * removed option --with-dft-flavor])
  AC_MSG_NOTICE([    >>> use --individual package options instead])
  if test "${with_dft_flavor}" != ""; then
    AC_MSG_ERROR([removed option --with-dft-flavor has been used])
  fi

  # Removed --with-fft-incs option
  AC_MSG_NOTICE([  * removed option --with-fft-incs])
  AC_MSG_NOTICE([    >>> use FFT_CPPFLAGS, FFT_FCFLAGS instead])
  if test "${with_fft_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-fft-incs has been used])
  fi

  # Removed --with-fft-libs option
  AC_MSG_NOTICE([  * removed option --with-fft-libs])
  AC_MSG_NOTICE([    >>> use FFT_LIBS instead])
  if test "${with_fft_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-fft-libs has been used])
  fi

  # Removed --with-gpu-cflags option
  AC_MSG_NOTICE([  * removed option --with-gpu-cflags])
  AC_MSG_NOTICE([    >>> use GPU_CFLAGS instead])
  if test "${with_gpu_cflags}" != ""; then
    AC_MSG_ERROR([removed option --with-gpu-cflags has been used])
  fi

  # Removed --with-gpu-cppflags option
  AC_MSG_NOTICE([  * removed option --with-gpu-cppflags])
  AC_MSG_NOTICE([    >>> use GPU_CPPFLAGS instead])
  if test "${with_gpu_cppflags}" != ""; then
    AC_MSG_ERROR([removed option --with-gpu-cppflags has been used])
  fi

  # Removed --with-gpu-incs option
  AC_MSG_NOTICE([  * removed option --with-gpu-incs])
  AC_MSG_NOTICE([    >>> use GPU_CPPFLAGS, GPU_FCFLAGS instead])
  if test "${with_gpu_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-gpu-incs has been used])
  fi

  # Removed --with-gpu-ldflags option
  AC_MSG_NOTICE([  * removed option --with-gpu-ldflags])
  AC_MSG_NOTICE([    >>> use GPU_LDFLAGS instead])
  if test "${with_gpu_ldflags}" != ""; then
    AC_MSG_ERROR([removed option --with-gpu-ldflags has been used])
  fi

  # Removed --with-gpu-libs option
  AC_MSG_NOTICE([  * removed option --with-gpu-libs])
  AC_MSG_NOTICE([    >>> use GPU_LIBS instead])
  if test "${with_gpu_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-gpu-libs has been used])
  fi

  # Removed --with-gpu-prefix option
  AC_MSG_NOTICE([  * removed option --with-gpu-prefix])
  AC_MSG_NOTICE([    >>> use --with-gpu instead])
  if test "${with_gpu_prefix}" != ""; then
    AC_MSG_ERROR([removed option --with-gpu-prefix has been used])
  fi

  # Removed --with-libxc-incs option
  AC_MSG_NOTICE([  * removed option --with-libxc-incs])
  AC_MSG_NOTICE([    >>> use LIBXC_CPPFLAGS, LIBXC_FCFLAGS instead])
  if test "${with_libxc_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-libxc-incs has been used])
  fi

  # Removed --with-libxc-libs option
  AC_MSG_NOTICE([  * removed option --with-libxc-libs])
  AC_MSG_NOTICE([    >>> use LIBXC_LIBS instead])
  if test "${with_libxc_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-libxc-libs has been used])
  fi

  # Removed --with-linalg-incs option
  AC_MSG_NOTICE([  * removed option --with-linalg-incs])
  AC_MSG_NOTICE([    >>> use LINALG_FCFLAGS instead])
  if test "${with_linalg_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-linalg-incs has been used])
  fi

  # Removed --with-linalg-libs option
  AC_MSG_NOTICE([  * removed option --with-linalg-libs])
  AC_MSG_NOTICE([    >>> use LINALG_LIBS instead])
  if test "${with_linalg_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-linalg-libs has been used])
  fi

  # Removed --with-math-flavor option
  AC_MSG_NOTICE([  * removed option --with-math-flavor])
  if test "${with_math_flavor}" != ""; then
    AC_MSG_ERROR([removed option --with-math-flavor has been used])
  fi

  # Removed --with-math-incs option
  AC_MSG_NOTICE([  * removed option --with-math-incs])
  if test "${with_math_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-math-incs has been used])
  fi

  # Removed --with-math-libs option
  AC_MSG_NOTICE([  * removed option --with-math-libs])
  if test "${with_math_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-math-libs has been used])
  fi

  # Removed --with-mpi-incs option
  AC_MSG_NOTICE([  * removed option --with-mpi-incs])
  AC_MSG_NOTICE([    >>> use MPI_CPPFLAGS, MPI_FCFLAGS instead])
  if test "${with_mpi_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-mpi-incs has been used])
  fi

  # Removed --with-mpi-libs option
  AC_MSG_NOTICE([  * removed option --with-mpi-libs])
  AC_MSG_NOTICE([    >>> use MPI_LIBS instead])
  if test "${with_mpi_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-mpi-libs has been used])
  fi

  # Removed --with-mpi-prefix option
  AC_MSG_NOTICE([  * removed option --with-mpi-prefix])
  AC_MSG_NOTICE([    >>> use --with-mpi instead])
  if test "${with_mpi_prefix}" != ""; then
    AC_MSG_ERROR([removed option --with-mpi-prefix has been used])
  fi

  # Removed --with-psml-incs option
  AC_MSG_NOTICE([  * removed option --with-psml-incs])
  AC_MSG_NOTICE([    >>> use LIBPSML_FCFLAGS instead])
  if test "${with_psml_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-psml-incs has been used])
  fi

  # Removed --with-psml-libs option
  AC_MSG_NOTICE([  * removed option --with-psml-libs])
  AC_MSG_NOTICE([    >>> use LIBPSML_LIBS instead])
  if test "${with_psml_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-psml-libs has been used])
  fi

  # Removed --with-timer-flavor option
  AC_MSG_NOTICE([  * removed option --with-timer-flavor])
  if test "${with_timer_flavor}" != ""; then
    AC_MSG_ERROR([removed option --with-timer-flavor has been used])
  fi

  # Removed --with-timer-incs option
  AC_MSG_NOTICE([  * removed option --with-timer-incs])
  AC_MSG_NOTICE([    >>> use PAPI_CPPFLAGS, PAPI_FCFLAGS instead])
  if test "${with_timer_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-timer-incs has been used])
  fi

  # Removed --with-timer-libs option
  AC_MSG_NOTICE([  * removed option --with-timer-libs])
  AC_MSG_NOTICE([    >>> use PAPI_LIBS instead])
  if test "${with_timer_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-timer-libs has been used])
  fi

  # Removed --with-trio-flavor option
  AC_MSG_NOTICE([  * removed option --with-trio-flavor])
  AC_MSG_NOTICE([    >>> use --individual package options instead])
  if test "${with_trio_flavor}" != ""; then
    AC_MSG_ERROR([removed option --with-trio-flavor has been used])
  fi

  # Removed --with-triqs-incs option
  AC_MSG_NOTICE([  * removed option --with-triqs-incs])
  AC_MSG_NOTICE([    >>> use TRIQS_CPPFLAGS, TRIQS_FCFLAGS instead])
  if test "${with_triqs_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-triqs-incs has been used])
  fi

  # Removed --with-triqs-libs option
  AC_MSG_NOTICE([  * removed option --with-triqs-libs])
  AC_MSG_NOTICE([    >>> use TRIQS_LIBS instead])
  if test "${with_triqs_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-triqs-libs has been used])
  fi

  # Removed --with-wannier90-bins option
  AC_MSG_NOTICE([  * removed option --with-wannier90-bins])
  if test "${with_wannier90_bins}" != ""; then
    AC_MSG_ERROR([removed option --with-wannier90-bins has been used])
  fi

  # Removed --with-wannier90-incs option
  AC_MSG_NOTICE([  * removed option --with-wannier90-incs])
  AC_MSG_NOTICE([    >>> use WANNIER90_FCFLAGS instead])
  if test "${with_wannier90_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-wannier90-incs has been used])
  fi

  # Removed --with-wannier90-libs option
  AC_MSG_NOTICE([  * removed option --with-wannier90-libs])
  AC_MSG_NOTICE([    >>> use WANNIER90_LIBS instead])
  if test "${with_wannier90_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-wannier90-libs has been used])
  fi

  # Removed --with-yaml-incs option
  AC_MSG_NOTICE([  * removed option --with-yaml-incs])
  if test "${with_yaml_incs}" != ""; then
    AC_MSG_ERROR([removed option --with-yaml-incs has been used])
  fi

  # Removed --with-yaml-libs option
  AC_MSG_NOTICE([  * removed option --with-yaml-libs])
  if test "${with_yaml_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-yaml-libs has been used])
  fi

  # New --enable-libtetra option
  AC_MSG_NOTICE([  * new option --enable-libtetra is available])

  # New --enable-python-invocation option
  AC_MSG_NOTICE([  * new option --enable-python-invocation is available])

  # New --enable-source-debug option
  AC_MSG_NOTICE([  * new option --enable-source-debug is available])

  # New --enable-timer option
  AC_MSG_NOTICE([  * new option --enable-timer is available])

  # New --with-debug-flavor option
  AC_MSG_NOTICE([  * new option --with-debug-flavor is available])

  # New --with-fallbacks option
  AC_MSG_NOTICE([  * new option --with-fallbacks is available])

  # New --with-libxml2 option
  AC_MSG_NOTICE([  * new option --with-libxml2 is available])

  # New --with-optim-flavor option
  AC_MSG_NOTICE([  * new option --with-optim-flavor is available])

  # UI change for --with-mpi-level option
  AC_MSG_NOTICE([  * modified option --with-mpi-level])
  AC_MSG_NOTICE([    (changed : removed level 1, added level 3, defaulted level 2)])
  AC_MSG_NOTICE([    please check that --with-mpi-level="${with_mpi_level}" is OK for you])

  # --enable-bse-unpacked deprecated
  AC_MSG_NOTICE([  * deprecated option --enable-bse-unpacked])
  if test "${enable_bse_unpacked}" != ""; then
    AC_MSG_NOTICE([    >>> --enable-bse-unpacked = '${enable_bse_unpacked}' will soon be forbidden!])
    abi_opt_deprecated_count=`expr ${abi_opt_deprecated_count} + 1`
    abi_opt_deprecated_used="${abi_opt_deprecated_used} enable_bse_unpacked"
  fi

  # --enable-exports deprecated
  AC_MSG_NOTICE([  * deprecated option --enable-exports])
  if test "${enable_exports}" != ""; then
    AC_MSG_NOTICE([    >>> --enable-exports = '${enable_exports}' will soon be forbidden!])
    abi_opt_deprecated_count=`expr ${abi_opt_deprecated_count} + 1`
    abi_opt_deprecated_used="${abi_opt_deprecated_used} enable_exports"
  fi

  # --enable-triqs-v1-4 deprecated
  AC_MSG_NOTICE([  * deprecated option --enable-triqs-v1-4])
  if test "${enable_triqs_v1_4}" != ""; then
    AC_MSG_NOTICE([    >>> --enable-triqs-v1-4 = '${enable_triqs_v1_4}' will soon be forbidden!])
    abi_opt_deprecated_count=`expr ${abi_opt_deprecated_count} + 1`
    abi_opt_deprecated_used="${abi_opt_deprecated_used} enable_triqs_v1_4"
  fi

  # --enable-triqs-v2-0 deprecated
  AC_MSG_NOTICE([  * deprecated option --enable-triqs-v2-0])
  if test "${enable_triqs_v2_0}" != ""; then
    AC_MSG_NOTICE([    >>> --enable-triqs-v2-0 = '${enable_triqs_v2_0}' will soon be forbidden!])
    abi_opt_deprecated_count=`expr ${abi_opt_deprecated_count} + 1`
    abi_opt_deprecated_used="${abi_opt_deprecated_used} enable_triqs_v2_0"
  fi

]) # ABI_INFO_OPTIONS_CHANGED



# ABI_OPTIONS_PARSE()
# -------------------
#
# Parses command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_PARSE],[
  AC_REQUIRE([AC_PROG_EGREP])
  AC_MSG_NOTICE([parsing command-line options])

  # Parse enable_avx_safe_mode
  if test "${abi_avx_safe_mode_enable}" != ""; then
    for v in `echo "${abi_avx_safe_mode_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_avx_safe_mode = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_avx_safe_mode = ${v}])
    fi
  fi

  # Parse enable_bse_unpacked
  if test "${abi_bse_unpacked_enable}" != ""; then
    for v in `echo "${abi_bse_unpacked_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_bse_unpacked = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_bse_unpacked = ${v}])
    fi
  fi

  # Parse enable_cclock
  if test "${abi_cclock_enable}" != ""; then
    for v in `echo "${abi_cclock_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_cclock = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_cclock = ${v}])
    fi
  fi

  # Parse enable_crpa_optim
  if test "${abi_crpa_optim_enable}" != ""; then
    for v in `echo "${abi_crpa_optim_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_crpa_optim = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_crpa_optim = ${v}])
    fi
  fi

  # Parse enable_exports
  if test "${abi_exports_enable}" != ""; then
    for v in `echo "${abi_exports_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_exports = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_exports = ${v}])
    fi
  fi

  # Parse enable_fc_wrapper
  if test "${abi_fc_wrapper_enable}" != ""; then
    for v in `echo "${abi_fc_wrapper_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_fc_wrapper = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_fc_wrapper = ${v}])
    fi
  fi

  # Parse enable_gw_dpc
  if test "${abi_gw_dpc_enable}" != ""; then
    for v in `echo "${abi_gw_dpc_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_gw_dpc = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_gw_dpc = ${v}])
    fi
  fi

  # Parse enable_hints
  if test "${abi_hints_enable}" != ""; then
    for v in `echo "${abi_hints_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_hints = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_hints = ${v}])
    fi
  fi

  # Parse enable_libtetra
  if test "${abi_libtetra_enable}" != ""; then
    for v in `echo "${abi_libtetra_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_libtetra = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_libtetra = ${v}])
    fi
  fi

  # Parse enable_lotf
  if test "${abi_lotf_enable}" != ""; then
    for v in `echo "${abi_lotf_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_lotf = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_lotf = ${v}])
    fi
  fi

  # Parse enable_memory_profiling
  if test "${abi_memory_profiling_enable}" != ""; then
    for v in `echo "${abi_memory_profiling_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_memory_profiling = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_memory_profiling = ${v}])
    fi
  fi

  # Parse enable_mpi_inplace
  if test "${abi_mpi_inplace_enable}" != ""; then
    for v in `echo "${abi_mpi_inplace_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_inplace = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_mpi_inplace = ${v}])
    fi
  fi

  # Parse enable_mpi_io
  if test "${abi_mpi_io_enable}" != ""; then
    for v in `echo "${abi_mpi_io_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes auto; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_io = (no|yes|auto)])
      AC_MSG_ERROR([invalid option: enable_mpi_io = ${v}])
    fi
  fi

  # Parse enable_mpi_io_default
  if test "${abi_mpi_io_default_enable}" != ""; then
    for v in `echo "${abi_mpi_io_default_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_io_default = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_mpi_io_default = ${v}])
    fi
  fi

  # Parse enable_netcdf_default
  if test "${abi_netcdf_default_enable}" != ""; then
    for v in `echo "${abi_netcdf_default_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_netcdf_default = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_netcdf_default = ${v}])
    fi
  fi

  # Parse enable_openmp
  if test "${abi_openmp_enable}" != ""; then
    for v in `echo "${abi_openmp_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_openmp = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_openmp = ${v}])
    fi
  fi

  # Parse enable_python_invocation
  if test "${abi_python_invocation_enable}" != ""; then
    for v in `echo "${abi_python_invocation_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_python_invocation = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_python_invocation = ${v}])
    fi
  fi

  # Parse enable_source_debug
  if test "${abi_source_debug_enable}" != ""; then
    for v in `echo "${abi_source_debug_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_source_debug = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_source_debug = ${v}])
    fi
  fi

  # Parse enable_stdin
  if test "${abi_stdin_enable}" != ""; then
    for v in `echo "${abi_stdin_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_stdin = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_stdin = ${v}])
    fi
  fi

  # Parse enable_timer
  if test "${abi_timer_enable}" != ""; then
    for v in `echo "${abi_timer_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_timer = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_timer = ${v}])
    fi
  fi

  # Parse enable_triqs_v1_4
  if test "${abi_triqs_v1_4_enable}" != ""; then
    for v in `echo "${abi_triqs_v1_4_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_triqs_v1_4 = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_triqs_v1_4 = ${v}])
    fi
  fi

  # Parse enable_triqs_v2_0
  if test "${abi_triqs_v2_0_enable}" != ""; then
    for v in `echo "${abi_triqs_v2_0_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_triqs_v2_0 = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_triqs_v2_0 = ${v}])
    fi
  fi

  # Parse enable_zdot_bugfix
  if test "${abi_zdot_bugfix_enable}" != ""; then
    for v in `echo "${abi_zdot_bugfix_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_zdot_bugfix = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_zdot_bugfix = ${v}])
    fi
  fi

  # Parse with_debug_flavor
  if test "${abi_debug_flavor}" != ""; then
    for v in `echo "${abi_debug_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in none custom basic verbose enhanced paranoid naughty; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_debug_flavor = (none|custom|basic|verbose|enhanced|paranoid|naughty)])
      AC_MSG_ERROR([invalid option: with_debug_flavor = ${v}])
    fi
  fi

  # Parse with_fallbacks
 if test "${with_fallbacks}" != ""; then
    opt_ok="yes"
    if test "${with_fallbacks}" != "no" -a "${with_fallbacks}" != "yes"; then
      if test \! -d "${with_fallbacks}" -o \! -r "${with_fallbacks}"; then
        opt_ok="no"
        break
      fi
    fi
  fi

  # Parse with_libxml2
 if test "${with_libxml2}" != ""; then
    opt_ok="yes"
    if test "${with_libxml2}" != "no" -a "${with_libxml2}" != "yes"; then
      if test \! -d "${with_libxml2}" -o \! -r "${with_libxml2}"; then
        opt_ok="no"
        break
      fi
    fi
  fi

  # Parse with_mpi_level
  if test "${abi_mpi_level}" != ""; then
    for v in `echo "${abi_mpi_level}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in 2 3; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_mpi_level = (2|3)])
      AC_MSG_ERROR([invalid option: with_mpi_level = ${v}])
    fi
  fi

  # Parse with_optim_flavor
  if test "${abi_optim_flavor}" != ""; then
    for v in `echo "${abi_optim_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in none custom safe standard aggressive; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_optim_flavor = (none|custom|safe|standard|aggressive)])
      AC_MSG_ERROR([invalid option: with_optim_flavor = ${v}])
    fi
  fi

]) # ABI_OPTIONS_PARSE



# ABI_OPTIONS_CPP_DEFINES()
# -------------------------
#
# Set switches associated to 'enable_*' options (AC_DEFINE and
# AM_CONDTIONAL).
#
AC_DEFUN([ABI_OPTIONS_CPP_DEFINES],[
  AC_MSG_NOTICE([setting build switches associated to command-line options])


  # Triggers for enable_avx_safe_mode
  AC_MSG_CHECKING([whether to disable vectorization in problematic procedures])
  AC_MSG_RESULT([${abi_avx_safe_mode_enable}])

  if test "${abi_avx_safe_mode_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_AVX_SAFE_MODE' preprocessing macro])
    AC_DEFINE([HAVE_AVX_SAFE_MODE], 1,
      [Define to 1 if you want to disable vectorization in problematic procedures.])
  fi

  # Triggers for enable_bse_unpacked
  AC_MSG_CHECKING([whether to activate Bethe-Salpeter unpacking])
  AC_MSG_RESULT([${abi_bse_unpacked_enable}])

  if test "${abi_bse_unpacked_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_BSE_UNPACKED' preprocessing macro])
    AC_DEFINE([HAVE_BSE_UNPACKED], 1,
      [Define to 1 if you want to activate Bethe-Salpeter unpacking.])
  fi

  # Triggers for enable_crpa_optim
  AC_MSG_CHECKING([whether to enable optimize cRPA calculations for ifort <= 17.0])
  AC_MSG_RESULT([${abi_crpa_optim_enable}])

  if test "${abi_crpa_optim_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_CRPA_OPTIM' preprocessing macro])
    AC_DEFINE([HAVE_CRPA_OPTIM], 1,
      [Define to 1 if you want to enable optimize cRPA calculations for ifort <= 17.0.])
  fi

  # Triggers for enable_exports
  AC_MSG_CHECKING([whether to activate build of exported libraries])
  AC_MSG_RESULT([${abi_exports_enable}])

  if test "${abi_exports_enable}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_EXPORTS' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_EXPORTS],[test "${abi_exports_enable}" = "yes"])

  # Triggers for enable_gw_dpc
  AC_MSG_CHECKING([whether to activate double-precision GW calculations])
  AC_MSG_RESULT([${abi_gw_dpc_enable}])

  if test "${abi_gw_dpc_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_GW_DPC' preprocessing macro])
    AC_DEFINE([HAVE_GW_DPC], 1,
      [Define to 1 if you want to activate double-precision GW calculations.])
  fi

  # Triggers for enable_libtetra
  AC_MSG_CHECKING([whether to activate internal support for libtetra(hedron) in ABINIT])
  AC_MSG_RESULT([${abi_libtetra_enable}])

  if test "${abi_libtetra_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LIBTETRA_ABINIT' preprocessing macro])
    AC_DEFINE([HAVE_LIBTETRA_ABINIT], 1,
      [Define to 1 if you want to activate internal support for libtetra(hedron) in ABINIT.])
  fi

  # Triggers for enable_lotf
  AC_MSG_CHECKING([whether to activate LOTF functionality (UNMAINTAINED)])
  AC_MSG_RESULT([${abi_lotf_enable}])

  if test "${abi_lotf_enable}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_65_LOTF_BASE' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_65_LOTF_BASE],[test "${abi_lotf_enable}" = "yes"])
  if test "${abi_lotf_enable}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_68_LOTF' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_68_LOTF],[test "${abi_lotf_enable}" = "yes"])
  if test "${abi_lotf_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LOTF' preprocessing macro])
    AC_DEFINE([HAVE_LOTF], 1,
      [Define to 1 if you want to activate LOTF functionality (UNMAINTAINED).])
  fi

  # Triggers for enable_memory_profiling
  AC_MSG_CHECKING([whether to enable memory profiling])
  AC_MSG_RESULT([${abi_memory_profiling_enable}])

  if test "${abi_memory_profiling_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_MEM_PROFILING' preprocessing macro])
    AC_DEFINE([HAVE_MEM_PROFILING], 1,
      [Define to 1 if you want to enable memory profiling.])
  fi

  # Triggers for enable_mpi_inplace
  AC_MSG_CHECKING([whether to activate support for MPI_IN_PLACE])
  AC_MSG_RESULT([${abi_mpi_inplace_enable}])

  if test "${abi_mpi_inplace_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_MPI2_INPLACE' preprocessing macro])
    AC_DEFINE([HAVE_MPI2_INPLACE], 1,
      [Define to 1 if you want to activate support for MPI_IN_PLACE.])
  fi

  # Triggers for enable_mpi_io_default
  AC_MSG_CHECKING([whether to use MPI I/O as default I/O library (maintainer-only option)])
  AC_MSG_RESULT([${abi_mpi_io_default_enable}])

  if test "${abi_mpi_io_default_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_MPI_IO_DEFAULT' preprocessing macro])
    AC_DEFINE([HAVE_MPI_IO_DEFAULT], 1,
      [Define to 1 if you want to use MPI I/O as default I/O library (maintainer-only option).])
  fi

  # Triggers for enable_netcdf_default
  AC_MSG_CHECKING([whether to use NetCDF as default I/O library (maintainer-only option)])
  AC_MSG_RESULT([${abi_netcdf_default_enable}])

  if test "${abi_netcdf_default_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_NETCDF_DEFAULT' preprocessing macro])
    AC_DEFINE([HAVE_NETCDF_DEFAULT], 1,
      [Define to 1 if you want to use NetCDF as default I/O library (maintainer-only option).])
  fi

  # Triggers for enable_openmp
  AC_MSG_CHECKING([whether to activate support for OpenMP])
  AC_MSG_RESULT([${abi_openmp_enable}])

  if test "${abi_openmp_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_OPENMP' preprocessing macro])
    AC_DEFINE([HAVE_OPENMP], 1,
      [Define to 1 if you want to activate support for OpenMP.])
  fi

  # Triggers for enable_python_invocation
  AC_MSG_CHECKING([whether to activate possibility to call python scripts externally by invoking a python interpreter])
  AC_MSG_RESULT([${abi_python_invocation_enable}])

  if test "${abi_python_invocation_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_PYTHON_INVOCATION' preprocessing macro])
    AC_DEFINE([HAVE_PYTHON_INVOCATION], 1,
      [Define to 1 if you want to activate possibility to call python scripts externally by invoking a python interpreter.])
  fi

  # Triggers for enable_stdin
  AC_MSG_CHECKING([whether to tell ABINIT to read file lists from standard input])
  AC_MSG_RESULT([${abi_stdin_enable}])

  if test "${abi_stdin_enable}" = "no"; then
    AC_MSG_NOTICE([defining the 'READ_FROM_FILE' preprocessing macro])
    AC_DEFINE([READ_FROM_FILE], 1,
      [Define to 1 if you want to tell ABINIT to read file lists from standard input.])
  fi

  # Triggers for enable_triqs_v1_4
  AC_MSG_CHECKING([whether to activate internal support for TRIQS 1.4])
  AC_MSG_RESULT([${abi_triqs_v1_4_enable}])

  if test "${abi_triqs_v1_4_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_TRIQS_v1_4' preprocessing macro])
    AC_DEFINE([HAVE_TRIQS_v1_4], 1,
      [Define to 1 if you want to activate internal support for TRIQS 1.4.])
  fi

  # Triggers for enable_triqs_v2_0
  AC_MSG_CHECKING([whether to activate internal support for TRIQS 2.0 (This option is dominant over the others versions)])
  AC_MSG_RESULT([${abi_triqs_v2_0_enable}])

  if test "${abi_triqs_v2_0_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_TRIQS_v2_0' preprocessing macro])
    AC_DEFINE([HAVE_TRIQS_v2_0], 1,
      [Define to 1 if you want to activate internal support for TRIQS 2.0 (This option is dominant over the others versions).])
  fi

  # Triggers for enable_zdot_bugfix
  AC_MSG_CHECKING([whether to activate workaround for bugged ZDOTC and ZDOTU])
  AC_MSG_RESULT([${abi_zdot_bugfix_enable}])

  if test "${abi_zdot_bugfix_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LINALG_ZDOTC_BUG' preprocessing macro])
    AC_DEFINE([HAVE_LINALG_ZDOTC_BUG], 1,
      [Define to 1 if you want to activate workaround for bugged ZDOTC and ZDOTU.])
  fi
  if test "${abi_zdot_bugfix_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LINALG_ZDOTU_BUG' preprocessing macro])
    AC_DEFINE([HAVE_LINALG_ZDOTU_BUG], 1,
      [Define to 1 if you want to activate workaround for bugged ZDOTC and ZDOTU.])
  fi
]) # ABI_OPTIONS_CPP_DEFINES
